/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.store.mail.model.Message;
import org.reactivestreams.Publisher;

public final class InputStreamContent
implements Content {
    private final Message m;
    private final Type type;

    public InputStreamContent(Message m, Type type) throws IOException {
        this.m = m;
        this.type = type;
    }

    public long size() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.m.getFullContentOctets();
            }
        }
        return this.m.getBodyOctets();
    }

    public InputStream getInputStream() throws IOException {
        switch (this.type.ordinal()) {
            case 0: {
                return this.m.getFullContent();
            }
        }
        return this.m.getBodyContent();
    }

    public Optional<byte[][]> asBytesSequence() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.m.getFullBytes();
            }
        }
        return this.m.getBodyBytes();
    }

    public Publisher<ByteBuffer> reactiveBytes() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.m.getFullContentReactive();
            }
        }
        return this.m.getBodyContentReactive();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("InputStreamContent{");
        sb.append("m=").append(this.m);
        sb.append(", type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }

    public static enum Type {
        FULL,
        BODY;

    }
}

