/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.field.contenttype.parser.ContentTypeParser;
import org.apache.james.mime4j.field.contenttype.parser.ParseException;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;

public class ContentType {
    private final String value;
    private final Optional<MimeType> mimeType;
    private final Optional<Charset> charset;

    public static ContentType of(String value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"'content type' is mandatory");
        return new ContentType(value, Optional.empty(), Optional.empty());
    }

    public static ContentType of(MimeType mimeType) {
        return new ContentType(mimeType.asString(), Optional.of(mimeType), Optional.empty());
    }

    public static ContentType of(MimeType mimeType, Optional<Charset> charset) {
        return new ContentType(charset.map(value -> mimeType.asString() + "; charset=" + value.name()).orElse(mimeType.asString()), Optional.of(mimeType), charset);
    }

    private ContentType(String value, Optional<MimeType> mimeType, Optional<Charset> charset) {
        this.value = value;
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public ContentTypeField asMime4J() {
        return (ContentTypeField)ContentTypeFieldLenientImpl.PARSER.parse((Field)new RawField("Content-Type", this.value), DecodeMonitor.SILENT);
    }

    public MimeType mimeType() {
        return this.mimeType.orElseGet(() -> {
            ContentTypeField contentTypeField = this.asMime4J();
            return MimeType.of(MediaType.of(contentTypeField.getMediaType()), SubType.of(contentTypeField.getSubType()));
        });
    }

    public MediaType mediaType() {
        return this.mimeType().mediaType;
    }

    public SubType subType() {
        return this.mimeType().subType;
    }

    public Optional<Charset> charset() {
        return this.charset.or(() -> Optional.ofNullable(this.asMime4J().getCharset()).filter(s -> !s.isBlank()).map(Charset::forName));
    }

    public String asString() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof ContentType) {
            ContentType that = (ContentType)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public static class MimeType {
        private final MediaType mediaType;
        private final SubType subType;

        public static MimeType of(String value) {
            ContentTypeParser parser = new ContentTypeParser((Reader)new StringReader(value));
            try {
                parser.parseAll();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Invalid mimeType", e);
            }
            return new MimeType(new MediaType(parser.getType()), new SubType(parser.getSubType()));
        }

        public static MimeType of(MediaType mediaType, SubType subType) {
            return new MimeType(mediaType, subType);
        }

        private MimeType(MediaType mediaType, SubType subType) {
            this.mediaType = mediaType;
            this.subType = subType;
        }

        public String asString() {
            return this.mediaType.asString() + "/" + this.subType.asString();
        }

        public final boolean equals(Object o) {
            if (o instanceof MimeType) {
                MimeType mimeType = (MimeType)o;
                return Objects.equals(this.mediaType, mimeType.mediaType) && Objects.equals(this.subType, mimeType.subType);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mediaType, this.subType);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("mediaType", (Object)this.mediaType).add("subType", (Object)this.subType).toString();
        }
    }

    public static class MediaType {
        public static final MediaType TEXT = MediaType.of("text");
        private final String value;

        public static MediaType of(String value) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"'media type' is mandatory");
            return new MediaType(value);
        }

        private MediaType(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof MediaType) {
                MediaType mediaType = (MediaType)o;
                return Objects.equals(this.value, mediaType.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }

    public static class SubType {
        private final String value;

        public static SubType of(String value) {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (Object)"'sub type' is mandatory");
            return new SubType(value);
        }

        private SubType(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof SubType) {
                SubType subType = (SubType)o;
                return Objects.equals(this.value, subType.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

