/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.opensearch.core.search.SourceConfigParam;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class ExistsSourceRequest
extends RequestBase {
    @Nullable
    private final SourceConfigParam source;
    private final List<String> sourceExcludes;
    private final List<String> sourceIncludes;
    private final String id;
    private final String index;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean realtime;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final Endpoint<ExistsSourceRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<ExistsSourceRequest>("opensearch/exists_source", request -> "HEAD", request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_source");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.realtime != null) {
            params.put("realtime", String.valueOf(request.realtime));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.source != null) {
            params.put("_source", request.source._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.sourceExcludes)) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.sourceIncludes)) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, null);

    private ExistsSourceRequest(Builder builder) {
        this.source = builder.source;
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.preference = builder.preference;
        this.realtime = builder.realtime;
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static ExistsSourceRequest of(Function<Builder, ObjectBuilder<ExistsSourceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfigParam source() {
        return this.source;
    }

    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean realtime() {
        return this.realtime;
    }

    @Nullable
    public final Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    public Builder toBuilder() {
        return new Builder().source(this.source).sourceExcludes(this.sourceExcludes).sourceIncludes(this.sourceIncludes).id(this.id).index(this.index).preference(this.preference).realtime(this.realtime).refresh(this.refresh).routing(this.routing).version(this.version).versionType(this.versionType);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExistsSourceRequest> {
        @Nullable
        private SourceConfigParam source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        private String id;
        private String index;
        @Nullable
        private String preference;
        @Nullable
        private Boolean realtime;
        @Nullable
        private Boolean refresh;
        @Nullable
        private String routing;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public final Builder source(@Nullable SourceConfigParam value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfigParam.Builder, ObjectBuilder<SourceConfigParam>> fn) {
            return this.source(fn.apply(new SourceConfigParam.Builder()).build());
        }

        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder realtime(@Nullable Boolean value) {
            this.realtime = value;
            return this;
        }

        public final Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        public ExistsSourceRequest build() {
            this._checkSingleUse();
            return new ExistsSourceRequest(this);
        }
    }
}

