/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.document.BinaryRangeDocValues;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

abstract class BinaryRangeFieldRangeQuery
extends Query {
    private final String field;
    private byte[] queryPackedValue;
    private final int numBytesPerDimension;
    private final ArrayUtil.ByteArrayComparator comparator;
    private final int numDims;
    private final RangeFieldQuery.QueryType queryType;

    BinaryRangeFieldRangeQuery(String field, byte[] queryPackedValue, int numBytesPerDimension, int numDims, RangeFieldQuery.QueryType queryType) {
        this.field = field;
        this.queryPackedValue = queryPackedValue;
        this.numBytesPerDimension = numBytesPerDimension;
        this.comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
        this.numDims = numDims;
        if (queryType != RangeFieldQuery.QueryType.INTERSECTS) {
            throw new UnsupportedOperationException("INTERSECTS is the only query type supported for this field type right now");
        }
        this.queryType = queryType;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        BinaryRangeFieldRangeQuery that = (BinaryRangeFieldRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Arrays.equals(this.queryPackedValue, that.queryPackedValue);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Arrays.hashCode(this.queryPackedValue);
        return h;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    private BinaryRangeDocValues getValues(LeafReader reader, String field) throws IOException {
        if (reader.getFieldInfos().fieldInfo(field) == null) {
            return null;
        }
        return new BinaryRangeDocValues(DocValues.getBinary(reader, field), this.numDims, this.numBytesPerDimension);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context2) throws IOException {
                final BinaryRangeDocValues values = BinaryRangeFieldRangeQuery.this.getValues(context2.reader(), BinaryRangeFieldRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() {
                        return BinaryRangeFieldRangeQuery.this.queryType.matches(BinaryRangeFieldRangeQuery.this.queryPackedValue, values.getPackedValue(), BinaryRangeFieldRangeQuery.this.numDims, BinaryRangeFieldRangeQuery.this.numBytesPerDimension, BinaryRangeFieldRangeQuery.this.comparator);
                    }

                    @Override
                    public float matchCost() {
                        return BinaryRangeFieldRangeQuery.this.queryPackedValue.length;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, BinaryRangeFieldRangeQuery.this.field);
            }
        };
    }
}

