/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Contact
extends OpenApiElement {
    private String name;
    private URI url;
    private String email;

    public Contact() {
    }

    public Contact(Contact copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.url = copyFrom.url;
        this.email = copyFrom.email;
    }

    public Contact copy() {
        return new Contact(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "name" -> ConverterUtils.toType((Object)this.getName(), type);
            case "url" -> ConverterUtils.toType((Object)this.getUrl(), type);
            case "email" -> ConverterUtils.toType((Object)this.getEmail(), type);
            default -> super.get(property, type);
        });
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public URI getUrl() {
        return this.url;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.email), (Object)"email").addIf(Utils.nn((Object)this.name), (Object)"name").addIf(Utils.nn((Object)this.url), (Object)"url").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Contact set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "email" -> this.setEmail(Utils.s((Object)value));
            case "name" -> this.setName(Utils.s((Object)value));
            case "url" -> this.setUrl(StringUtils.toUri((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Contact setEmail(String value) {
        this.email = value;
        return this;
    }

    public Contact setName(String value) {
        this.name = value;
        return this;
    }

    public Contact setUrl(URI value) {
        this.url = value;
        return this;
    }

    @Override
    public Contact strict() {
        super.strict();
        return this;
    }

    @Override
    public Contact strict(Object value) {
        super.strict(value);
        return this;
    }
}

