/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;

public class RrpcInterfaceMeta {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final Map<Method, RrpcInterfaceMethodMeta> methods;
    private final Map<String, RrpcInterfaceMethodMeta> methodsByPath;
    private final String path;
    private final Class<?> c;

    public RrpcInterfaceMeta(Class<?> c, String uri) {
        this.c = c;
        Value path = Value.of((Object)"");
        ClassInfoTyped ci = ClassInfo.of(c);
        CollectionUtils.rstream((List)AP.find(Remote.class, (ClassInfo)ci, new AnnotationTraversal[0])).map(x -> ((Remote)x.inner()).path()).filter(Utils::ne).forEach(x -> path.set((Object)StringUtils.trimSlashes((String)x)));
        LinkedHashMap methods = CollectionUtils.map();
        ci.getPublicMethods().stream().forEach(x -> methods.put(x.inner(), new RrpcInterfaceMethodMeta(uri, x.inner())));
        LinkedHashMap methodsByPath = CollectionUtils.map();
        methods.values().forEach(x -> methodsByPath.put(x.getPath(), x));
        this.methods = CollectionUtils.u((Map)methods);
        this.methodsByPath = CollectionUtils.u((Map)methodsByPath);
        this.path = (String)path.get();
    }

    public Class<?> getJavaClass() {
        return this.c;
    }

    public RrpcInterfaceMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public RrpcInterfaceMethodMeta getMethodMetaByPath(String p) {
        return this.methodsByPath.get(p);
    }

    public Map<String, RrpcInterfaceMethodMeta> getMethodsByPath() {
        return this.methodsByPath;
    }

    public String getPath() {
        return this.path;
    }
}

