/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.juneau.commons.collections.CacheMode;
import org.apache.juneau.commons.function.Tuple1;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.SystemUtils;
import org.apache.juneau.commons.utils.Utils;

public class Cache<K, V> {
    private final Map<Tuple1<K>, V> map;
    private final ThreadLocal<Map<Tuple1<K>, V>> threadLocalMap;
    private final boolean isThreadLocal;
    private final Map<K, Tuple1<K>> wrapperCache;
    private final ThreadLocal<Map<K, Tuple1<K>>> threadLocalWrapperCache;
    private final int maxSize;
    private final boolean disableCaching;
    private final Function<K, V> supplier;
    private final AtomicInteger cacheHits = new AtomicInteger();

    public static <K, V> Builder<K, V> create() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> of(Class<K> key, Class<V> type) {
        return new Builder();
    }

    protected Cache(Builder<K, V> builder) {
        this.maxSize = builder.maxSize;
        this.disableCaching = builder.cacheMode == CacheMode.NONE;
        this.supplier = builder.supplier != null ? builder.supplier : K -> null;
        this.isThreadLocal = builder.threadLocal;
        if (this.isThreadLocal) {
            if (builder.cacheMode == CacheMode.WEAK) {
                this.threadLocalMap = ThreadLocal.withInitial(() -> Collections.synchronizedMap(new WeakHashMap()));
                this.threadLocalWrapperCache = ThreadLocal.withInitial(() -> Collections.synchronizedMap(new WeakHashMap()));
            } else {
                this.threadLocalMap = ThreadLocal.withInitial(() -> new ConcurrentHashMap());
                this.threadLocalWrapperCache = ThreadLocal.withInitial(() -> Collections.synchronizedMap(new WeakHashMap()));
            }
            this.map = null;
            this.wrapperCache = null;
        } else {
            if (builder.cacheMode == CacheMode.WEAK) {
                this.map = Collections.synchronizedMap(new WeakHashMap());
                this.wrapperCache = Collections.synchronizedMap(new WeakHashMap());
            } else {
                this.map = new ConcurrentHashMap<Tuple1<K>, V>();
                this.wrapperCache = Collections.synchronizedMap(new WeakHashMap());
            }
            this.threadLocalMap = null;
            this.threadLocalWrapperCache = null;
        }
        if (builder.logOnExit) {
            SystemUtils.shutdownMessage(() -> builder.id + ":  hits=" + this.cacheHits.get() + ", misses: " + this.size());
        }
    }

    public void clear() {
        this.getMap().clear();
        this.getWrapperCache().clear();
    }

    public boolean containsKey(K key) {
        return this.getMap().containsKey(this.wrap(key));
    }

    public boolean containsValue(V value) {
        if (value == null) {
            return false;
        }
        return this.getMap().containsValue(value);
    }

    public V get(K key) {
        return (V)this.get(key, () -> this.supplier.apply(key));
    }

    public V get(K key, Supplier<V> supplier) {
        Tuple1<K> wrapped;
        AssertionUtils.assertArgNotNull("supplier", supplier);
        if (this.disableCaching) {
            return supplier.get();
        }
        Map<Tuple1<Tuple1<K>>, V> m = this.getMap();
        V v = m.get(wrapped = this.wrap(key));
        if (v == null) {
            if (this.size() > this.maxSize) {
                this.clear();
            }
            if ((v = supplier.get()) == null) {
                m.remove(wrapped);
            } else {
                m.putIfAbsent(wrapped, v);
            }
        } else {
            this.cacheHits.incrementAndGet();
        }
        return v;
    }

    public int getCacheHits() {
        return this.cacheHits.get();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public V put(K key, V value) {
        Map<Tuple1<Tuple1<K>>, V> m = this.getMap();
        if (value == null) {
            Tuple1<K> wrapped = this.wrap(key);
            V result = m.remove(wrapped);
            this.getWrapperCache().remove(key);
            return result;
        }
        return m.put(this.wrap(key), value);
    }

    public V remove(K key) {
        Map<Tuple1<K>, V> m = this.getMap();
        Tuple1<K> wrapped = this.wrap(key);
        V result = m.remove(wrapped);
        this.getWrapperCache().remove(key);
        return result;
    }

    public int size() {
        return this.getMap().size();
    }

    private Map<Tuple1<K>, V> getMap() {
        return this.isThreadLocal ? this.threadLocalMap.get() : this.map;
    }

    private Map<K, Tuple1<K>> getWrapperCache() {
        return this.isThreadLocal ? this.threadLocalWrapperCache.get() : this.wrapperCache;
    }

    private Tuple1<K> wrap(K key) {
        return this.getWrapperCache().computeIfAbsent(key, k -> Tuple1.of(k));
    }

    public static class Builder<K, V> {
        CacheMode cacheMode = Utils.env("juneau.cache.mode", CacheMode.FULL);
        int maxSize = Utils.env("juneau.cache.maxSize", 1000);
        String id = "Cache";
        boolean logOnExit = Utils.env("juneau.cache.logOnExit", false);
        boolean threadLocal;
        Function<K, V> supplier;

        Builder() {
        }

        public Cache<K, V> build() {
            return new Cache(this);
        }

        public Builder<K, V> cacheMode(CacheMode value) {
            this.cacheMode = value;
            return this;
        }

        public Builder<K, V> logOnExit(boolean value, String idValue) {
            this.id = idValue;
            this.logOnExit = value;
            return this;
        }

        public Builder<K, V> logOnExit(String value) {
            this.id = value;
            this.logOnExit = true;
            return this;
        }

        public Builder<K, V> maxSize(int value) {
            this.maxSize = value;
            return this;
        }

        public Builder<K, V> supplier(Function<K, V> value) {
            this.supplier = value;
            return this;
        }

        public Builder<K, V> threadLocal() {
            this.threadLocal = true;
            return this;
        }

        public Builder<K, V> weak() {
            return this.cacheMode(CacheMode.WEAK);
        }
    }
}

