/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.ExternalKRaftMetrics;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftManager;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.TimingWheelExpirationService;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.LocalLog;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rEq!\u0002\u001e<\u0011\u0003\u0001e!\u0002\"<\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005\"\u0002'\u0002\t\u0013i\u0005\"B3\u0002\t\u00131\u0007\"\u0002<\u0002\t\u00139h!\u0002\"<\u0001\u0005\u0015\u0001\"CA!\r\t\u0005\t\u0015!\u0003[\u0011!ahA!A!\u0002\u0013i\bBCA\"\r\t\u0005\t\u0015!\u0003\u0002F!Q\u0011\u0011\u000b\u0004\u0003\u0002\u0003\u0006I!a\u0015\t\u0015\u0005\u0005dA!A!\u0002\u0013\t\u0019\u0007\u0003\u0006\u0002j\u0019\u0011\t\u0011)A\u0005\u0003\u000bB!\"a\u001b\u0007\u0005\u0003\u0005\u000b\u0011BA7\u0011)\t9H\u0002B\u0001B\u0003%\u0011\u0011\u0010\u0005\u000b\u0003\u00073!\u0011!Q\u0001\n\u0005\u0015\u0005BCAF\r\t\u0005\t\u0015!\u0003\u0002\u000e\"Q\u00111\u0013\u0004\u0003\u0006\u0004%\t!!&\t\u0015\u0005}fA!A!\u0002\u0013\t9\n\u0003\u0006\u0002B\u001a\u0011\t\u0011)A\u0005\u0003\u0007D!\"!3\u0007\u0005\u0003\u0005\u000b\u0011BAf\u0011)\t\tN\u0002B\u0001B\u0003%\u00111\u001b\u0005\u0007\u0015\u001a!\t!a8\t\u0013\u0005}hA1A\u0005\u0002\t\u0005\u0001\u0002\u0003B\b\r\u0001\u0006IAa\u0001\t\u0013\tEaA1A\u0005\n\tM\u0001\u0002\u0003B\u000e\r\u0001\u0006IA!\u0006\t\u0013\tuaA1A\u0005\n\t}\u0001b\u0002B\u0011\r\u0001\u0006IA\u0017\u0005\n\u0005G1!\u0019!C\u0005\u0005KA\u0001B!\f\u0007A\u0003%!q\u0005\u0005\n\u0005_1!\u0019!C\u0005\u0005cA\u0001B!\u000f\u0007A\u0003%!1\u0007\u0005\tk\u001a\u0011\r\u0011\"\u0003\u0003<!9!Q\b\u0004!\u0002\u0013q\u0005\"\u0003B \r\t\u0007I\u0011\u0002B!\u0011!\u0011)E\u0002Q\u0001\n\t\r\u0003\"\u0003B$\r\t\u0007I\u0011\tB%\u0011!\u0011\tF\u0002Q\u0001\n\t-\u0003\"\u0003B*\r\t\u0007I\u0011\u0002B+\u0011!\u0011iF\u0002Q\u0001\n\t]\u0003\"\u0003B0\r\t\u0007I\u0011\u0002B1\u0011!\u0011yG\u0002Q\u0001\n\t\r\u0004\"\u0003B9\r\t\u0007I\u0011\u0002B:\u0011!\u0011YH\u0002Q\u0001\n\tU\u0004\"\u0003B?\r\t\u0007I\u0011\tB@\u0011!\u00119I\u0002Q\u0001\n\t\u0005\u0005\"\u0003BE\r\t\u0007I\u0011\u0002BF\u0011!\u0011\u0019J\u0002Q\u0001\n\t5\u0005b\u0002BK\r\u0011\u0005!q\u0013\u0005\b\u0005?3A\u0011\u0001BL\u0011\u001d\u0011\tK\u0002C!\u0005GCqAa7\u0007\t\u0013\u0011i\u000eC\u0004\u0003`\u001a!IA!9\t\u000f\t\rh\u0001\"\u0003\u0003f\"9!q\u001d\u0004\u0005\n\t%\bb\u0002By\r\u0011%!1\u001f\u0005\b\u0007\u001b1A\u0011IB\b\u0003AY\u0015MZ6b%\u00064G/T1oC\u001e,'O\u0003\u0002={\u0005!!/\u00194u\u0015\u0005q\u0014!B6bM.\f7\u0001\u0001\t\u0003\u0003\u0006i\u0011a\u000f\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u001c\"!\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001)\u0001\nde\u0016\fG/\u001a'pO\u0012K'/Z2u_JLHc\u0001(W1B\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0003S>T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002V!\n!a)\u001b7f\u0011\u001596\u00011\u0001O\u0003\u0019awn\u001a#je\")\u0011l\u0001a\u00015\u0006QAn\\4ESJt\u0015-\\3\u0011\u0005m\u0013gB\u0001/a!\tif)D\u0001_\u0015\tyv(\u0001\u0004=e>|GOP\u0005\u0003C\u001a\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011MR\u0001\fY>\u001c7\u000eR1uC\u0012K'\u000f\u0006\u0002hiB\u0011\u0001N]\u0007\u0002S*\u0011!n[\u0001\u0005kRLGN\u0003\u0002m[\u000611/\u001a:wKJT!A\u00108\u000b\u0005=\u0004\u0018AB1qC\u000eDWMC\u0001r\u0003\ry'oZ\u0005\u0003g&\u0014\u0001BR5mK2{7m\u001b\u0005\u0006k\u0012\u0001\rAT\u0001\bI\u0006$\u0018\rR5s\u0003IA\u0017m\u001d#jM\u001a,'/\u001a8u\u0019><G)\u001b:\u0015\u0005a\\\bCA#z\u0013\tQhIA\u0004C_>dW-\u00198\t\u000bq,\u0001\u0019A?\u0002\r\r|gNZ5h!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011A.P\u0005\u0004\u0003\u0007y(aC&bM.\f7i\u001c8gS\u001e,B!a\u0002\u0002$M9a!!\u0003\u0002\u0016\u0005U\u0002\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!+\u0001\u0003mC:<\u0017\u0002BA\n\u0003\u001b\u0011aa\u00142kK\u000e$\bCBA\f\u00037\ty\"\u0004\u0002\u0002\u001a)\u0011A(\\\u0005\u0005\u0003;\tIBA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA\u0011\u0003Ga\u0001\u0001B\u0004\u0002&\u0019\u0011\r!a\n\u0003\u0003Q\u000bB!!\u000b\u00020A\u0019Q)a\u000b\n\u0007\u00055bIA\u0004O_RD\u0017N\\4\u0011\u0007\u0015\u000b\t$C\u0002\u00024\u0019\u00131!\u00118z!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e{\u0005)Q\u000f^5mg&!\u0011qHA\u001d\u0005\u001daunZ4j]\u001e\f\u0011b\u00197vgR,'/\u00133\u0002%5,G/\u00193bi\u0006dun\u001a#jeV+\u0018\u000e\u001a\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J7\u0002\r\r|W.\\8o\u0013\u0011\ty%!\u0013\u0003\tU+\u0018\u000eZ\u0001\u0006g\u0016\u0014H-\u001a\t\u0007\u0003+\ni&a\b\u000e\u0005\u0005]#\u0002BA-\u00037\nQb]3sS\u0006d\u0017N_1uS>t'bAA&W&!\u0011qLA,\u0005-\u0011VmY8sIN+'\u000fZ3\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qIA3\u0013\u0011\t9'!\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0017\u0001\u0002;j[\u0016\u0004B!a\u001c\u0002t5\u0011\u0011\u0011\u000f\u0006\u0005\u0003w\tI%\u0003\u0003\u0002v\u0005E$\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002|\u0005}TBAA?\u0015\u0011\t9(!\u0013\n\t\u0005\u0005\u0015Q\u0010\u0002\b\u001b\u0016$(/[2t\u0003Q)\u0007\u0010^3s]\u0006d7JU1gi6+GO]5dgB!\u0011qCAD\u0013\u0011\tI)!\u0007\u0003)\u0015CH/\u001a:oC2\\%+\u00194u\u001b\u0016$(/[2t\u0003M!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007p\u00149u!\u0011)\u0015q\u0012.\n\u0007\u0005EeI\u0001\u0004PaRLwN\\\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\t9\n\u0005\u0004\u0002\u001a\u0006\u0005\u0016QU\u0007\u0003\u00037SA!!(\u0002 \u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)\u0014\u0016\u0002BAR\u00037\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!!\t9+!+\u0002.\u0006MVBAAP\u0013\u0011\tY+a(\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\f\u0005=\u0016\u0002BAY\u0003\u001b\u0011q!\u00138uK\u001e,'\u000f\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tILU\u0001\u0004]\u0016$\u0018\u0002BA_\u0003o\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003u\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016\u0004\u0013\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t!\u0019\t9+!2\u00024&!\u0011qYAP\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u000fY>\u001c\u0017\r\u001c'jgR,g.\u001a:t!\u0011\t9\"!4\n\t\u0005=\u0017\u0011\u0004\u0002\n\u000b:$\u0007o\\5oiN\f\u0011CZ1uC24\u0015-\u001e7u\u0011\u0006tG\r\\3s!\u0011\t).a7\u000e\u0005\u0005]'bAAmW\u0006)a-Y;mi&!\u0011Q\\Al\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s)y\t\t/a9\u0002f\u0006\u001d\u0018\u0011^Av\u0003[\fy/!=\u0002t\u0006U\u0018q_A}\u0003w\fi\u0010\u0005\u0003B\r\u0005}\u0001BBA!-\u0001\u0007!\fC\u0003}-\u0001\u0007Q\u0010C\u0004\u0002DY\u0001\r!!\u0012\t\u000f\u0005Ec\u00031\u0001\u0002T!9\u0011\u0011\r\fA\u0002\u0005\r\u0004bBA5-\u0001\u0007\u0011Q\t\u0005\b\u0003W2\u0002\u0019AA7\u0011\u001d\t9H\u0006a\u0001\u0003sBq!a!\u0017\u0001\u0004\t)\tC\u0004\u0002\fZ\u0001\r!!$\t\u000f\u0005Me\u00031\u0001\u0002\u0018\"9\u0011\u0011\u0019\fA\u0002\u0005\r\u0007bBAe-\u0001\u0007\u00111\u001a\u0005\b\u0003#4\u0002\u0019AAj\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0005\t\r\u0001\u0003\u0002B\u0003\u0005\u0017i!Aa\u0002\u000b\u0007\t%Q.A\u0004dY&,g\u000e^:\n\t\t5!q\u0001\u0002\f\u0003BLg+\u001a:tS>t7/\u0001\u0007ba&4VM]:j_:\u001c\b%\u0001\u0006sC\u001a$8i\u001c8gS\u001e,\"A!\u0006\u0011\t\u0005]!qC\u0005\u0005\u00053\tIB\u0001\u0007Rk>\u0014X/\\\"p]\u001aLw-A\u0006sC\u001a$8i\u001c8gS\u001e\u0004\u0013\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y+\u0005Q\u0016!\u0005;ie\u0016\fGMT1nKB\u0013XMZ5yA\u0005QAn\\4D_:$X\r\u001f;\u0016\u0005\t\u001d\u0002\u0003BA8\u0005SIAAa\u000b\u0002r\tQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\ng\u000eDW\rZ;mKJ,\"Aa\r\u0011\u0007!\u0014)$C\u0002\u00038%\u0014abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002*\u0012AT\u0001\tI\u0006$\u0018\rR5sA\u0005YA-\u0019;b\t&\u0014Hj\\2l+\t\u0011\u0019\u0005\u0005\u0003F\u0003\u001f;\u0017\u0001\u00043bi\u0006$\u0015N\u001d'pG.\u0004\u0013!\u0004:fa2L7-\u0019;fI2{w-\u0006\u0002\u0003LA!\u0011q\u0003B'\u0013\u0011\u0011y%!\u0007\u0003\u001bI+\u0007\u000f\\5dCR,G\rT8h\u00039\u0011X\r\u001d7jG\u0006$X\r\u001a'pO\u0002\n!B\\3u\u0007\"\fgN\\3m+\t\u00119\u0006\u0005\u0003\u0002\u0018\te\u0013\u0002\u0002B.\u00033\u00111cS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2\f1B\\3u\u0007\"\fgN\\3mA\u0005yQ\r\u001f9je\u0006$\u0018n\u001c8US6,'/\u0006\u0002\u0003dA!!Q\rB6\u001b\t\u00119GC\u0002\u0003j%\fQ\u0001^5nKJLAA!\u001c\u0003h\tY1+_:uK6$\u0016.\\3s\u0003A)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u0014\b%A\tfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016,\"A!\u001e\u0011\t\u0005]!qO\u0005\u0005\u0005s\nIB\u0001\u000fUS6LgnZ,iK\u0016dW\t\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002%\u0015D\b/\u001b:bi&|gnU3sm&\u001cW\rI\u0001\u0007G2LWM\u001c;\u0016\u0005\t\u0005\u0005CBA\f\u0005\u0007\u000by\"\u0003\u0003\u0003\u0006\u0006e!aD&bM.\f'+\u00194u\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005a1\r\\5f]R$%/\u001b<feV\u0011!Q\u0012\t\u0007\u0003/\u0011y)a\b\n\t\tE\u0015\u0011\u0004\u0002\u0016\u0017\u000647.\u0019*bMR\u001cE.[3oi\u0012\u0013\u0018N^3s\u00035\u0019G.[3oi\u0012\u0013\u0018N^3sA\u000591\u000f^1siV\u0004HC\u0001BM!\r)%1T\u0005\u0004\u0005;3%\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000eQ\u0006tG\r\\3SKF,Xm\u001d;\u0015\u0015\t\u0015&1\u0017Bb\u0005\u001b\u0014\t\u000e\u0005\u0004\u0002\u001a\u0006\u0005&q\u0015\t\u0005\u0005S\u0013y+\u0004\u0002\u0003,*!!QVA%\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002BY\u0005W\u0013!\"\u00119j\u001b\u0016\u001c8/Y4f\u0011\u001d\u0011)l\ra\u0001\u0005o\u000bqaY8oi\u0016DH\u000f\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011i,!\u0013\u0002\u0011I,\u0017/^3tiNLAA!1\u0003<\nq!+Z9vKN$8i\u001c8uKb$\bb\u0002Bcg\u0001\u0007!qY\u0001\u0007Q\u0016\fG-\u001a:\u0011\t\te&\u0011Z\u0005\u0005\u0005\u0017\u0014YLA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0005\u001f\u001c\u0004\u0019\u0001BT\u0003\u001d\u0011X-];fgRDqAa54\u0001\u0004\u0011).A\u0007de\u0016\fG/\u001a3US6,Wj\u001d\t\u0004\u000b\n]\u0017b\u0001Bm\r\n!Aj\u001c8h\u0003=\u0011W/\u001b7e%\u00064Go\u00117jK:$HC\u0001BA\u0003M\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u0007\"\fgN\\3m)\t\u00119&A\u0007de\u0016\fG/\u001a#bi\u0006$\u0015N\u001d\u000b\u0002\u001d\u0006\u0001\"-^5mI6+G/\u00193bi\u0006dun\u001a\u000b\u0003\u0005W\u00042!\u0011Bw\u0013\r\u0011yo\u000f\u0002\u0011\u0017\u000647.Y'fi\u0006$\u0017\r^1M_\u001e\f!CY;jY\u0012tU\r^<pe.\u001cE.[3oiR\u0011!Q\u001f\t\b\u000b\n](1`B\u0004\u0013\r\u0011IP\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\tu81A\u0007\u0003\u0005\u007fTAa!\u0001\u0002J\u00059a.\u001a;x_J\\\u0017\u0002BB\u0003\u0005\u007f\u0014A\u0002T5ti\u0016tWM\u001d(b[\u0016\u0004BA!\u0002\u0004\n%!11\u0002B\u0004\u00055qU\r^<pe.\u001cE.[3oi\u0006Y!/Z2pe\u0012\u001cVM\u001d3f)\t\t\u0019\u0006")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> serde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final ExternalKRaftMetrics externalKRaftMetrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics, this.externalKRaftMetrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.expirationTimer(), (String)"expiration timer");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        Utils.closeQuietly((AutoCloseable)this.netChannel(), (String)"net channel");
        Utils.closeQuietly((AutoCloseable)this.replicatedLog(), (String)"replicated log");
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$2 -> {
            x$2.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private KafkaRaftClient<T> buildRaftClient() {
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde(), (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Feature.KRAFT_VERSION.supportedVersionRange(), this.raftConfig());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, this.config.quorumConfig().requestTimeoutMs(), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog.logDirName((TopicPartition)logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), new MetadataLogConfig((AbstractConfig)this.config), this.config.nodeId());
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().get(0));
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)Option$.MODULE$.apply(this.config.effectiveListenerSecurityProtocolMap().get(controllerListenerName)).getOrElse((Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = "raft-client-" + this.config.nodeId();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), this.config.quorumConfig().requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    public RecordSerde<T> recordSerde() {
        return this.serde;
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> serde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, ExternalKRaftMetrics externalKRaftMetrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.serde = serde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.externalKRaftMetrics = externalKRaftMetrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext("[RaftManager id=" + config.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, this.threadNamePrefix() + "-scheduler");
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
    }
}

