/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.PartitionFetchState;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a!\u0002\u0013&\u0003\u0003Q\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\t\u0011\u0015\u0003!\u0011!Q\u0001\niB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")1\n\u0001C\u0001\u0019\"9Q\f\u0001b\u0001\n\u0013q\u0006B\u00024\u0001A\u0003%q\fC\u0004h\u0001\t\u0007I\u0011\u00020\t\r!\u0004\u0001\u0015!\u0003`\u0011\u001dI\u0007A1A\u0005\n)Daa\u001e\u0001!\u0002\u0013Y\u0007\u0002\u0003=\u0001\u0005\u0004%\t!J=\t\u000f\u0005-\u0001\u0001)A\u0005u\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111\u0004\u0005\n\u0003;\u0001\u0001\u0019!C\u0005\u0003?Aq!a\u000b\u0001A\u0003&\u0001\nC\u0005\u0002.\u0001\u0011\r\u0011\"\u0001\u00020!A\u0011q\u0007\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002:\u0001\u0011\r\u0011\"\u0003\u0002<!A\u0011\u0011\n\u0001!\u0002\u0013\ti\u0004\u0003\u0005\u0002L\u0001!\t!JA\u000e\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fB\u0001\"!\u0016\u0001\t\u0003)\u0013q\u000b\u0005\t\u0003_\u0002A\u0011A\u0013\u0002r!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAE\u0001\u0019\u0005\u00111\u0012\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!a/\u0001\t#\ti\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u00111 \u0001\u0005\u0002\u0005u\bbBA\u0000\u0001\u0011\u0005\u0011Q \u0002\u0017\u0003\n\u001cHO]1di\u001a+Go\u00195fe6\u000bg.Y4fe*\u0011aeJ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003!\nQa[1gW\u0006\u001c\u0001!\u0006\u0002,#N\u0019\u0001\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019d'D\u00015\u0015\t)t%A\u0003vi&d7/\u0003\u00028i\t9Aj\\4hS:<\u0017\u0001\u00028b[\u0016,\u0012A\u000f\t\u0003w\ts!\u0001\u0010!\u0011\u0005urS\"\u0001 \u000b\u0005}J\u0013A\u0002\u001fs_>$h(\u0003\u0002B]\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\te&A\u0003oC6,\u0007%\u0001\u0005dY&,g\u000e^%e\u0003-qW/\u001c$fi\u000eDWM]:\u0011\u00055J\u0015B\u0001&/\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5S6\f\u0018\t\u0004\u001d\u0002yU\"A\u0013\u0011\u0005A\u000bF\u0002\u0001\u0003\u0006%\u0002\u0011\ra\u0015\u0002\u0002)F\u0011Ak\u0016\t\u0003[UK!A\u0016\u0018\u0003\u000f9{G\u000f[5oOB\u0011a\nW\u0005\u00033\u0016\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG\rC\u00039\u000b\u0001\u0007!\bC\u0003G\u000b\u0001\u0007!\bC\u0003H\u000b\u0001\u0007\u0001*\u0001\bnKR\u0014\u0018nY:QC\u000e\\\u0017mZ3\u0016\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t1\fgn\u001a\u0006\u0002I\u0006!!.\u0019<b\u0013\t\u0019\u0015-A\bnKR\u0014\u0018nY:QC\u000e\\\u0017mZ3!\u0003AiW\r\u001e:jGN\u001cE.Y:t\u001d\u0006lW-A\tnKR\u0014\u0018nY:DY\u0006\u001c8OT1nK\u0002\nA\"\\3ue&\u001c7o\u0012:pkB,\u0012a\u001b\t\u0003YVl\u0011!\u001c\u0006\u0003]>\fq!\\3ue&\u001c7O\u0003\u0002'a*\u0011\u0001&\u001d\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002w[\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003A1W\r^2iKJ$\u0006N]3bI6\u000b\u0007/F\u0001{!\u0019Y\u0018\u0011AA\u0003\u001f6\tAP\u0003\u0002~}\u00069Q.\u001e;bE2,'BA@/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0007a(a\u0002%bg\"l\u0015\r\u001d\t\u0004\u001d\u0006\u001d\u0011bAA\u0005K\t!\"I]8lKJLE-\u00118e\r\u0016$8\r[3s\u0013\u0012\f\u0011CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199!\u0003\u0011awnY6\u0016\u0005\u0005E\u0001c\u00011\u0002\u0014%\u0019\u0011QC1\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0003QqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6feV\t\u0001*\u0001\rok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM]0%KF$B!!\t\u0002(A\u0019Q&a\t\n\u0007\u0005\u0015bF\u0001\u0003V]&$\b\u0002CA\u0015#\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'A\u000bok64U\r^2iKJ\u001c\b+\u001a:Ce>\\WM\u001d\u0011\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cXCAA\u0019!\rq\u00151G\u0005\u0004\u0003k)#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003E1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0005i\u0006<7/\u0006\u0002\u0002>A1\u0011qHA#?jj!!!\u0011\u000b\u0007\u0005\r3-\u0001\u0003vi&d\u0017\u0002BA$\u0003\u0003\u00121!T1q\u0003\u0015!\u0018mZ:!\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\t\t#!\u0015\t\r\u0005M\u0003\u00041\u0001I\u0003\u001dqWm^*ju\u0016\f!bZ3u\r\u0016$8\r[3s)\u0011\tI&a\u0018\u0011\t5\nYfT\u0005\u0004\u0003;r#AB(qi&|g\u000eC\u0004\u0002be\u0001\r!a\u0019\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011QMA6\u001b\t\t9GC\u0002\u0002jA\faaY8n[>t\u0017\u0002BA7\u0003O\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007hKR4U\r^2iKJLE\rF\u0002I\u0003gBq!!\u0019\u001b\u0001\u0004\t\u0019'A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\t\u0003C\tI(! \u0002\u0000!1\u00111P\u000eA\u0002!\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003CZ\u0002\u0019AA2\u0011\u001d\t\ti\u0007a\u0001\u0003\u0007\u000b\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0011\u00075\n))C\u0002\u0002\b:\u0012A\u0001T8oO\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR)q*!$\u0002\u0012\"1\u0011q\u0012\u000fA\u0002!\u000b\u0011BZ3uG\",'/\u00133\t\u000f\u0005ME\u00041\u0001\u0002\u0016\u0006a1o\\;sG\u0016\u0014%o\\6feB!\u0011qSAO\u001b\t\tIJC\u0002\u0002\u001c>\fqA\\3uo>\u00148.\u0003\u0003\u0002 \u0006e%A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\u0018C\u0012$g)\u001a;dQ\u0016\u0014hi\u001c:QCJ$\u0018\u000e^5p]N$B!!\t\u0002&\"9\u0011qU\u000fA\u0002\u0005%\u0016a\u00059beRLG/[8o\u0003:$wJ\u001a4tKR\u001c\b\u0003CAV\u0003[\u000b\u0019'a,\u000e\u0003yL1!a\u0012\u007f!\rq\u0015\u0011W\u0005\u0004\u0003g+#!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0006\u0011\u0012\r\u001a3GC&dW\r\u001a)beRLG/[8o)\u0011\t\t#!/\t\u000f\u0005\u0005d\u00041\u0001\u0002d\u0005a\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$vNR3uG\",'\u000f\u00165sK\u0006$GCBA\u0011\u0003\u007f\u000b\u0019\r\u0003\u0004\u0002B~\u0001\raT\u0001\u000eM\u0016$8\r[3s)\"\u0014X-\u00193\t\u000f\u0005\u0015w\u00041\u0001\u0002*\u00061\u0012N\\5uS\u0006dwJ\u001a4tKR\fe\u000eZ#q_\u000eD7/A\nnCf\u0014W-\u00169eCR,Gk\u001c9jG&#7\u000f\u0006\u0004\u0002\"\u0005-\u0017\u0011\u001b\u0005\b\u0003\u001b\u0004\u0003\u0019AAh\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p+B$\u0017\r^3\u0011\u000f\u0005-\u0016QVA2\u0011\"9\u00111\u001b\u0011A\u0002\u0005U\u0017\u0001\u0003;pa&\u001c\u0017\nZ:\u0011\r5\n9NOAn\u0013\r\tIN\f\u0002\n\rVt7\r^5p]F\u0002R!LA.\u0003;\u0004B!!\u001a\u0002`&!\u0011\u0011]A4\u0005\u0011)V/\u001b3\u00025I,Wn\u001c<f\r\u0016$8\r[3s\r>\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005\u001d\u0018\u0011\u001f\t\t\u0003W\u000bi+a\u0019\u0002jB!\u00111^Aw\u001b\u0005y\u0017bAAx_\n\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"9\u00111_\u0011A\u0002\u0005U\u0018A\u00039beRLG/[8ogB1\u00111VA|\u0003GJ1!!?\u007f\u0005\r\u0019V\r^\u0001\u001bg\",H\u000fZ8x]&#G.\u001a$fi\u000eDWM\u001d+ie\u0016\fGm\u001d\u000b\u0003\u0003C\t\u0001c\u00197pg\u0016\fE\u000e\u001c$fi\u000eDWM]:")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final String metricsPackage;
    private final String metricsClassName;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final java.util.Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private String metricsPackage() {
        return this.metricsPackage;
    }

    private String metricsClassName() {
        return this.metricsClassName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private java.util.Map<String, String> tags() {
        return this.tags;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Resizing fetcher thread pool size from " + currentSize + " to " + newSize);
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable)thread -> {
                thread.markPartitionsForTruncation(topicPartition, truncationOffset);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Added fetcher to broker " + fetcherThread.leader().brokerEndPoint().id() + " for partitions " + initialOffsetAndEpochs);
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    int leaderId = x0$1._2$mcI$sp();
                    return new BrokerIdAndFetcherId(leaderId, this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    BrokerIdAndFetcherId brokerAndFetcherId = (BrokerIdAndFetcherId)x0$2._1();
                    Map partitionsToUpdate = (Map)x0$2._2();
                    return new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                }
                throw new MatchError(null);
            })).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$5 -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(this, topicIds, x$5);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Removed fetcher for partitions " + partitions);
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$3))).foreach((Function1 & Serializable)x$6 -> {
                if (x$6 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$6._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$6._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq((Object)key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((IterableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$4))).foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$7)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$5))).foreach((Function1 & Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$8);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = fetcherThread.fetcherLagStats().stats().values().stream().mapToLong(v -> v.lag()).max().orElse(0L);
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public static final /* synthetic */ long $anonfun$new$1(AbstractFetcherManager $this) {
        return BoxesRunTime.unboxToLong((Object)$this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ double $anonfun$new$5(AbstractFetcherThread x$1) {
        return x$1.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ double $anonfun$new$4(AbstractFetcherManager $this) {
        double headRate = BoxesRunTime.unboxToDouble((Object)$this.fetcherThreadMap().values().headOption().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$5(x$1))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)$this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public static final /* synthetic */ int $anonfun$new$8(AbstractFetcherManager $this) {
        return $this.failedPartitions().size();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(int newSize$1, scala.collection.mutable.Map allRemovedPartitionsMap$1, BrokerIdAndFetcherId id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        partitionStates.foreachEntry((Function2 & Serializable)(topicPartition, currentFetchState) -> {
            InitialFetchState initialFetchState = new InitialFetchState((Option<Uuid>)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(currentFetchState.topicId())), thread.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
            return (scala.collection.mutable.Map)allRemovedPartitionsMap$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)initialFetchState));
        });
    }

    private final void migratePartitions$1(int newSize) {
        scala.collection.mutable.Map allRemovedPartitionsMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.fetcherThreadMap().foreachEntry((Function2 & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(newSize, allRemovedPartitionsMap, id, thread);
            return BoxedUnit.UNIT;
        });
        this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap);
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        fetcherThread.start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                v1 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$4(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$5) {
        if (x$5 != null) {
            BrokerIdAndFetcherId brokerIdAndFetcherId = (BrokerIdAndFetcherId)x$5._1();
            Set partitions = (Set)x$5._2();
            $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId).foreach((Function1 & Serializable)x$4 -> {
                x$4.maybeUpdateTopicIds((Set<TopicPartition>)partitions, (Function1<String, Option<Uuid>>)topicIds$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$7) {
        if (x$7 != null) {
            return ((AbstractFetcherThread)x$7._2()).initiateShutdown();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$5) {
        return check$ifrefutable$5 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$8) {
        if (x$8 != null) {
            ((AbstractFetcherThread)x$8._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        this.name = name;
        this.metricsPackage = "kafka.server";
        this.metricsClassName = this.getClass().getSimpleName();
        this.metricsGroup = new KafkaMetricsGroup(this.metricsPackage(), this.metricsClassName());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq("[" + name + "] ");
        this.tags = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).asJava();
        this.metricsGroup().newGauge("MaxLag", () -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$1(this)), this.tags());
        this.metricsGroup().newGauge("MinFetchRate", () -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$4(this)), this.tags());
        this.metricsGroup().newGauge("FailedPartitionsCount", () -> BoxesRunTime.boxToInteger((int)AbstractFetcherManager.$anonfun$new$8(this)), this.tags());
        this.metricsGroup().newGauge("DeadThreadCount", () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()), this.tags());
    }
}

