/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaManager;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.QuotaUtils;

public class ClientRequestQuotaManager
extends ClientQuotaManager {
    static final double NANOS_TO_PERCENTAGE_PER_SECOND = 100.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private static final long DEFAULT_INACTIVE_EXEMPT_SENSOR_EXPIRATION_TIME_SECONDS = Long.MAX_VALUE;
    private static final String EXEMPT_SENSOR_NAME = "exempt-" + String.valueOf(QuotaType.REQUEST);
    private final long maxThrottleTimeMs;
    private final Metrics metrics;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Optional<Plugin<ClientQuotaCallback>> quotaCallbackPlugin) {
        super(config, metrics, QuotaType.REQUEST, time, threadNamePrefix, quotaCallbackPlugin);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.metrics = metrics;
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType.REQUEST.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(EXEMPT_SENSOR_NAME, Long.MAX_VALUE, sensor -> sensor.add(this.exemptMetricName, (MeasurableStat)new Rate()));
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    private void recordExempt(double value) {
        this.exemptSensor.record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.setRecordNetworkThreadTimeCallback(timeNanos -> this.recordNoThrottle(request.session(), request.header().clientId(), this.nanosToPercentage(Long.parseLong(timeNanos.toString()))));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.nanosToPercentage(request.requestThreadTimeNanos()), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.setRecordNetworkThreadTimeCallback(timeNanos -> this.recordExempt(this.nanosToPercentage(Long.parseLong(timeNanos.toString()))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils.boundedThrottleTime((QuotaViolationException)e, (long)this.maxThrottleTimeMs, (long)timeMs);
    }

    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics.metricName("request-time", QuotaType.REQUEST.toString(), "Tracking request-time per user/client-id", quotaMetricTags);
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * NANOS_TO_PERCENTAGE_PER_SECOND;
    }
}

