/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.NodeAcknowledgements;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.ShareAcquireMode;
import org.apache.kafka.clients.consumer.internals.ShareCompletedFetch;
import org.apache.kafka.clients.consumer.internals.ShareConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchConfig;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsAggregator;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareSessionHandler;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TimedRequestState;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementEventHandler;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.message.ShareAcknowledgeRequestData;
import org.apache.kafka.common.message.ShareAcknowledgeResponseData;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareAcknowledgeRequest;
import org.apache.kafka.common.requests.ShareAcknowledgeResponse;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class ShareConsumeRequestManager
implements RequestManager,
MemberStateListener,
Closeable {
    private final Time time;
    private final Logger log;
    private final LogContext logContext;
    private final String groupId;
    private final ShareConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final ShareFetchConfig shareFetchConfig;
    protected final ShareFetchBuffer shareFetchBuffer;
    private final ShareAcknowledgementEventHandler acknowledgeEventHandler;
    private final Map<Integer, ShareSessionHandler> sessionHandlers;
    private final Set<Integer> nodesWithPendingRequests;
    private final ShareFetchMetricsManager metricsManager;
    private final IdempotentCloser idempotentCloser = new IdempotentCloser();
    private Uuid memberId;
    private boolean fetchMoreRecords = false;
    private final AtomicInteger fetchRecordsNodeId = new AtomicInteger(-1);
    private final Map<Integer, Map<TopicIdPartition, Acknowledgements>> fetchAcknowledgementsToSend;
    private final Map<Integer, Map<TopicIdPartition, Acknowledgements>> fetchAcknowledgementsInFlight;
    private final Map<Integer, Tuple<AcknowledgeRequestState>> acknowledgeRequestStates;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;
    private boolean closing = false;
    private final CompletableFuture<Void> closeFuture;
    private boolean isAcknowledgementCommitCallbackRegistered = false;
    private final Map<IdAndPartition, String> topicNamesMap = new HashMap<IdAndPartition, String>();
    private static final String INVALID_RESPONSE = "Acknowledgement not successful due to invalid response from broker";

    ShareConsumeRequestManager(Time time, LogContext logContext, String groupId, ShareConsumerMetadata metadata, SubscriptionState subscriptions, ShareFetchConfig shareFetchConfig, ShareFetchBuffer shareFetchBuffer, ShareAcknowledgementEventHandler acknowledgeEventHandler, ShareFetchMetricsManager metricsManager, long retryBackoffMs, long retryBackoffMaxMs) {
        this.time = time;
        this.log = logContext.logger(ShareConsumeRequestManager.class);
        this.logContext = logContext;
        this.groupId = groupId;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.shareFetchConfig = shareFetchConfig;
        this.shareFetchBuffer = shareFetchBuffer;
        this.acknowledgeEventHandler = acknowledgeEventHandler;
        this.metricsManager = metricsManager;
        this.retryBackoffMs = retryBackoffMs;
        this.retryBackoffMaxMs = retryBackoffMaxMs;
        this.sessionHandlers = new HashMap<Integer, ShareSessionHandler>();
        this.nodesWithPendingRequests = new HashSet<Integer>();
        this.acknowledgeRequestStates = new HashMap<Integer, Tuple<AcknowledgeRequestState>>();
        this.fetchAcknowledgementsToSend = new HashMap<Integer, Map<TopicIdPartition, Acknowledgements>>();
        this.fetchAcknowledgementsInFlight = new HashMap<Integer, Map<TopicIdPartition, Acknowledgements>>();
        this.closeFuture = new CompletableFuture();
    }

    @Override
    public NetworkClientDelegate.PollResult poll(long currentTimeMs) {
        if (this.memberId == null) {
            if (this.closing && !this.closeFuture.isDone()) {
                this.closeFuture.complete(null);
            }
            return NetworkClientDelegate.PollResult.EMPTY;
        }
        NetworkClientDelegate.PollResult pollResult = this.processAcknowledgements(currentTimeMs);
        if (pollResult != null) {
            return pollResult;
        }
        if (!this.fetchMoreRecords) {
            return NetworkClientDelegate.PollResult.EMPTY;
        }
        HashMap<Node, ShareSessionHandler> handlerMap = new HashMap<Node, ShareSessionHandler>();
        Map<String, Uuid> topicIds = this.metadata.topicIds();
        for (TopicPartition partition : this.partitionsToFetch()) {
            Optional<Node> leaderOpt = this.metadata.currentLeader((TopicPartition)partition).leader;
            if (leaderOpt.isEmpty()) {
                this.log.debug("Requesting metadata update for partition {} since current leader node is missing", (Object)partition);
                this.metadata.requestUpdate(false);
                continue;
            }
            Uuid topicId = topicIds.get(partition.topic());
            if (topicId == null) {
                this.log.debug("Requesting metadata update for partition {} since topic ID is missing", (Object)partition);
                this.metadata.requestUpdate(false);
                continue;
            }
            Node node = leaderOpt.get();
            if (this.nodesWithPendingRequests.contains(node.id())) {
                this.log.trace("Skipping fetch for partition {} because previous fetch request to {} has not been processed", (Object)partition, (Object)node.id());
                continue;
            }
            ShareSessionHandler handler = handlerMap.computeIfAbsent(node, k -> this.sessionHandlers.computeIfAbsent(node.id(), n -> new ShareSessionHandler(this.logContext, (int)n, this.memberId)));
            TopicIdPartition tip = new TopicIdPartition(topicId, partition);
            Acknowledgements acknowledgementsToSend = null;
            boolean canSendAcknowledgements = true;
            Map<TopicIdPartition, Acknowledgements> nodeAcksFromFetchMap = this.fetchAcknowledgementsToSend.get(node.id());
            if (nodeAcksFromFetchMap != null && (acknowledgementsToSend = nodeAcksFromFetchMap.remove(tip)) != null && !this.maybeAddAcknowledgements(handler, node, tip, acknowledgementsToSend)) {
                canSendAcknowledgements = false;
            }
            if (canSendAcknowledgements) {
                handler.addPartitionToFetch(tip, acknowledgementsToSend);
            } else {
                handler.addPartitionToFetch(tip, null);
            }
            this.topicNamesMap.putIfAbsent(new IdAndPartition(tip.topicId(), tip.partition()), tip.topic());
            if (this.isShareAcquireModeRecordLimit() && this.fetchRecordsNodeId.compareAndSet(-1, node.id())) {
                this.subscriptions.movePartitionToEnd(partition);
            }
            this.log.debug("Added fetch request for partition {} to node {}", (Object)tip, (Object)node.id());
        }
        Cluster cluster = this.metadata.fetch();
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                if (this.nodesWithPendingRequests.contains(node.id())) {
                    this.log.trace("Skipping fetch because previous fetch request to {} has not been processed", nodeId);
                } else {
                    Map<TopicIdPartition, Acknowledgements> nodeAcksFromFetchMap = this.fetchAcknowledgementsToSend.get(nodeId);
                    if (nodeAcksFromFetchMap != null) {
                        nodeAcksFromFetchMap.forEach((tip, acks) -> {
                            if (!this.isLeaderKnownToHaveChanged((int)nodeId, (TopicIdPartition)tip)) {
                                if (!this.maybeAddAcknowledgements((ShareSessionHandler)sessionHandler, node, (TopicIdPartition)tip, (Acknowledgements)acks)) {
                                    return;
                                }
                                sessionHandler.addPartitionToAcknowledgeOnly((TopicIdPartition)tip, (Acknowledgements)acks);
                                handlerMap.put(node, (ShareSessionHandler)sessionHandler);
                                this.topicNamesMap.putIfAbsent(new IdAndPartition(tip.topicId(), tip.partition()), tip.topic());
                                this.log.debug("Added fetch request for previously subscribed partition {} to node {}", tip, nodeId);
                            } else {
                                this.log.debug("Leader for the partition is down or has changed, failing acknowledgements for partition {}", tip);
                                acks.complete(Errors.NOT_LEADER_OR_FOLLOWER.exception());
                                this.maybeSendShareAcknowledgementEvent(Map.of(tip, acks), true, Optional.empty());
                            }
                        });
                        nodeAcksFromFetchMap.clear();
                    }
                }
            }
        });
        List<NetworkClientDelegate.UnsentRequest> requests = handlerMap.entrySet().stream().map(entry -> {
            boolean canSkipIfRequestEmpty;
            Node target = (Node)entry.getKey();
            ShareSessionHandler handler = (ShareSessionHandler)entry.getValue();
            ShareFetchRequest.Builder requestBuilder = handler.newShareFetchBuilder(this.groupId, this.shareFetchConfig, canSkipIfRequestEmpty = this.isShareAcquireModeRecordLimit() && target.id() != this.fetchRecordsNodeId.get());
            if (requestBuilder == null) {
                this.log.trace("Skipping ShareFetch request to send to node {}", (Object)target.id());
                return null;
            }
            this.log.trace("Building ShareFetch request to send to node {}", (Object)target.id());
            this.nodesWithPendingRequests.add(target.id());
            BiConsumer<ClientResponse, Throwable> responseHandler = (clientResponse, error) -> {
                if (error != null) {
                    this.handleShareFetchFailure(target, requestBuilder.data(), (Throwable)error);
                } else {
                    this.handleShareFetchSuccess(target, requestBuilder.data(), (ClientResponse)clientResponse);
                }
            };
            return new NetworkClientDelegate.UnsentRequest(requestBuilder, Optional.of(target)).whenComplete(responseHandler);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return new NetworkClientDelegate.PollResult(requests);
    }

    private boolean isShareAcquireModeRecordLimit() {
        return this.shareFetchConfig.shareAcquireMode == ShareAcquireMode.RECORD_LIMIT;
    }

    private boolean maybeAddAcknowledgements(ShareSessionHandler handler, Node node, TopicIdPartition tip, Acknowledgements acknowledgements) {
        if (handler.isNewSession()) {
            this.log.debug("Cannot send acknowledgements on initial epoch for ShareSession for partition {}", (Object)tip);
            acknowledgements.complete(Errors.INVALID_SHARE_SESSION_EPOCH.exception());
            this.maybeSendShareAcknowledgementEvent(Map.of(tip, acknowledgements), true, Optional.empty());
            return false;
        }
        this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
        this.fetchAcknowledgementsInFlight.computeIfAbsent(node.id(), k -> new HashMap()).put(tip, acknowledgements);
        return true;
    }

    public void fetch(Map<TopicIdPartition, NodeAcknowledgements> acknowledgementsMap) {
        if (!this.fetchMoreRecords) {
            this.log.debug("Fetch more data");
            this.fetchMoreRecords = true;
        }
        this.processAcknowledgementsMap(acknowledgementsMap);
    }

    private void processAcknowledgementsMap(Map<TopicIdPartition, NodeAcknowledgements> acknowledgementsMap) {
        acknowledgementsMap.forEach((tip, nodeAcks) -> {
            int nodeId = nodeAcks.nodeId();
            Map<TopicIdPartition, Acknowledgements> currentNodeAcknowledgementsMap = this.fetchAcknowledgementsToSend.get(nodeId);
            if (currentNodeAcknowledgementsMap != null) {
                Acknowledgements currentAcknowledgementsForNode = currentNodeAcknowledgementsMap.get(tip);
                if (currentAcknowledgementsForNode != null) {
                    currentAcknowledgementsForNode.merge(nodeAcks.acknowledgements());
                } else {
                    currentNodeAcknowledgementsMap.put((TopicIdPartition)tip, nodeAcks.acknowledgements());
                }
            } else {
                HashMap<TopicIdPartition, Acknowledgements> nodeAcknowledgementsMap = new HashMap<TopicIdPartition, Acknowledgements>();
                nodeAcknowledgementsMap.put((TopicIdPartition)tip, nodeAcks.acknowledgements());
                this.fetchAcknowledgementsToSend.put(nodeId, nodeAcknowledgementsMap);
            }
        });
    }

    private NetworkClientDelegate.PollResult processAcknowledgements(long currentTimeMs) {
        ArrayList<NetworkClientDelegate.UnsentRequest> unsentRequests = new ArrayList<NetworkClientDelegate.UnsentRequest>();
        AtomicBoolean isAsyncSent = new AtomicBoolean();
        block0: for (Map.Entry<Integer, Tuple<AcknowledgeRequestState>> requestStates : this.acknowledgeRequestStates.entrySet()) {
            int nodeId = requestStates.getKey();
            if (!this.isNodeFree(nodeId)) {
                this.log.trace("Skipping acknowledge request because previous request to {} has not been processed, so acks are not sent", (Object)nodeId);
                continue;
            }
            isAsyncSent.set(false);
            this.maybeBuildRequest(requestStates.getValue().getAsyncRequest(), currentTimeMs, true, isAsyncSent).ifPresent(unsentRequests::add);
            if (!isAsyncSent.get()) continue;
            if (!this.isNodeFree(nodeId)) {
                this.log.trace("Skipping acknowledge request because previous request to {} has not been processed, so acks are not sent", (Object)nodeId);
                continue;
            }
            if (requestStates.getValue().getSyncRequestQueue() == null) {
                AcknowledgeRequestState closeRequestState = requestStates.getValue().getCloseRequest();
                this.maybeBuildRequest(closeRequestState, currentTimeMs, false, isAsyncSent).ifPresent(unsentRequests::add);
                continue;
            }
            for (AcknowledgeRequestState acknowledgeRequestState : requestStates.getValue().getSyncRequestQueue()) {
                if (!this.isNodeFree(nodeId)) {
                    this.log.trace("Skipping acknowledge request because previous request to {} has not been processed, so acks are not sent", (Object)nodeId);
                    continue block0;
                }
                this.maybeBuildRequest(acknowledgeRequestState, currentTimeMs, false, isAsyncSent).ifPresent(unsentRequests::add);
            }
        }
        NetworkClientDelegate.PollResult pollResult = null;
        if (!unsentRequests.isEmpty()) {
            pollResult = new NetworkClientDelegate.PollResult(unsentRequests);
        } else if (this.checkAndRemoveCompletedAcknowledgements()) {
            pollResult = NetworkClientDelegate.PollResult.EMPTY;
        } else if (this.closing) {
            if (!this.closeFuture.isDone()) {
                this.closeFuture.complete(null);
            }
            pollResult = NetworkClientDelegate.PollResult.EMPTY;
        }
        return pollResult;
    }

    private boolean isNodeFree(int nodeId) {
        return !this.nodesWithPendingRequests.contains(nodeId);
    }

    public void setAcknowledgementCommitCallbackRegistered(boolean isAcknowledgementCommitCallbackRegistered) {
        this.isAcknowledgementCommitCallbackRegistered = isAcknowledgementCommitCallbackRegistered;
    }

    private void maybeSendShareAcknowledgementEvent(Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, boolean checkForRenewAcknowledgements, Optional<Integer> acquisitionLockTimeoutMs) {
        if (this.isAcknowledgementCommitCallbackRegistered || checkForRenewAcknowledgements) {
            ShareAcknowledgementEvent event = new ShareAcknowledgementEvent(acknowledgementsMap, checkForRenewAcknowledgements, acquisitionLockTimeoutMs);
            this.acknowledgeEventHandler.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<NetworkClientDelegate.UnsentRequest> maybeBuildRequest(AcknowledgeRequestState acknowledgeRequestState, long currentTimeMs, boolean onCommitAsync, AtomicBoolean isAsyncSent) {
        boolean asyncSent = true;
        try {
            if (acknowledgeRequestState == null || !acknowledgeRequestState.isCloseRequest() && acknowledgeRequestState.isEmpty() || acknowledgeRequestState.isCloseRequest() && acknowledgeRequestState.isProcessed) {
                Optional<NetworkClientDelegate.UnsentRequest> optional = Optional.empty();
                return optional;
            }
            if (acknowledgeRequestState.maybeExpire()) {
                for (TopicIdPartition tip : acknowledgeRequestState.incompleteAcknowledgements.keySet()) {
                    this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getIncompleteAcknowledgementsCount(tip));
                    acknowledgeRequestState.handleAcknowledgeTimedOut(tip);
                }
                acknowledgeRequestState.incompleteAcknowledgements.clear();
                acknowledgeRequestState.maybeResetTimerAndRequestState();
                Optional optional = Optional.empty();
                return optional;
            }
            if (!acknowledgeRequestState.canSendRequest(currentTimeMs)) {
                asyncSent = false;
                Optional<NetworkClientDelegate.UnsentRequest> optional = Optional.empty();
                return optional;
            }
            NetworkClientDelegate.UnsentRequest request = acknowledgeRequestState.buildRequest();
            if (request == null) {
                asyncSent = false;
                Optional<NetworkClientDelegate.UnsentRequest> optional = Optional.empty();
                return optional;
            }
            acknowledgeRequestState.onSendAttempt(currentTimeMs);
            Optional<NetworkClientDelegate.UnsentRequest> optional = Optional.of(request);
            return optional;
        }
        finally {
            if (onCommitAsync) {
                isAsyncSent.set(asyncSent);
            }
        }
    }

    private boolean checkAndRemoveCompletedAcknowledgements() {
        boolean areAnyAcksLeft = false;
        Iterator<Map.Entry<Integer, Tuple<AcknowledgeRequestState>>> iterator = this.acknowledgeRequestStates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Tuple<AcknowledgeRequestState>> acknowledgeRequestStatePair = iterator.next();
            boolean areAsyncAcksLeft = true;
            boolean areSyncAcksLeft = true;
            if (!this.isRequestStateInProgress(acknowledgeRequestStatePair.getValue().getAsyncRequest())) {
                acknowledgeRequestStatePair.getValue().setAsyncRequest(null);
                areAsyncAcksLeft = false;
            }
            if (!this.areRequestStatesInProgress(acknowledgeRequestStatePair.getValue().getSyncRequestQueue())) {
                acknowledgeRequestStatePair.getValue().nullifySyncRequestQueue();
                areSyncAcksLeft = false;
            }
            if (!this.isRequestStateInProgress(acknowledgeRequestStatePair.getValue().getCloseRequest())) {
                acknowledgeRequestStatePair.getValue().setCloseRequest(null);
            }
            if (areAsyncAcksLeft || areSyncAcksLeft) {
                areAnyAcksLeft = true;
                continue;
            }
            if (acknowledgeRequestStatePair.getValue().getCloseRequest() != null) continue;
            iterator.remove();
        }
        if (!this.acknowledgeRequestStates.isEmpty()) {
            areAnyAcksLeft = true;
        }
        return areAnyAcksLeft;
    }

    private boolean isRequestStateInProgress(AcknowledgeRequestState acknowledgeRequestState) {
        if (acknowledgeRequestState == null) {
            return false;
        }
        if (acknowledgeRequestState.isCloseRequest()) {
            return !acknowledgeRequestState.isProcessed;
        }
        return !acknowledgeRequestState.isEmpty();
    }

    private boolean areRequestStatesInProgress(Queue<AcknowledgeRequestState> acknowledgeRequestStates) {
        if (acknowledgeRequestStates == null) {
            return false;
        }
        for (AcknowledgeRequestState acknowledgeRequestState : acknowledgeRequestStates) {
            if (!this.isRequestStateInProgress(acknowledgeRequestState)) continue;
            return true;
        }
        return false;
    }

    public CompletableFuture<Map<TopicIdPartition, Acknowledgements>> commitSync(Map<TopicIdPartition, NodeAcknowledgements> acknowledgementsMap, long deadlineMs) {
        AtomicInteger resultCount = new AtomicInteger();
        CompletableFuture<Map<TopicIdPartition, Acknowledgements>> future = new CompletableFuture<Map<TopicIdPartition, Acknowledgements>>();
        ResultHandler resultHandler = new ResultHandler(resultCount, Optional.of(future));
        Cluster cluster = this.metadata.fetch();
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                this.acknowledgeRequestStates.putIfAbsent((Integer)nodeId, (Tuple<AcknowledgeRequestState>)new Tuple<Object>(null, null, null));
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                for (TopicIdPartition tip : sessionHandler.sessionPartitions()) {
                    NodeAcknowledgements nodeAcknowledgements = (NodeAcknowledgements)acknowledgementsMap.get(tip);
                    if (nodeAcknowledgements == null || nodeAcknowledgements.nodeId() != node.id()) continue;
                    if (!this.isLeaderKnownToHaveChanged(node.id(), tip)) {
                        acknowledgementsMapForNode.put(tip, nodeAcknowledgements.acknowledgements());
                        this.metricsManager.recordAcknowledgementSent(nodeAcknowledgements.acknowledgements().size());
                        this.log.debug("Added sync acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                        resultCount.incrementAndGet();
                        continue;
                    }
                    nodeAcknowledgements.acknowledgements().complete(Errors.NOT_LEADER_OR_FOLLOWER.exception());
                    this.maybeSendShareAcknowledgementEvent(Map.of(tip, nodeAcknowledgements.acknowledgements()), true, Optional.empty());
                }
                if (!acknowledgementsMapForNode.isEmpty()) {
                    this.acknowledgeRequestStates.get(nodeId).addSyncRequest(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":1", deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, resultHandler, AcknowledgeRequestType.COMMIT_SYNC));
                }
            }
        });
        resultHandler.completeIfEmpty();
        return future;
    }

    public void commitAsync(Map<TopicIdPartition, NodeAcknowledgements> acknowledgementsMap, long deadlineMs) {
        Cluster cluster = this.metadata.fetch();
        ResultHandler resultHandler = new ResultHandler(Optional.empty());
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                this.acknowledgeRequestStates.putIfAbsent((Integer)nodeId, (Tuple<AcknowledgeRequestState>)new Tuple<Object>(null, null, null));
                for (TopicIdPartition tip : sessionHandler.sessionPartitions()) {
                    NodeAcknowledgements nodeAcknowledgements = (NodeAcknowledgements)acknowledgementsMap.get(tip);
                    if (nodeAcknowledgements == null || nodeAcknowledgements.nodeId() != node.id()) continue;
                    if (!this.isLeaderKnownToHaveChanged(node.id(), tip)) {
                        Acknowledgements acknowledgements = nodeAcknowledgements.acknowledgements();
                        acknowledgementsMapForNode.put(tip, acknowledgements);
                        this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
                        this.log.debug("Added async acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                        AcknowledgeRequestState asyncRequestState = this.acknowledgeRequestStates.get(nodeId).getAsyncRequest();
                        if (asyncRequestState == null) {
                            this.acknowledgeRequestStates.get(nodeId).setAsyncRequest(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":2", deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, resultHandler, AcknowledgeRequestType.COMMIT_ASYNC));
                            continue;
                        }
                        Acknowledgements prevAcks = asyncRequestState.acknowledgementsToSend.putIfAbsent(tip, acknowledgements);
                        if (prevAcks == null) continue;
                        asyncRequestState.acknowledgementsToSend.get(tip).merge(acknowledgements);
                        continue;
                    }
                    nodeAcknowledgements.acknowledgements().complete(Errors.NOT_LEADER_OR_FOLLOWER.exception());
                    this.maybeSendShareAcknowledgementEvent(Map.of(tip, nodeAcknowledgements.acknowledgements()), true, Optional.empty());
                }
            }
        });
        resultHandler.completeIfEmpty();
    }

    public CompletableFuture<Void> acknowledgeOnClose(Map<TopicIdPartition, NodeAcknowledgements> acknowledgementsMap, long deadlineMs) {
        Cluster cluster = this.metadata.fetch();
        AtomicInteger resultCount = new AtomicInteger();
        ResultHandler resultHandler = new ResultHandler(resultCount, Optional.empty());
        this.closing = true;
        HashMap acknowledgementsMapAllNodes = new HashMap();
        acknowledgementsMap.forEach((tip, nodeAcks) -> {
            if (!this.isLeaderKnownToHaveChanged(nodeAcks.nodeId(), (TopicIdPartition)tip)) {
                Map acksMap = acknowledgementsMapAllNodes.computeIfAbsent(nodeAcks.nodeId(), k -> new HashMap());
                Acknowledgements prevAcks = acksMap.putIfAbsent(tip, nodeAcks.acknowledgements());
                if (prevAcks != null) {
                    ((Acknowledgements)acksMap.get(tip)).merge(nodeAcks.acknowledgements());
                }
            } else {
                nodeAcks.acknowledgements().complete(Errors.NOT_LEADER_OR_FOLLOWER.exception());
                this.maybeSendShareAcknowledgementEvent(Map.of(tip, nodeAcks.acknowledgements()), true, Optional.empty());
            }
        });
        this.sessionHandlers.forEach((nodeId, sessionHandler) -> {
            Node node = cluster.nodeById((int)nodeId);
            if (node != null) {
                HashMap<TopicIdPartition, Acknowledgements> acknowledgementsMapForNode;
                Map<TopicIdPartition, Acknowledgements> fetchAcks = this.fetchAcknowledgementsToSend.remove(nodeId);
                if (fetchAcks != null) {
                    fetchAcks.forEach((tip, acks) -> {
                        if (!this.isLeaderKnownToHaveChanged((int)nodeId, (TopicIdPartition)tip)) {
                            Map acksMap = acknowledgementsMapAllNodes.computeIfAbsent(nodeId, k -> new HashMap());
                            Acknowledgements prevAcks = acksMap.putIfAbsent(tip, acks);
                            if (prevAcks != null) {
                                ((Acknowledgements)acksMap.get(tip)).merge((Acknowledgements)acks);
                            }
                        } else {
                            acks.complete(Errors.NOT_LEADER_OR_FOLLOWER.exception());
                            this.maybeSendShareAcknowledgementEvent(Map.of(tip, acks), true, Optional.empty());
                        }
                    });
                }
                if ((acknowledgementsMapForNode = (HashMap<TopicIdPartition, Acknowledgements>)acknowledgementsMapAllNodes.get(nodeId)) != null) {
                    acknowledgementsMapForNode.forEach((tip, acknowledgements) -> {
                        this.metricsManager.recordAcknowledgementSent(acknowledgements.size());
                        this.log.debug("Added closing acknowledge request for partition {} to node {}", (Object)tip.topicPartition(), (Object)node.id());
                        resultCount.incrementAndGet();
                    });
                } else {
                    acknowledgementsMapForNode = new HashMap<TopicIdPartition, Acknowledgements>();
                }
                this.acknowledgeRequestStates.putIfAbsent((Integer)nodeId, (Tuple<AcknowledgeRequestState>)new Tuple<Object>(null, null, null));
                if (this.acknowledgeRequestStates.get(nodeId).getCloseRequest() != null && this.isRequestStateInProgress(this.acknowledgeRequestStates.get(nodeId).getCloseRequest())) {
                    this.log.error("Attempt to call close() when there is an existing close request for node {}-{}", (Object)node.id(), this.acknowledgeRequestStates.get(nodeId).getSyncRequestQueue());
                    this.closeFuture.completeExceptionally(new IllegalStateException("Attempt to call close() when there is an existing close request for node : " + node.id()));
                } else {
                    this.acknowledgeRequestStates.get(nodeId).setCloseRequest(new AcknowledgeRequestState(this.logContext, ShareConsumeRequestManager.class.getSimpleName() + ":3", deadlineMs, this.retryBackoffMs, this.retryBackoffMaxMs, (ShareSessionHandler)sessionHandler, (int)nodeId, (Map<TopicIdPartition, Acknowledgements>)acknowledgementsMapForNode, resultHandler, AcknowledgeRequestType.CLOSE));
                }
            }
        });
        resultHandler.completeIfEmpty();
        return this.closeFuture;
    }

    private boolean isLeaderKnownToHaveChanged(int nodeId, TopicIdPartition topicIdPartition) {
        Optional<Node> leaderNode = this.metadata.currentLeader((TopicPartition)topicIdPartition.topicPartition()).leader;
        if (leaderNode.isPresent()) {
            if (leaderNode.get().id() != nodeId) {
                this.log.debug("Node {} is no longer the leader for partition {}, failing acknowledgements", (Object)nodeId, (Object)topicIdPartition);
                return true;
            }
        } else {
            this.log.debug("No leader found for partition {}", (Object)topicIdPartition);
            this.metadata.requestUpdate(false);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareFetchSuccess(Node fetchTarget, ShareFetchRequestData requestData, ClientResponse resp) {
        try {
            this.log.debug("Completed ShareFetch request from node {} successfully", (Object)fetchTarget.id());
            ShareFetchResponse response = (ShareFetchResponse)resp.responseBody();
            ShareSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler == null) {
                this.log.error("Unable to find ShareSessionHandler for node {}. Ignoring ShareFetch response.", (Object)fetchTarget.id());
                return;
            }
            short requestVersion = resp.requestHeader().apiVersion();
            if (!handler.handleResponse(response, requestVersion)) {
                Map<TopicIdPartition, Acknowledgements> nodeAcknowledgementsInFlight;
                if (response.error() == Errors.UNKNOWN_TOPIC_ID) {
                    this.metadata.requestUpdate(false);
                }
                if ((nodeAcknowledgementsInFlight = this.fetchAcknowledgementsInFlight.remove(fetchTarget.id())) != null) {
                    nodeAcknowledgementsInFlight.forEach((tip, acks) -> {
                        acks.complete(Errors.forCode(response.error().code()).exception());
                        this.metricsManager.recordFailedAcknowledgements(acks.size());
                    });
                    this.maybeSendShareAcknowledgementEvent(nodeAcknowledgementsInFlight, requestData.isRenewAck(), Optional.empty());
                }
                return;
            }
            LinkedHashMap responseData = new LinkedHashMap();
            Optional<Integer> responseAcquisitionLockTimeoutMs = response.data().acquisitionLockTimeoutMs() > 0 ? Optional.of(response.data().acquisitionLockTimeoutMs()) : Optional.empty();
            response.data().responses().forEach(topicResponse -> topicResponse.partitions().forEach(partition -> {
                TopicIdPartition tip = this.lookupTopicId(topicResponse.topicId(), partition.partitionIndex());
                if (tip != null) {
                    responseData.put(tip, partition);
                }
            }));
            Set<TopicPartition> partitions = responseData.keySet().stream().map(TopicIdPartition::topicPartition).collect(Collectors.toSet());
            ShareFetchMetricsAggregator shareFetchMetricsAggregator = new ShareFetchMetricsAggregator(this.metricsManager, partitions);
            ArrayList<ShareCompletedFetch> completedFetches = new ArrayList<ShareCompletedFetch>(responseData.size());
            HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> partitionsWithUpdatedLeaderInfo = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
            for (Map.Entry entry : responseData.entrySet()) {
                Errors partitionError;
                Acknowledgements acks2;
                TopicIdPartition tip2 = (TopicIdPartition)entry.getKey();
                ShareFetchResponseData.PartitionData partitionData = (ShareFetchResponseData.PartitionData)entry.getValue();
                this.log.debug("ShareFetch for partition {} returned fetch data {}", (Object)tip2, (Object)partitionData);
                Map<TopicIdPartition, Acknowledgements> nodeAcknowledgementsInFlight = this.fetchAcknowledgementsInFlight.get(fetchTarget.id());
                if (nodeAcknowledgementsInFlight != null && (acks2 = nodeAcknowledgementsInFlight.remove(tip2)) != null) {
                    if (partitionData.acknowledgeErrorCode() != Errors.NONE.code()) {
                        this.metricsManager.recordFailedAcknowledgements(acks2.size());
                    }
                    acks2.complete(Errors.forCode(partitionData.acknowledgeErrorCode()).exception(partitionData.acknowledgeErrorMessage()));
                    Map<TopicIdPartition, Acknowledgements> acksMap = Map.of(tip2, acks2);
                    this.maybeSendShareAcknowledgementEvent(acksMap, requestData.isRenewAck(), responseAcquisitionLockTimeoutMs);
                }
                if ((partitionError = Errors.forCode(partitionData.errorCode())) == Errors.NOT_LEADER_OR_FOLLOWER || partitionError == Errors.FENCED_LEADER_EPOCH) {
                    this.log.debug("For {}, received error {}, with leaderIdAndEpoch {} in ShareFetch", new Object[]{tip2, partitionError, partitionData.currentLeader()});
                    if (partitionData.currentLeader().leaderId() != -1 && partitionData.currentLeader().leaderEpoch() != -1) {
                        partitionsWithUpdatedLeaderInfo.put(tip2.topicPartition(), new Metadata.LeaderIdAndEpoch(Optional.of(partitionData.currentLeader().leaderId()), Optional.of(partitionData.currentLeader().leaderEpoch())));
                    }
                }
                completedFetches.add(new ShareCompletedFetch(this.logContext, BufferSupplier.create(), fetchTarget.id(), tip2, partitionData, responseAcquisitionLockTimeoutMs, shareFetchMetricsAggregator, requestVersion));
                if (partitionData.acquiredRecords().isEmpty()) continue;
                this.fetchMoreRecords = false;
            }
            if (!completedFetches.isEmpty()) {
                this.shareFetchBuffer.add(completedFetches);
            }
            if (this.fetchAcknowledgementsInFlight.get(fetchTarget.id()) != null) {
                this.fetchAcknowledgementsInFlight.remove(fetchTarget.id()).forEach((partition, acknowledgements) -> {
                    acknowledgements.complete(new InvalidRecordStateException(INVALID_RESPONSE));
                    this.maybeSendShareAcknowledgementEvent(Map.of(partition, acknowledgements), true, Optional.empty());
                });
            }
            if (!partitionsWithUpdatedLeaderInfo.isEmpty()) {
                List<Node> leaderNodes = response.data().nodeEndpoints().stream().map(e -> new Node(e.nodeId(), e.host(), e.port(), e.rack())).filter(e -> !e.equals(Node.noNode())).collect(Collectors.toList());
                this.metadata.updatePartitionLeadership(partitionsWithUpdatedLeaderInfo, leaderNodes);
            }
            this.metricsManager.recordLatency(resp.destination(), resp.requestLatencyMs());
        }
        finally {
            this.log.debug("Removing pending request for node {} - success", (Object)fetchTarget.id());
            if (this.isShareAcquireModeRecordLimit()) {
                this.fetchRecordsNodeId.compareAndSet(fetchTarget.id(), -1);
            }
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareFetchFailure(Node fetchTarget, ShareFetchRequestData requestData, Throwable error) {
        try {
            this.log.debug("Completed ShareFetch request from node {} unsuccessfully {}", (Object)fetchTarget.id(), (Object)Errors.forException(error));
            ShareSessionHandler handler = this.sessionHandler(fetchTarget.id());
            if (handler != null) {
                handler.handleError(error);
            }
            requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                Acknowledgements acks;
                TopicIdPartition tip = this.lookupTopicId(topic.topicId(), partition.partitionIndex());
                if (tip == null) {
                    return;
                }
                Map<TopicIdPartition, Acknowledgements> nodeAcknowledgementsInFlight = this.fetchAcknowledgementsInFlight.get(fetchTarget.id());
                if (nodeAcknowledgementsInFlight != null && (acks = nodeAcknowledgementsInFlight.remove(tip)) != null) {
                    this.metricsManager.recordFailedAcknowledgements(acks.size());
                    if (error instanceof KafkaException) {
                        acks.complete((KafkaException)error);
                    } else {
                        acks.complete(Errors.UNKNOWN_SERVER_ERROR.exception());
                    }
                    Map<TopicIdPartition, Acknowledgements> acksMap = Map.of(tip, acks);
                    this.maybeSendShareAcknowledgementEvent(acksMap, requestData.isRenewAck(), Optional.empty());
                }
            }));
        }
        finally {
            this.log.debug("Removing pending request for node {} - failed", (Object)fetchTarget.id());
            if (this.isShareAcquireModeRecordLimit()) {
                this.fetchRecordsNodeId.compareAndSet(fetchTarget.id(), -1);
            }
            this.nodesWithPendingRequests.remove(fetchTarget.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeSuccess(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, ClientResponse resp, long responseCompletionTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge request from node {} successfully", (Object)fetchTarget.id());
            ShareAcknowledgeResponse response = (ShareAcknowledgeResponse)resp.responseBody();
            Optional responseAcquisitionLockTimeoutMs = response.data().acquisitionLockTimeoutMs() > 0 ? Optional.of(response.data().acquisitionLockTimeoutMs()) : Optional.empty();
            HashMap<TopicPartition, Metadata.LeaderIdAndEpoch> partitionsWithUpdatedLeaderInfo = new HashMap<TopicPartition, Metadata.LeaderIdAndEpoch>();
            if (acknowledgeRequestState.isCloseRequest()) {
                response.data().responses().forEach(topicResponse -> topicResponse.partitions().forEach(partitionData -> {
                    TopicIdPartition tip = this.lookupTopicId(topicResponse.topicId(), partitionData.partitionIndex());
                    if (tip == null) {
                        return;
                    }
                    if (partitionData.errorCode() != Errors.NONE.code()) {
                        this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getInFlightAcknowledgementsCount(tip));
                    }
                    acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forCode(partitionData.errorCode()), requestData.isRenewAck(), responseAcquisitionLockTimeoutMs);
                }));
                acknowledgeRequestState.onSuccessfulAttempt(responseCompletionTimeMs);
                acknowledgeRequestState.processingComplete();
            } else if (!acknowledgeRequestState.sessionHandler.handleResponse(response, resp.requestHeader().apiVersion())) {
                acknowledgeRequestState.onFailedAttempt(responseCompletionTimeMs);
                if (response.error().exception() instanceof RetriableException) {
                    acknowledgeRequestState.moveAllToIncompleteAcks();
                } else {
                    acknowledgeRequestState.processPendingInFlightAcknowledgements(response.error().exception());
                    acknowledgeRequestState.processingComplete();
                }
            } else {
                AtomicBoolean shouldRetry = new AtomicBoolean(false);
                response.data().responses().forEach(topicResponse -> topicResponse.partitions().forEach(partitionData -> {
                    Errors partitionError = Errors.forCode(partitionData.errorCode());
                    TopicIdPartition tip = this.lookupTopicId(topicResponse.topicId(), partitionData.partitionIndex());
                    if (tip == null) {
                        return;
                    }
                    this.handlePartitionError((ShareAcknowledgeResponseData.PartitionData)partitionData, partitionsWithUpdatedLeaderInfo, acknowledgeRequestState, partitionError, tip, shouldRetry, requestData.isRenewAck(), responseAcquisitionLockTimeoutMs);
                }));
                this.processRetryLogic(acknowledgeRequestState, shouldRetry, responseCompletionTimeMs);
            }
            if (!partitionsWithUpdatedLeaderInfo.isEmpty()) {
                List<Node> leaderNodes = response.data().nodeEndpoints().stream().map(e -> new Node(e.nodeId(), e.host(), e.port(), e.rack())).filter(e -> !e.equals(Node.noNode())).collect(Collectors.toList());
                this.metadata.updatePartitionLeadership(partitionsWithUpdatedLeaderInfo, leaderNodes);
            }
            if (acknowledgeRequestState.isProcessed) {
                this.metricsManager.recordLatency(resp.destination(), resp.requestLatencyMs());
            }
        }
        finally {
            this.log.debug("Removing pending request for node {} - success", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
            if (acknowledgeRequestState.isCloseRequest()) {
                this.log.debug("Removing node from ShareSession {}", (Object)fetchTarget.id());
                this.sessionHandlers.remove(fetchTarget.id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShareAcknowledgeFailure(Node fetchTarget, ShareAcknowledgeRequestData requestData, AcknowledgeRequestState acknowledgeRequestState, Throwable error, long responseCompletionTimeMs) {
        try {
            this.log.debug("Completed ShareAcknowledge request from node {} unsuccessfully {}", (Object)fetchTarget.id(), (Object)Errors.forException(error));
            acknowledgeRequestState.sessionHandler().handleError(error);
            acknowledgeRequestState.onFailedAttempt(responseCompletionTimeMs);
            requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> {
                TopicIdPartition tip = this.lookupTopicId(topic.topicId(), partition.partitionIndex());
                if (tip == null) {
                    return;
                }
                this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getInFlightAcknowledgementsCount(tip));
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, Errors.forException(error), requestData.isRenewAck(), Optional.empty());
            }));
            acknowledgeRequestState.processingComplete();
        }
        finally {
            this.log.debug("Removing pending request for node {} - failed", (Object)fetchTarget.id());
            this.nodesWithPendingRequests.remove(fetchTarget.id());
            if (acknowledgeRequestState.isCloseRequest()) {
                this.log.debug("Removing node from ShareSession {}", (Object)fetchTarget.id());
                this.sessionHandlers.remove(fetchTarget.id());
            }
        }
    }

    private void handlePartitionError(ShareAcknowledgeResponseData.PartitionData partitionData, Map<TopicPartition, Metadata.LeaderIdAndEpoch> partitionsWithUpdatedLeaderInfo, AcknowledgeRequestState acknowledgeRequestState, Errors partitionError, TopicIdPartition tip, AtomicBoolean shouldRetry, boolean isRenewAck, Optional<Integer> acquisitionLockTimeoutMs) {
        if (partitionError.exception() != null) {
            boolean retry = false;
            if (partitionError == Errors.NOT_LEADER_OR_FOLLOWER || partitionError == Errors.FENCED_LEADER_EPOCH || partitionError == Errors.UNKNOWN_TOPIC_OR_PARTITION || partitionError == Errors.UNKNOWN_TOPIC_ID) {
                this.updateLeaderInfoMap(partitionData, partitionsWithUpdatedLeaderInfo, partitionError, tip.topicPartition());
            } else if (partitionError.exception() instanceof RetriableException) {
                retry = true;
            }
            if (retry) {
                if (acknowledgeRequestState.moveToIncompleteAcks(tip)) {
                    shouldRetry.set(true);
                }
            } else {
                this.metricsManager.recordFailedAcknowledgements(acknowledgeRequestState.getInFlightAcknowledgementsCount(tip));
                acknowledgeRequestState.handleAcknowledgeErrorCode(tip, partitionError, isRenewAck, Optional.empty());
            }
        } else {
            acknowledgeRequestState.handleAcknowledgeErrorCode(tip, partitionError, isRenewAck, acquisitionLockTimeoutMs);
        }
    }

    private void processRetryLogic(AcknowledgeRequestState acknowledgeRequestState, AtomicBoolean shouldRetry, long responseCompletionTimeMs) {
        if (shouldRetry.get()) {
            acknowledgeRequestState.onFailedAttempt(responseCompletionTimeMs);
            acknowledgeRequestState.processPendingInFlightAcknowledgements(new InvalidRecordStateException(INVALID_RESPONSE));
        } else {
            acknowledgeRequestState.onSuccessfulAttempt(responseCompletionTimeMs);
            acknowledgeRequestState.processingComplete();
        }
    }

    private void updateLeaderInfoMap(ShareAcknowledgeResponseData.PartitionData partitionData, Map<TopicPartition, Metadata.LeaderIdAndEpoch> partitionsWithUpdatedLeaderInfo, Errors partitionError, TopicPartition tp) {
        this.log.debug("For {}, received error {}, with leaderIdAndEpoch {} in ShareAcknowledge", new Object[]{tp, partitionError, partitionData.currentLeader()});
        if (partitionData.currentLeader().leaderId() != -1 && partitionData.currentLeader().leaderEpoch() != -1) {
            partitionsWithUpdatedLeaderInfo.put(tp, new Metadata.LeaderIdAndEpoch(Optional.of(partitionData.currentLeader().leaderId()), Optional.of(partitionData.currentLeader().leaderEpoch())));
        }
    }

    private TopicIdPartition lookupTopicId(Uuid topicId, int partitionIndex) {
        String topicName = this.metadata.topicNames().get(topicId);
        if (topicName == null) {
            topicName = this.topicNamesMap.remove(new IdAndPartition(topicId, partitionIndex));
        }
        if (topicName == null) {
            this.log.error("Topic name not found in metadata for topicId {} and partitionIndex {}", (Object)topicId, (Object)partitionIndex);
            return null;
        }
        return new TopicIdPartition(topicId, partitionIndex, topicName);
    }

    private List<TopicPartition> partitionsToFetch() {
        return this.subscriptions.fetchablePartitions(tp -> true);
    }

    public ShareSessionHandler sessionHandler(int node) {
        return this.sessionHandlers.get(node);
    }

    boolean hasCompletedFetches() {
        return !this.shareFetchBuffer.isEmpty();
    }

    protected void closeInternal() {
        Utils.closeQuietly(this.shareFetchBuffer, "shareFetchBuffer");
        Utils.closeQuietly(this.metricsManager, "shareFetchMetricsManager");
    }

    @Override
    public void close() {
        this.idempotentCloser.close(this::closeInternal);
    }

    @Override
    public void onMemberEpochUpdated(Optional<Integer> memberEpochOpt, String memberId) {
        this.memberId = Uuid.fromString(memberId);
    }

    Tuple<AcknowledgeRequestState> requestStates(int nodeId) {
        return this.acknowledgeRequestStates.get(nodeId);
    }

    static class IdAndPartition {
        private final Uuid topicId;
        private final int partitionIndex;

        IdAndPartition(Uuid topicId, int partitionIndex) {
            this.topicId = topicId;
            this.partitionIndex = partitionIndex;
        }

        public int hashCode() {
            return Objects.hash(this.topicId, this.partitionIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdAndPartition that = (IdAndPartition)o;
            return Objects.equals(this.topicId, that.topicId) && this.partitionIndex == that.partitionIndex;
        }
    }

    static class Tuple<V> {
        private V asyncRequest;
        private Queue<V> syncRequestQueue;
        private V closeRequest;

        public Tuple(V asyncRequest, Queue<V> syncRequestQueue, V closeRequest) {
            this.asyncRequest = asyncRequest;
            this.syncRequestQueue = syncRequestQueue;
            this.closeRequest = closeRequest;
        }

        public void setAsyncRequest(V asyncRequest) {
            this.asyncRequest = asyncRequest;
        }

        public void nullifySyncRequestQueue() {
            this.syncRequestQueue = null;
        }

        public void addSyncRequest(V syncRequest) {
            if (this.syncRequestQueue == null) {
                this.syncRequestQueue = new LinkedList<V>();
            }
            this.syncRequestQueue.add(syncRequest);
        }

        public void setCloseRequest(V closeRequest) {
            this.closeRequest = closeRequest;
        }

        public V getAsyncRequest() {
            return this.asyncRequest;
        }

        public Queue<V> getSyncRequestQueue() {
            return this.syncRequestQueue;
        }

        public V getCloseRequest() {
            return this.closeRequest;
        }
    }

    public class AcknowledgeRequestState
    extends TimedRequestState {
        private final ShareSessionHandler sessionHandler;
        private final int nodeId;
        private final Map<TopicIdPartition, Acknowledgements> acknowledgementsToSend;
        private final Map<TopicIdPartition, Acknowledgements> incompleteAcknowledgements;
        private final Map<TopicIdPartition, Acknowledgements> inFlightAcknowledgements;
        private final ResultHandler resultHandler;
        private final AcknowledgeRequestType requestType;
        private boolean isProcessed;
        private final long timeoutMs;

        AcknowledgeRequestState(LogContext logContext, String owner, long deadlineMs, long retryBackoffMs, long retryBackoffMaxMs, ShareSessionHandler sessionHandler, int nodeId, Map<TopicIdPartition, Acknowledgements> acknowledgementsMap, ResultHandler resultHandler, AcknowledgeRequestType acknowledgeRequestType) {
            super(logContext, owner, retryBackoffMs, retryBackoffMaxMs, AcknowledgeRequestState.deadlineTimer(ShareConsumeRequestManager.this.time, deadlineMs));
            this.sessionHandler = sessionHandler;
            this.nodeId = nodeId;
            this.acknowledgementsToSend = acknowledgementsMap;
            this.resultHandler = resultHandler;
            this.inFlightAcknowledgements = new HashMap<TopicIdPartition, Acknowledgements>();
            this.incompleteAcknowledgements = new HashMap<TopicIdPartition, Acknowledgements>();
            this.requestType = acknowledgeRequestType;
            this.isProcessed = false;
            this.timeoutMs = this.remainingMs();
        }

        NetworkClientDelegate.UnsentRequest buildRequest() {
            if (this.isCloseRequest()) {
                this.sessionHandler.notifyClose();
            }
            HashMap<TopicIdPartition, Acknowledgements> finalAcknowledgementsToSend = new HashMap<TopicIdPartition, Acknowledgements>(this.incompleteAcknowledgements.isEmpty() ? this.acknowledgementsToSend : this.incompleteAcknowledgements);
            for (Map.Entry entry : finalAcknowledgementsToSend.entrySet()) {
                this.sessionHandler.addPartitionToFetch((TopicIdPartition)entry.getKey(), (Acknowledgements)entry.getValue());
            }
            ShareAcknowledgeRequest.Builder requestBuilder = this.sessionHandler.newShareAcknowledgeBuilder(ShareConsumeRequestManager.this.groupId, ShareConsumeRequestManager.this.shareFetchConfig);
            this.isProcessed = false;
            Node nodeToSend = ShareConsumeRequestManager.this.metadata.fetch().nodeById(this.nodeId);
            if (requestBuilder == null) {
                this.handleAcknowledgeShareSessionNotFound();
                return null;
            }
            if (nodeToSend != null) {
                ShareConsumeRequestManager.this.nodesWithPendingRequests.add(this.nodeId);
                ShareConsumeRequestManager.this.log.trace("Building acknowledgements to send : {}", finalAcknowledgementsToSend);
                this.inFlightAcknowledgements.putAll(finalAcknowledgementsToSend);
                if (this.incompleteAcknowledgements.isEmpty()) {
                    this.acknowledgementsToSend.clear();
                } else {
                    this.incompleteAcknowledgements.clear();
                }
                NetworkClientDelegate.UnsentRequest unsentRequest = new NetworkClientDelegate.UnsentRequest(requestBuilder, Optional.of(nodeToSend));
                BiConsumer<ClientResponse, Throwable> responseHandler = (clientResponse, error) -> {
                    if (error != null) {
                        ShareConsumeRequestManager.this.handleShareAcknowledgeFailure(nodeToSend, requestBuilder.data(), this, (Throwable)error, unsentRequest.handler().completionTimeMs());
                    } else {
                        ShareConsumeRequestManager.this.handleShareAcknowledgeSuccess(nodeToSend, requestBuilder.data(), this, (ClientResponse)clientResponse, unsentRequest.handler().completionTimeMs());
                    }
                };
                return unsentRequest.whenComplete(responseHandler);
            }
            return null;
        }

        int getInFlightAcknowledgementsCount(TopicIdPartition tip) {
            Acknowledgements acks = this.inFlightAcknowledgements.get(tip);
            if (acks == null) {
                return 0;
            }
            return acks.size();
        }

        int getIncompleteAcknowledgementsCount(TopicIdPartition tip) {
            Acknowledgements acks = this.incompleteAcknowledgements.get(tip);
            if (acks == null) {
                return 0;
            }
            return acks.size();
        }

        int getAcknowledgementsToSendCount(TopicIdPartition tip) {
            Acknowledgements acks = this.acknowledgementsToSend.get(tip);
            if (acks == null) {
                return 0;
            }
            return acks.size();
        }

        boolean isEmpty() {
            return this.acknowledgementsToSend.isEmpty() && this.incompleteAcknowledgements.isEmpty() && this.inFlightAcknowledgements.isEmpty();
        }

        void maybeResetTimerAndRequestState() {
            if (this.requestType == AcknowledgeRequestType.COMMIT_ASYNC) {
                this.resetTimeout(this.timeoutMs);
                this.reset();
            }
        }

        void handleAcknowledgeErrorCode(TopicIdPartition tip, Errors acknowledgeErrorCode, boolean checkForRenewAcknowledgements, Optional<Integer> acquisitionLockTimeoutMs) {
            Acknowledgements acks = this.inFlightAcknowledgements.remove(tip);
            if (acks != null) {
                acks.complete(acknowledgeErrorCode.exception());
                this.resultHandler.complete(tip, acks, this.requestType, checkForRenewAcknowledgements, acquisitionLockTimeoutMs);
            } else {
                ShareConsumeRequestManager.this.log.error("Invalid partition {} received in ShareAcknowledge response", (Object)tip);
            }
        }

        void handleAcknowledgeTimedOut(TopicIdPartition tip) {
            Acknowledgements acks = this.incompleteAcknowledgements.get(tip);
            if (acks != null) {
                acks.complete(Errors.REQUEST_TIMED_OUT.exception());
                this.resultHandler.complete(tip, acks, this.requestType, true, Optional.empty());
            }
        }

        void handleAcknowledgeShareSessionNotFound() {
            Map<TopicIdPartition, Acknowledgements> acknowledgementsMapToClear = this.incompleteAcknowledgements.isEmpty() ? this.acknowledgementsToSend : this.incompleteAcknowledgements;
            acknowledgementsMapToClear.forEach((tip, acks) -> {
                if (acks != null) {
                    acks.complete(Errors.SHARE_SESSION_NOT_FOUND.exception());
                }
                this.resultHandler.complete((TopicIdPartition)tip, (Acknowledgements)acks, this.requestType, true, Optional.empty());
            });
            acknowledgementsMapToClear.clear();
            this.processingComplete();
        }

        ShareSessionHandler sessionHandler() {
            return this.sessionHandler;
        }

        void processingComplete() {
            this.processPendingInFlightAcknowledgements(new InvalidRecordStateException(ShareConsumeRequestManager.INVALID_RESPONSE));
            this.resultHandler.completeIfEmpty();
            this.isProcessed = true;
            this.maybeResetTimerAndRequestState();
        }

        private void processPendingInFlightAcknowledgements(KafkaException exception) {
            if (!this.inFlightAcknowledgements.isEmpty()) {
                this.inFlightAcknowledgements.forEach((partition, acknowledgements) -> {
                    acknowledgements.complete(exception);
                    this.resultHandler.complete((TopicIdPartition)partition, (Acknowledgements)acknowledgements, this.requestType, true, Optional.empty());
                });
                this.inFlightAcknowledgements.clear();
            }
        }

        void moveAllToIncompleteAcks() {
            this.incompleteAcknowledgements.putAll(this.inFlightAcknowledgements);
            this.inFlightAcknowledgements.clear();
        }

        boolean maybeExpire() {
            return this.numAttempts > 0 && this.isExpired();
        }

        public boolean moveToIncompleteAcks(TopicIdPartition tip) {
            Acknowledgements acks = this.inFlightAcknowledgements.remove(tip);
            if (acks != null) {
                this.incompleteAcknowledgements.put(tip, acks);
                return true;
            }
            ShareConsumeRequestManager.this.log.error("Invalid partition {} received in ShareAcknowledge response", (Object)tip);
            return false;
        }

        public boolean isCloseRequest() {
            return this.requestType == AcknowledgeRequestType.CLOSE;
        }
    }

    class ResultHandler {
        private final Map<TopicIdPartition, Acknowledgements> result = new HashMap<TopicIdPartition, Acknowledgements>();
        private final AtomicInteger remainingResults;
        private final Optional<CompletableFuture<Map<TopicIdPartition, Acknowledgements>>> future;

        ResultHandler(Optional<CompletableFuture<Map<TopicIdPartition, Acknowledgements>>> future) {
            this(null, future);
        }

        ResultHandler(AtomicInteger remainingResults, Optional<CompletableFuture<Map<TopicIdPartition, Acknowledgements>>> future) {
            this.remainingResults = remainingResults;
            this.future = future;
        }

        public void complete(TopicIdPartition partition, Acknowledgements acknowledgements, AcknowledgeRequestType type, boolean checkForRenewAcknowledgements, Optional<Integer> acquisitionLockTimeoutMs) {
            if (type.equals((Object)AcknowledgeRequestType.COMMIT_ASYNC)) {
                if (acknowledgements != null) {
                    ShareConsumeRequestManager.this.maybeSendShareAcknowledgementEvent(Map.of(partition, acknowledgements), checkForRenewAcknowledgements, acquisitionLockTimeoutMs);
                }
            } else {
                if (acknowledgements != null) {
                    this.result.put(partition, acknowledgements);
                }
                if (this.remainingResults != null && this.remainingResults.decrementAndGet() == 0) {
                    ShareConsumeRequestManager.this.maybeSendShareAcknowledgementEvent(this.result, checkForRenewAcknowledgements, acquisitionLockTimeoutMs);
                    this.future.ifPresent(future -> future.complete(this.result));
                }
            }
        }

        public void completeIfEmpty() {
            if (this.remainingResults != null && this.remainingResults.get() == 0) {
                this.future.ifPresent(future -> future.complete(this.result));
            }
        }
    }

    public static enum AcknowledgeRequestType {
        COMMIT_ASYNC(0),
        COMMIT_SYNC(1),
        CLOSE(2);

        public final byte id;

        private AcknowledgeRequestType(byte id) {
            this.id = id;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

