/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import java.util.function.Consumer;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.server.fault.FaultHandler;

public class DynamicClientQuotaPublisher
implements MetadataPublisher {
    private final int nodeId;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final Consumer<ClientQuotasDelta> clientQuotaUpdater;

    public DynamicClientQuotaPublisher(int nodeId, FaultHandler faultHandler, String nodeType, Consumer<ClientQuotasDelta> clientQuotaUpdater) {
        this.nodeId = nodeId;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.clientQuotaUpdater = clientQuotaUpdater;
    }

    @Override
    public String name() {
        return "DynamicClientQuotaPublisher " + this.nodeType + " id=" + this.nodeId;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        ClientQuotasDelta clientQuotasDelta = delta.clientQuotasDelta();
        if (clientQuotasDelta != null) {
            try {
                this.clientQuotaUpdater.accept(clientQuotasDelta);
            }
            catch (Throwable t) {
                this.faultHandler.handleFault("Uncaught exception while publishing dynamic client quota changes from MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset(), t);
            }
        }
    }
}

