/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.resource.spi.ConnectionManager;
import org.ops4j.pax.transx.connection.utils.SimpleConnectionManager;
import org.ops4j.pax.transx.jms.impl.ConnectionImpl;
import org.ops4j.pax.transx.jms.impl.JMSContextImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionFactoryImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class TransxConnectionFactory
implements TopicConnectionFactory,
QueueConnectionFactory,
AutoCloseable {
    private final ManagedConnectionFactoryImpl mcf;
    private final ConnectionManager cm;

    public TransxConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm != null ? cm : new SimpleConnectionManager();
    }

    @Override
    public void close() throws Exception {
        if (this.cm instanceof AutoCloseable) {
            ((AutoCloseable)this.cm).close();
        }
    }

    public ConnectionImpl createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public ConnectionImpl createConnection(String user, String password) throws JMSException {
        return new ConnectionImpl(this.mcf, this.cm, user, password, this.mcf.getClientID());
    }

    public ConnectionImpl createTopicConnection() throws JMSException {
        return this.createConnection();
    }

    public ConnectionImpl createTopicConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password);
    }

    public ConnectionImpl createQueueConnection() throws JMSException {
        return this.createConnection();
    }

    public ConnectionImpl createQueueConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password);
    }

    public JMSContext createContext() {
        return this.createContext(null, null, 1);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public JMSContext createContext(String user, String password) {
        return this.createContext(user, password, 1);
    }

    public JMSContext createContext(String user, String password, int sessionMode) {
        try {
            return new JMSContextImpl((Connection)this.createConnection(user, password), sessionMode);
        }
        catch (JMSException e) {
            throw Utils.convertToRuntimeException(e);
        }
    }
}

