/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlingExceptionRoutePolicyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.throttling.ThrottlingExceptionHalfOpenHandler;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;

@ManagedResource(description="Managed ThrottlingExceptionRoutePolicy")
public class ManagedThrottlingExceptionRoutePolicy
extends ManagedService
implements ManagedThrottlingExceptionRoutePolicyMBean {
    private final ThrottlingExceptionRoutePolicy policy;

    public ManagedThrottlingExceptionRoutePolicy(CamelContext context, ThrottlingExceptionRoutePolicy policy) {
        super(context, (Service)policy);
        this.policy = policy;
    }

    public ThrottlingExceptionRoutePolicy getPolicy() {
        return this.policy;
    }

    public Long getHalfOpenAfter() {
        return this.getPolicy().getHalfOpenAfter();
    }

    public void setHalfOpenAfter(Long milliseconds) {
        this.getPolicy().setHalfOpenAfter(milliseconds.longValue());
    }

    public Long getFailureWindow() {
        return this.getPolicy().getFailureWindow();
    }

    public void setFailureWindow(Long milliseconds) {
        this.getPolicy().setFailureWindow(milliseconds.longValue());
    }

    public Integer getFailureThreshold() {
        return this.getPolicy().getFailureThreshold();
    }

    public void setFailureThreshold(Integer numberOfFailures) {
        this.getPolicy().setFailureThreshold(numberOfFailures.intValue());
    }

    public String currentState() {
        return this.getPolicy().dumpState();
    }

    public String getHalfOpenHandlerName() {
        ThrottlingExceptionHalfOpenHandler obj = this.getPolicy().getHalfOpenHandler();
        if (obj != null) {
            return obj.getClass().getSimpleName();
        }
        return "";
    }

    public Integer getCurrentFailures() {
        return this.getPolicy().getFailures();
    }

    public Long getLastFailure() {
        if (this.getPolicy().getLastFailure() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.getPolicy().getLastFailure();
    }

    public Long getOpenAt() {
        if (this.getPolicy().getOpenedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.getPolicy().getOpenedAt();
    }
}

