/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.JmsService;
import org.apache.karaf.jms.internal.ActiveMQDestinationSourceFactory;
import org.apache.karaf.jms.internal.ArtemisDestinationSourceFactory;
import org.apache.karaf.jms.internal.DestinationSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class JmsServiceImpl
implements JmsService {
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private Path deployFolder = Paths.get(System.getProperty("karaf.base"), "deploy");

    @Override
    public void create(String name, String type, String url) throws Exception {
        this.create(name, type, url, null, null, "jmspooled");
    }

    @Override
    public void create(String name, String type, String url, String username, String password, String pool) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("JMS connection factory type not known");
        }
        if (this.connectionFactories().contains(name)) {
            throw new IllegalArgumentException("There is already a ConnectionFactory with the name " + name);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.jndi.service.name", "jms/" + name);
        ((Dictionary)properties).put("name", name);
        ((Dictionary)properties).put("type", type);
        this.put(properties, "url", url);
        this.put(properties, "user", username);
        this.put(properties, "password", password);
        if (pool.equals("narayana")) {
            this.put(properties, "pool", "narayana");
        }
        if (pool.equals("transx") || type.equalsIgnoreCase("activemq")) {
            this.put(properties, "pool", "transx");
        }
        Configuration config = this.configAdmin.createFactoryConfiguration("org.ops4j.connectionfactory", null);
        config.update(properties);
    }

    private void put(Dictionary<String, String> properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }

    @Override
    public void delete(String name) throws Exception {
        Configuration[] configs;
        String filter = String.format("(&(service.factoryPid=org.ops4j.connectionfactory)(%s=%s))", "name", name);
        for (Configuration config : configs = this.configAdmin.listConfigurations(filter)) {
            config.delete();
        }
    }

    @Override
    public List<String> connectionFactories() throws Exception {
        return this.bundleContext.getServiceReferences(ConnectionFactory.class, null).stream().map(this::getConnectionFactoryName).distinct().collect(Collectors.toList());
    }

    private String getConnectionFactoryName(ServiceReference<ConnectionFactory> reference) {
        if (reference.getProperty("osgi.jndi.service.name") != null) {
            return (String)reference.getProperty("osgi.jndi.service.name");
        }
        if (reference.getProperty("name") != null) {
            return (String)reference.getProperty("name");
        }
        return reference.getProperty("service.id").toString();
    }

    @Override
    public List<String> connectionFactoryFileNames() throws Exception {
        return Files.list(this.deployFolder).map(Path::getFileName).map(Path::toString).filter(name -> name.startsWith("connectionfactory-") && name.endsWith(".xml")).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> info(String connectionFactory, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            ConnectionMetaData metaData = context.getMetaData();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("product", metaData.getJMSProviderName());
            map.put("version", metaData.getProviderVersion());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public int count(String connectionFactory, String destination, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            int n;
            block13: {
                QueueBrowser browser = context.createBrowser(context.createQueue(destination));
                try {
                    Enumeration enumeration = browser.getEnumeration();
                    int count = 0;
                    while (enumeration.hasMoreElements()) {
                        enumeration.nextElement();
                        ++count;
                    }
                    n = count;
                    if (browser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (browser != null) {
                        try {
                            browser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                browser.close();
            }
            return n;
        }
    }

    private JMSContext createContext(String name, String username, String password) {
        return this.createContext(name, username, password, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMSContext createContext(String name, String username, String password, int sessionMode) {
        ServiceReference<ConnectionFactory> sr = this.lookupConnectionFactory(name);
        ConnectionFactory cf = (ConnectionFactory)this.bundleContext.getService(sr);
        try {
            JMSContext jMSContext = cf.createContext(username, password, sessionMode);
            return jMSContext;
        }
        finally {
            this.bundleContext.ungetService(sr);
        }
    }

    private ServiceReference<ConnectionFactory> lookupConnectionFactory(String name) {
        try {
            Collection references = this.bundleContext.getServiceReferences(ConnectionFactory.class, "(|(osgi.jndi.service.name=" + name + ")(name=" + name + ")(service.id=" + name + "))");
            return (ServiceReference)references.stream().sorted(Comparator.naturalOrder().reversed()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JMS connection factory found for " + name));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Error finding connection factory service " + name, e);
        }
    }

    private DestinationSource getDestinationSource(JMSContext context) throws JMSException {
        DestinationSource.Factory factory;
        List<DestinationSource.Factory> factories = Arrays.asList(new ActiveMQDestinationSourceFactory(), new ArtemisDestinationSourceFactory());
        DestinationSource source = null;
        Iterator<DestinationSource.Factory> iterator = factories.iterator();
        while (iterator.hasNext() && (source = (factory = iterator.next()).create(context)) == null) {
        }
        if (source == null) {
            source = d -> Collections.emptyList();
        }
        return source;
    }

    @Override
    public List<String> queues(String connectionFactory, String username, String password) throws JMSException, IOException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            List<String> list = this.getDestinationSource(context).getNames(DestinationSource.DestinationType.Queue);
            return list;
        }
    }

    @Override
    public List<String> topics(String connectionFactory, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            List<String> list = this.getDestinationSource(context).getNames(DestinationSource.DestinationType.Topic);
            return list;
        }
    }

    @Override
    public List<JmsMessage> browse(String connectionFactory, String queue, String filter, String username, String password) throws JMSException, IOException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            ArrayList<JmsMessage> arrayList;
            block13: {
                QueueBrowser browser = context.createBrowser(context.createQueue(queue), filter);
                try {
                    ArrayList<JmsMessage> messages = new ArrayList<JmsMessage>();
                    Enumeration enumeration = browser.getEnumeration();
                    while (enumeration.hasMoreElements()) {
                        Message message = (Message)enumeration.nextElement();
                        messages.add(new JmsMessage(message));
                    }
                    arrayList = messages;
                    if (browser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (browser != null) {
                        try {
                            browser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                browser.close();
            }
            return arrayList;
        }
    }

    @Override
    public void send(String connectionFactory, String queue, String body, String replyTo, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            JMSProducer producer = context.createProducer();
            if (replyTo != null) {
                producer.setJMSReplyTo((Destination)context.createQueue(replyTo));
            }
            producer.send((Destination)context.createQueue(queue), body);
        }
    }

    @Override
    public int consume(String connectionFactory, String queue, String selector, String username, String password) throws Exception {
        try (JMSContext context = this.createContext(connectionFactory, username, password);){
            int n;
            block13: {
                JMSConsumer consumer = context.createConsumer((Destination)context.createQueue(queue), selector);
                try {
                    Message message;
                    int count = 0;
                    do {
                        if ((message = consumer.receive(500L)) == null) continue;
                        ++count;
                    } while (message != null);
                    n = count;
                    if (consumer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                consumer.close();
            }
            return n;
        }
    }

    @Override
    public int move(String connectionFactory, String sourceQueue, String targetQueue, String selector, String username, String password) throws IOException, JMSException {
        try (JMSContext context = this.createContext(connectionFactory, username, password, 0);){
            int n;
            block13: {
                Queue source = context.createQueue(sourceQueue);
                Queue target = context.createQueue(targetQueue);
                JMSConsumer consumer = context.createConsumer((Destination)source, selector);
                try {
                    Message message;
                    int count = 0;
                    while ((message = consumer.receive(500L)) != null) {
                        context.createProducer().send((Destination)target, message);
                        context.commit();
                        ++count;
                    }
                    n = count;
                    if (consumer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                consumer.close();
            }
            return n;
        }
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

