/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.List;
import org.apache.karaf.bundle.core.BundleWatcher;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.Bundle;

@Command(scope="bundle", name="watch", description="Watches and updates bundles", detailedDescription="Watches the local maven repo for changes in snapshot jars and redploys changed jars")
@Service
public class Watch
implements Action {
    @Argument(index=0, name="urls", description="The bundle IDs or URLs", required=false, multiValued=true)
    List<String> urls;
    @Option(name="-i", aliases={}, description="Watch interval", required=false, multiValued=false)
    private long interval;
    @Option(name="--start", description="Starts watching the selected bundles", required=false, multiValued=false)
    protected boolean start;
    @Option(name="--stop", description="Stops watching all bundles", required=false, multiValued=false)
    protected boolean stop;
    @Option(name="--remove", description="Removes bundles from the watch list", required=false, multiValued=false)
    protected boolean remove;
    @Option(name="--list", description="Displays the watch list", required=false, multiValued=false)
    protected boolean list;
    @Reference
    private BundleWatcher bundleWatcher;

    public void setBundleWatcher(BundleWatcher bundleWatcher) {
        this.bundleWatcher = bundleWatcher;
    }

    public Object execute() throws Exception {
        if (this.start && this.stop) {
            System.err.println("Please use only one of --start and --stop options!");
            return null;
        }
        if (this.interval > 0L) {
            System.out.println("Setting watch interval to " + this.interval + " ms");
            this.bundleWatcher.setInterval(this.interval);
        }
        if (this.stop) {
            System.out.println("Stopping watch");
            this.bundleWatcher.stop();
        }
        if (this.urls != null) {
            if (this.remove) {
                for (String url : this.urls) {
                    this.bundleWatcher.remove(url);
                }
            } else {
                for (String url : this.urls) {
                    this.bundleWatcher.add(url);
                }
            }
        }
        if (this.start) {
            System.out.println("Starting watch");
            this.bundleWatcher.start();
        }
        if (this.list) {
            String format = "%-40s %6s %-80s";
            System.out.println(String.format(format, "URL", "ID", "Bundle Name"));
            for (String url : this.bundleWatcher.getWatchURLs()) {
                List<Bundle> bundleList = this.bundleWatcher.getBundlesByURL(url);
                if (bundleList != null && bundleList.size() > 0) {
                    for (Bundle bundle : bundleList) {
                        System.out.println(String.format(format, url, bundle.getBundleId(), bundle.getHeaders().get("Bundle-Name")));
                    }
                    continue;
                }
                System.out.println(String.format(format, url, "", ""));
            }
        } else {
            List<String> urls = this.bundleWatcher.getWatchURLs();
            if (urls != null && urls.size() > 0) {
                System.out.println("Watched URLs/IDs: ");
                for (String url : this.bundleWatcher.getWatchURLs()) {
                    System.out.println(url);
                }
            } else {
                System.out.println("No watched URLs/IDs");
            }
        }
        return null;
    }
}

