/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.log.core.LogEventFormatter;
import org.apache.karaf.log.core.internal.layout.PatternConverter;
import org.apache.karaf.log.core.internal.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.log.LogLevel;

public class LogEventFormatterImpl
implements LogEventFormatter {
    private String pattern;
    private Map<LogLevel, String> level2Color = new HashMap<LogLevel, String>();

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setColor(LogLevel level, String color) {
        if (color != null && color.length() > 0) {
            this.level2Color.put(level, color);
        } else {
            this.level2Color.remove(level);
        }
    }

    @Override
    public String format(PaxLoggingEvent event, String overridenPattern, boolean noColor) {
        PatternConverter cnv = new PatternParser(overridenPattern != null ? overridenPattern : this.pattern).parse();
        String color = this.getColor(event, noColor);
        StringBuffer sb = new StringBuffer();
        this.color(sb, color);
        PatternConverter pc = cnv;
        while (pc != null) {
            pc.format(sb, event);
            pc = pc.next;
        }
        if (event.getThrowableStrRep() != null) {
            for (String r : event.getThrowableStrRep()) {
                sb.append(r).append('\n');
            }
        }
        this.color(sb, "0");
        return sb.toString();
    }

    private void color(StringBuffer sb, String color) {
        if (color != null) {
            sb.append('\u001b');
            sb.append('[');
            sb.append(color);
            sb.append('m');
        }
    }

    private String getColor(PaxLoggingEvent event, boolean noColor) {
        if (!noColor && event != null && event.getLevel() != null && event.getLevel().toString() != null) {
            return this.level2Color.get(event.getLevel());
        }
        return null;
    }
}

