/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.spi.cluster.impl.selector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.spi.cluster.impl.selector.RoundRobinSelector;
import org.apache.kyuubi.shade.io.vertx.core.spi.cluster.impl.selector.SimpleRoundRobinSelector;
import org.apache.kyuubi.shade.io.vertx.core.spi.cluster.impl.selector.Weight;
import org.apache.kyuubi.shade.io.vertx.core.spi.cluster.impl.selector.WeightedRoundRobinSelector;

class SelectorEntry {
    final RoundRobinSelector selector;
    final Promise<RoundRobinSelector> selectorPromise;
    final int counter;

    SelectorEntry() {
        this.selector = null;
        this.selectorPromise = Promise.promise();
        this.counter = 0;
    }

    private SelectorEntry(RoundRobinSelector selector, Promise<RoundRobinSelector> selectorPromise, int counter) {
        this.selector = selector;
        this.selectorPromise = selectorPromise;
        this.counter = counter;
    }

    SelectorEntry increment() {
        return new SelectorEntry(null, this.selectorPromise, this.counter + 1);
    }

    SelectorEntry data(List<String> nodeIds) {
        if (nodeIds == null || nodeIds.isEmpty()) {
            return null;
        }
        Map<String, Weight> weights = this.computeWeights(nodeIds);
        RoundRobinSelector selector = this.isEvenlyDistributed(weights) ? new SimpleRoundRobinSelector(new ArrayList<String>(weights.keySet())) : new WeightedRoundRobinSelector(weights);
        return new SelectorEntry(selector, this.selectorPromise, this.counter);
    }

    private Map<String, Weight> computeWeights(List<String> nodeIds) {
        HashMap<String, Weight> weights = new HashMap<String, Weight>();
        for (String nodeId : nodeIds) {
            weights.compute(nodeId, (s, weight) -> weight == null ? new Weight(0) : weight.increment());
        }
        return weights;
    }

    private boolean isEvenlyDistributed(Map<String, Weight> weights) {
        if (weights.size() > 1) {
            Weight previous = null;
            for (Weight weight : weights.values()) {
                if (previous != null && previous.value() != weight.value()) {
                    return false;
                }
                previous = weight;
            }
        }
        return true;
    }

    boolean shouldInitialize() {
        return this.counter == 0;
    }

    boolean isNotReady() {
        return this.selector == null;
    }
}

