/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ServerSocket;
import java.util.Base64;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.cli.Handle$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.KyuubiTHttpFrontendService$;
import org.apache.kyuubi.server.http.ThriftHttpServlet;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.TFrontendService;
import org.apache.kyuubi.service.TFrontendService$;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.kyuubi.shaded.thrift.TProcessor;
import org.apache.kyuubi.shaded.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.util.NamedThreadFactory;
import org.apache.kyuubi.util.SSLUtils$;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0014(\u0005AB\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0005\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!)Q\b\u0001C\u0001}!A!\t\u0001EC\u0002\u0013E3\t\u0003\u0005V\u0001!\u0015\r\u0011\"\u0015W\u0011!Q\u0006\u0001#b\u0001\n#2\u0006\u0002C.\u0001\u0011\u000b\u0007I\u0011\u000b/\t\u000f\u0015\u0004\u0001\u0019!C\u0005\u0007\"9a\r\u0001a\u0001\n\u00139\u0007BB7\u0001A\u0003&A\tC\u0004o\u0001\u0001\u0007I\u0011B\"\t\u000f=\u0004\u0001\u0019!C\u0005a\"1!\u000f\u0001Q!\n\u0011Cqa\u001d\u0001A\u0002\u0013%1\tC\u0004u\u0001\u0001\u0007I\u0011B;\t\r]\u0004\u0001\u0015)\u0003E\u0011\u001dA\u0003\u00011A\u0005\naD\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\t\u000f\u00055\u0001\u0001)Q\u0005s\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0014!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002\"CA\u001a\u0001!\u0015\r\u0011\"\u0003W\u0011\u001d\t)\u0004\u0001C!\u0003oAq!a\u0012\u0001\t\u0003\nI\u0005C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005M\u0004\u0001\"\u0015\u0002r!9\u0011Q\u000f\u0001\u0005R\u0005]\u0004\"CA@\u0001\t\u0007I\u0011IAA\u0011!\tY\t\u0001Q\u0001\n\u0005\r\u0005bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\tI\u000b\u0001C)\u0003WCq!!,\u0001\t#\ny\u000bC\u0004\u0002J\u0002!\t&a3\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011Q\u001c\u0001\u0005B\u0005E$AG&zkV\u0014\u0017\u000e\u0016%uiB4%o\u001c8uK:$7+\u001a:wS\u000e,'B\u0001\u0015*\u0003\u0019\u0019XM\u001d<fe*\u0011!fK\u0001\u0007Wf,XOY5\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025S\u000591/\u001a:wS\u000e,\u0017B\u0001\u001c4\u0005A!fI]8oi\u0016tGmU3sm&\u001cW-\u0001\u0006tKJ4XM]1cY\u0016,\u0012!\u000f\t\u0003eiJ!aO\u001a\u0003\u0015M+'O^3sC\ndW-A\u0006tKJ4XM]1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002@\u0003B\u0011\u0001\tA\u0007\u0002O!)qg\u0001a\u0001s\u0005Q1/\u001a:wKJDun\u001d;\u0016\u0003\u0011\u00032!\u0012%K\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB(qi&|g\u000e\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001b\u001ak\u0011A\u0014\u0006\u0003\u001f>\na\u0001\u0010:p_Rt\u0014BA)G\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E3\u0015a\u00029peRtU/\\\u000b\u0002/B\u0011Q\tW\u0005\u00033\u001a\u00131!\u00138u\u0003)\t7\r^;bYB{'\u000f^\u0001\rg\u0016\u0014h/\u001a:T_\u000e\\W\r^\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0004]\u0016$(\"\u00012\u0002\t)\fg/Y\u0005\u0003I~\u0013AbU3sm\u0016\u00148k\\2lKR\fAb[3z'R|'/\u001a)bi\"\f\u0001c[3z'R|'/\u001a)bi\"|F%Z9\u0015\u0005!\\\u0007CA#j\u0013\tQgI\u0001\u0003V]&$\bb\u00027\n\u0003\u0003\u0005\r\u0001R\u0001\u0004q\u0012\n\u0014!D6fsN#xN]3QCRD\u0007%\u0001\tlKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0006!2.Z=Ti>\u0014X\rU1tg^|'\u000fZ0%KF$\"\u0001[9\t\u000f1d\u0011\u0011!a\u0001\t\u0006\t2.Z=Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\u0002!-,\u0017p\u0015;pe\u0016$\u0016\u0010]3`I\u0015\fHC\u00015w\u0011\u001daw\"!AA\u0002\u0011\u000bQb[3z'R|'/\u001a+za\u0016\u0004S#A=\u0011\u0007\u0015C%\u0010E\u0002|\u0003\u0007i\u0011\u0001 \u0006\u0003QuT!A`@\u0002\u000b),G\u000f^=\u000b\u0007\u0005\u0005Q&A\u0004fG2L\u0007o]3\n\u0007\u0005\u0015AP\u0001\u0004TKJ4XM]\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHc\u00015\u0002\f!9ANEA\u0001\u0002\u0004I\u0018aB:feZ,'\u000fI\u0001\u0013\u0003B\u0003F*S\"B)&{ej\u0018+I%&3E+\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0005\fA\u0001\\1oO&\u00191+a\u0006\u0002'\u0005\u0003\u0006\u000bT%D\u0003RKuJT0U\u0011JKe\t\u0016\u0011\u0002\u0015!\fGm\\8q\u0007>tg-\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001B2p]\u001aT1!!\f,\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011GA\u0014\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0001B-\u001a4bk2$h)\u001a;dQNK'0Z\u0001\u000bS:LG/[1mSj,Gc\u00015\u0002:!9\u0011\u0011\u0006\rA\u0002\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u0013&\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003\u000b\nyD\u0001\u0006LsV,(-[\"p]\u001a\f1b\u00149f]N+7o]5p]R!\u00111JA3!\u0011\ti%!\u0019\u000e\u0005\u0005=#\u0002BA)\u0003'\na\u0001\u001e5sS\u001a$(\u0002BA+\u0003/\n1A\u001d9d\u0015\r!\u0014\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003iSZ,'bAA0S\u000511\u000f[1eK\u0012LA!a\u0019\u0002P\t\u0001Bk\u00149f]N+7o]5p]J+7\u000f\u001d\u0005\b\u0003OJ\u0002\u0019AA5\u0003\r\u0011X-\u001d\t\u0005\u0003\u001b\nY'\u0003\u0003\u0002n\u0005=#a\u0004+Pa\u0016t7+Z:tS>t'+Z9\u0002\u0007I,h\u000eF\u0001i\u0003)\u0019Ho\u001c9TKJ4XM]\u0001\tSN\u001cVM\u001d<feR\u0011\u0011\u0011\u0010\t\u0004\u000b\u0006m\u0014bAA?\r\n9!i\\8mK\u0006t\u0017\u0001\u00053jg\u000e|g/\u001a:z'\u0016\u0014h/[2f+\t\t\u0019\t\u0005\u0003F\u0011\u0006\u0015\u0005c\u0001\u001a\u0002\b&\u0019\u0011\u0011R\u001a\u0003\u000fM+'O^5dK\u0006\tB-[:d_Z,'/_*feZL7-\u001a\u0011\u0002\u0017\u001d,G\u000f\u0013;uaB\u000bG\u000f\u001b\u000b\u0004\u0015\u0006E\u0005BBAJ?\u0001\u0007!*\u0001\u0005iiR\u0004\b+\u0019;i\u0003Q\u0019wN\\:ue\u0006Lg\u000e\u0013;ua6+G\u000f[8egR\u0019\u0001.!'\t\u000f\u0005m\u0005\u00051\u0001\u0002\u001e\u0006Q1\r\u001e=IC:$G.\u001a:\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)~\u0003\u001d\u0019XM\u001d<mKRLA!a*\u0002\"\n)2+\u001a:wY\u0016$8i\u001c8uKb$\b*\u00198eY\u0016\u0014\u0018\u0001D4fi&\u0003\u0018\t\u001a3sKN\u001cX#\u0001&\u0002\u0019\u001d,G\u000f\u0015:pqf,6/\u001a:\u0015\u000f)\u000b\t,!1\u0002F\"9\u00111\u0017\u0012A\u0002\u0005U\u0016aC:fgNLwN\\\"p]\u001a\u0004b!a.\u0002>*SUBAA]\u0015\r\tY,Y\u0001\u0005kRLG.\u0003\u0003\u0002@\u0006e&aA'ba\"1\u00111\u0019\u0012A\u0002)\u000b\u0011\"\u001b9BI\u0012\u0014Xm]:\t\r\u0005\u001d'\u00051\u0001K\u0003!\u0011X-\u00197Vg\u0016\u0014\u0018!G4fiJ+\u0017\r\\+tKJ\fe\u000eZ*fgNLwN\\+tKJ$B!!4\u0002TB)Q)a4K\u0015&\u0019\u0011\u0011\u001b$\u0003\rQ+\b\u000f\\33\u0011\u001d\t9g\ta\u0001\u0003S\nAbZ3u'\"|'\u000f\u001e(b[\u0016$2ASAm\u0011\u0019\tY\u000e\na\u0001\u0015\u0006AQo]3s\u001d\u0006lW-A\u0003ti\u0006\u0014H\u000f")
public final class KyuubiTHttpFrontendService
extends TFrontendService {
    private Option<String> serverHost;
    private int portNum;
    private int actualPort;
    private ServerSocket serverSocket;
    private int defaultFetchSize;
    private final Serverable serverable;
    private Option<String> keyStorePath;
    private Option<String> keyStorePassword;
    private Option<String> keyStoreType;
    private Option<Server> server;
    private final String APPLICATION_THRIFT;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private Option<String> serverHost$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverHost = (Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_HOST());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverHost;
    }

    public Option<String> serverHost() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serverHost$lzycompute();
        }
        return this.serverHost;
    }

    private int portNum$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.portNum = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.portNum;
    }

    public int portNum() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.portNum$lzycompute();
        }
        return this.portNum;
    }

    private int actualPort$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.actualPort = this.portNum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.actualPort;
    }

    public int actualPort() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.actualPort$lzycompute();
        }
        return this.actualPort;
    }

    private ServerSocket serverSocket$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.serverSocket = null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.serverSocket;
    }

    public ServerSocket serverSocket() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.serverSocket$lzycompute();
        }
        return this.serverSocket;
    }

    private Option<String> keyStorePath() {
        return this.keyStorePath;
    }

    private void keyStorePath_$eq(Option<String> x$1) {
        this.keyStorePath = x$1;
    }

    private Option<String> keyStorePassword() {
        return this.keyStorePassword;
    }

    private void keyStorePassword_$eq(Option<String> x$1) {
        this.keyStorePassword = x$1;
    }

    private Option<String> keyStoreType() {
        return this.keyStoreType;
    }

    private void keyStoreType_$eq(Option<String> x$1) {
        this.keyStoreType = x$1;
    }

    private Option<Server> server() {
        return this.server;
    }

    private void server_$eq(Option<Server> x$1) {
        this.server = x$1;
    }

    private String APPLICATION_THRIFT() {
        return this.APPLICATION_THRIFT;
    }

    public Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    private int defaultFetchSize$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.defaultFetchSize = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.KYUUBI_SERVER_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.defaultFetchSize;
    }

    private int defaultFetchSize() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.defaultFetchSize$lzycompute();
        }
        return this.defaultFetchSize;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (this.authFactory().kerberosEnabled() && this.authFactory().effectivePlainAuthType().isEmpty()) {
            throw new AuthenticationException("Kerberos is not supported for Thrift HTTP mode");
        }
        try {
            ServerConnector serverConnector;
            String schemeName;
            int minThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MIN_WORKER_THREADS()));
            int maxThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_WORKER_THREADS()));
            long keepAliveTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME()));
            ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(new StringBuilder(16).append(this.getName()).append("HttpHandler-Pool").toString(), false));
            ExecutorThreadPool threadPool = new ExecutorThreadPool(executor);
            this.server_$eq((Option<Server>)new Some((Object)new Server((ThreadPool)threadPool)));
            HttpConfiguration httpConf = new HttpConfiguration();
            int requestHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_REQUEST_HEADER_SIZE()));
            int responseHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_RESPONSE_HEADER_SIZE()));
            boolean jettySendVersionEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()));
            httpConf.setRequestHeaderSize(requestHeaderSize);
            httpConf.setResponseHeaderSize(responseHeaderSize);
            httpConf.setSendServerVersion(jettySendVersionEnabled);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConf);
            boolean useSsl = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_USE_SSL()));
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                this.keyStorePath_$eq((Option<String>)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH())));
                if (this.keyStorePath().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().key()).append(" Not configured for SSL connection, please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().doc()).toString());
                }
                this.keyStorePassword_$eq((Option<String>)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD())));
                if (this.keyStorePassword().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().key()).append(" Not configured for SSL connection. please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().doc()).toString());
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                Seq excludedProtocols = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_PROTOCOL_BLACKLIST());
                Seq excludeCipherSuites = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_EXCLUDE_CIPHER_SUITES());
                this.keyStoreType_$eq((Option<String>)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_TYPE())));
                Option keyStoreAlgorithm = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_ALGORITHM());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Thrift HTTP Server SSL: adding excluded protocols: ").append(String.join((CharSequence)",", (CharSequence[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeProtocols())).toString());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Thrift HTTP Server SSL: setting excluded cipher Suites: ").append(String.join((CharSequence)",", (CharSequence[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.setExcludeCipherSuites((String[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeCipherSuites = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeCipherSuites())).toString());
                sslContextFactory.setKeyStorePath((String)this.keyStorePath().get());
                sslContextFactory.setKeyStorePassword((String)this.keyStorePassword().get());
                this.keyStoreType().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyStoreType(x$1);
                    return BoxedUnit.UNIT;
                });
                keyStoreAlgorithm.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyManagerFactoryAlgorithm(x$1);
                    return BoxedUnit.UNIT;
                });
                serverConnector = new ServerConnector((Server)this.server().get(), (SslContextFactory)sslContextFactory, new ConnectionFactory[]{connectionFactory});
            } else {
                serverConnector = new ServerConnector((Server)this.server().get(), new ConnectionFactory[]{connectionFactory});
            }
            ServerConnector connector = serverConnector;
            connector.setPort(this.portNum());
            connector.setReuseAddress(!SystemUtils.IS_OS_WINDOWS);
            long maxIdleTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_MAX_IDLE_TIME()));
            connector.setIdleTimeout(maxIdleTime);
            connector.setAcceptQueueSize(maxThreads);
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.addConnector((Connector)connector);
                return BoxedUnit.UNIT;
            });
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            ThriftHttpServlet servlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, this.authFactory(), conf);
            servlet.init();
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            context.addEventListener((EventListener)new ServletContextListener(null){

                public void contextInitialized(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextInitialized$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public void contextDestroyed(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextDestroyed$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$contextInitialized$1(MetricsSystem ms) {
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_TOTAL());
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                public static final /* synthetic */ void $anonfun$contextDestroyed$1(MetricsSystem ms) {
                    ms.decCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$contextInitialized$1$adapted(org.apache.kyuubi.metrics.MetricsSystem ), $anonfun$contextDestroyed$1$adapted(org.apache.kyuubi.metrics.MetricsSystem )}, serializedLambda);
                }
            });
            String httpPath = this.getHttpPath((String)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_PATH()));
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COMPRESSION_ENABLED()))) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{HttpMethod.POST.asString()});
                gzipHandler.addIncludedMimeTypes(new String[]{this.APPLICATION_THRIFT()});
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.setHandler((Handler)gzipHandler);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.setHandler((Handler)context);
                    return BoxedUnit.UNIT;
                });
            }
            context.addServlet(new ServletHolder((Servlet)servlet), httpPath);
            this.constrainHttpMethods(context);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Started ").append(this.getClass().getSimpleName()).append(" in ").append(schemeName).append(" mode on port ").append(this.portNum()).append(" ").append("path=").append(httpPath).append(" with ").append(minThreads).append(" ... ").append(maxThreads).append(" threads").toString());
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_FAIL());
                return BoxedUnit.UNIT;
            });
            this.error((Function0 & Serializable & scala.Serializable)() -> e);
            throw new KyuubiException(new StringBuilder(43).append("Failed to initialize frontend service on ").append(this.serverAddr()).append(":").append(this.portNum()).append(".").toString(), e);
        }
        super.initialize(conf);
    }

    public TOpenSessionResp OpenSession(TOpenSessionReq req) {
        this.debug((Function0 & Serializable & scala.Serializable)() -> req.toString());
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Client protocol version: ").append(req.getClient_protocol()).toString());
        TOpenSessionResp resp = new TOpenSessionResp();
        try {
            SessionHandle sessionHandle = this.getSessionHandle(req, resp);
            HashMap<String, String> respConfiguration = new HashMap<String, String>();
            Operation launchEngineOp = ((KyuubiSessionImpl)this.be().sessionManager().getSession(sessionHandle)).launchEngineOp();
            THandleIdentifier opHandleIdentifier = Handle$.MODULE$.toTHandleIdentifier(launchEngineOp.getHandle().identifier());
            respConfiguration.put("kyuubi.session.engine.launch.handle.guid", Base64.getEncoder().encodeToString(opHandleIdentifier.getGuid()));
            respConfiguration.put("kyuubi.session.engine.launch.handle.secret", Base64.getEncoder().encodeToString(opHandleIdentifier.getSecret()));
            respConfiguration.put("kyuubi.session.engine.launch.support.result", Boolean.toString(true));
            respConfiguration.put("hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.defaultFetchSize()));
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(respConfiguration);
            resp.setStatus(TFrontendService$.MODULE$.OK_STATUS());
            Option$.MODULE$.apply(TFrontendService$.MODULE$.CURRENT_SERVER_CONTEXT().get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.setSessionHandle(sessionHandle);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> "Error opening session: ", e);
            resp.setStatus(KyuubiSQLException$.MODULE$.toTStatus(e, true));
        }
        return resp;
    }

    public void run() {
        try {
            if (this.isServer()) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting and exposing JDBC connection at: jdbc:hive2://").append(this.connectionUrl()).append("/").toString());
            }
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.start();
                return BoxedUnit.UNIT;
            });
        }
        catch (InterruptedException interruptedException) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is interrupted").toString());
        }
        catch (Throwable t) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error starting ").append(this.getName()).toString(), t);
            System.exit(-1);
        }
    }

    public void stopServer() {
        this.server().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.stop();
            return BoxedUnit.UNIT;
        });
        this.server_$eq((Option<Server>)None$.MODULE$);
    }

    public boolean isServer() {
        return true;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    private String getHttpPath(String httpPath) {
        block7: {
            block6: {
                if (httpPath == null) break block6;
                String string = httpPath;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block7;
            }
            return "/*";
        }
        if (!httpPath.startsWith("/")) {
            return new StringBuilder(1).append("/").append(httpPath).toString();
        }
        if (httpPath.endsWith("/")) {
            return new StringBuilder(1).append(httpPath).append("*").toString();
        }
        if (!httpPath.endsWith("/*")) {
            return new StringBuilder(2).append(httpPath).append("/*").toString();
        }
        return httpPath;
    }

    public void constrainHttpMethods(ServletContextHandler ctxHandler) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(constraint);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        ConstraintMapping cmo = new ConstraintMapping();
        cmo.setConstraint(constraint);
        cmo.setMethod("OPTIONS");
        cmo.setPathSpec("/*");
        securityHandler.setConstraintMappings((ConstraintMapping[])((Object[])new ConstraintMapping[]{cmt, cmo}));
        ctxHandler.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    public String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        Option option = Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getProxyUserName());
        if (option instanceof Some) {
            Some some = (Some)option;
            String proxyUser = (String)some.value();
            scala.collection.immutable.Map proxyUserConf = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), (Object)proxyUser)}));
            return super.getProxyUser((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(sessionConf).asScala()).$plus$plus((GenTraversableOnce)proxyUserConf)).asJava(), ipAddress, realUser);
        }
        if (None$.MODULE$.equals(option)) {
            return super.getProxyUser(sessionConf, ipAddress, realUser);
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, String> getRealUserAndSessionUser(TOpenSessionReq req) {
        String realUser = this.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> req.getUsername()));
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String sessionUser = req.getConfiguration() == null ? realUser : this.getProxyUser(req.getConfiguration(), ipAddress, realUser);
        this.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Client's real user: ").append(realUser).append(", session user: ").append(sessionUser).toString());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)realUser), (Object)sessionUser);
    }

    private String getShortName(String userName) {
        String ret;
        block0: {
            ret = null;
            if (userName == null) break block0;
            int indexOfDomainMatch = ServiceUtils$.MODULE$.indexOfDomainMatch(userName);
            ret = indexOfDomainMatch <= 0 ? userName : userName.substring(0, indexOfDomainMatch);
        }
        return ret;
    }

    public void start() {
        super.start();
        SSLUtils$.MODULE$.tracingThriftSSLCertExpiration(this.keyStorePath(), this.keyStorePassword(), this.keyStoreType());
    }

    public KyuubiTHttpFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiTHttpFrontendService");
        this.keyStorePath = None$.MODULE$;
        this.keyStorePassword = None$.MODULE$;
        this.keyStoreType = None$.MODULE$;
        this.server = None$.MODULE$;
        this.APPLICATION_THRIFT = "application/x-thrift";
        this.discoveryService = None$.MODULE$;
    }
}

