/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.util.UUID;

public class UuidUtils {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static UUID generateUUIDv7() {
        long epochMs = System.currentTimeMillis();
        return UuidUtils.generateUUIDv7(epochMs);
    }

    public static UUID generateUUIDv7(long epochMs) {
        if (epochMs >> 48 != 0L) {
            throw new IllegalArgumentException("Invalid timestamp: does not fit within 48 bits: " + epochMs);
        }
        byte[] randomBytes = new byte[10];
        SECURE_RANDOM.nextBytes(randomBytes);
        ByteBuffer rb = ByteBuffer.wrap(randomBytes).order(ByteOrder.BIG_ENDIAN);
        long randMSB = (long)rb.getShort() & 0xFFFL;
        long randLSB = rb.getLong() & 0x3FFFFFFFFFFFFFFFL;
        long msb = epochMs << 16;
        msb |= 0x7000L;
        long lsb = Long.MIN_VALUE;
        return new UUID(msb |= randMSB, lsb |= randLSB);
    }
}

