/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.commits;

import java.io.IOException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.luke.models.util.IndexUtils;

public final class Commit {
    private long generation;
    private boolean isDeleted;
    private int segCount;
    private String userData;

    static Commit of(IndexCommit ic) {
        Commit commit = new Commit();
        commit.generation = ic.getGeneration();
        commit.isDeleted = ic.isDeleted();
        commit.segCount = ic.getSegmentCount();
        try {
            commit.userData = IndexUtils.getCommitUserData(ic);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return commit;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public int getSegCount() {
        return this.segCount;
    }

    public String getUserData() {
        return this.userData;
    }

    private Commit() {
    }
}

