/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.knn;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTCompiler;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class KnnVectorDict
implements Closeable {
    private final FST<Long> fst;
    private final IndexInput vectors;
    private final int dimension;

    public KnnVectorDict(Directory directory, String dictName) throws IOException {
        try (IndexInput fstIn = directory.openInput(dictName + ".fst", IOContext.READ);){
            this.fst = new FST(FST.readMetadata((DataInput)fstIn, (Outputs)PositiveIntOutputs.getSingleton()), (DataInput)fstIn);
        }
        this.vectors = directory.openInput(dictName + ".bin", IOContext.READ);
        long size = this.vectors.length();
        this.vectors.seek(size - 4L);
        this.dimension = this.vectors.readInt();
        if ((size - 4L) % ((long)this.dimension * 4L) != 0L) {
            throw new IllegalStateException("vector file size " + size + " is not consonant with the vector dimension " + this.dimension);
        }
    }

    public void get(BytesRef token, byte[] output) throws IOException {
        if (output.length != this.dimension * 4) {
            throw new IllegalArgumentException("the output array must be of length " + this.dimension * 4 + ", got " + output.length);
        }
        Long ord = (Long)Util.get(this.fst, (BytesRef)token);
        if (ord == null) {
            Arrays.fill(output, (byte)0);
        } else {
            this.vectors.seek(ord * (long)this.dimension * 4L);
            this.vectors.readBytes(output, 0, output.length);
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public void close() throws IOException {
        this.vectors.close();
    }

    public static void build(Path gloveInput, Directory directory, String dictName) throws IOException {
        new Builder().build(gloveInput, directory, dictName);
    }

    public long ramBytesUsed() {
        return this.fst.ramBytesUsed() + this.vectors.length();
    }

    private static class Builder {
        private static final Pattern SPACE_RE = Pattern.compile(" ");
        private final IntsRefBuilder intsRefBuilder = new IntsRefBuilder();
        private final FSTCompiler<Long> fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE1, (Outputs)PositiveIntOutputs.getSingleton()).build();
        private float[] scratch;
        private ByteBuffer byteBuffer;
        private long ordinal = 1L;
        private int numFields;

        Builder() throws IOException {
        }

        void build(Path gloveInput, Directory directory, String dictName) throws IOException {
            try (BufferedReader in = Files.newBufferedReader(gloveInput);
                 IndexOutput binOut = directory.createOutput(dictName + ".bin", IOContext.DEFAULT);
                 IndexOutput fstOut = directory.createOutput(dictName + ".fst", IOContext.DEFAULT);){
                this.writeFirstLine(in, binOut);
                while (this.addOneLine(in, binOut)) {
                }
                FST.fromFSTReader((FST.FSTMetadata)this.fstCompiler.compile(), (FSTReader)this.fstCompiler.getFSTReader()).save((DataOutput)fstOut, (DataOutput)fstOut);
                binOut.writeInt(this.numFields - 1);
            }
        }

        private void writeFirstLine(BufferedReader in, IndexOutput out) throws IOException {
            String[] fields = this.readOneLine(in);
            if (fields == null) {
                return;
            }
            this.numFields = fields.length;
            this.byteBuffer = ByteBuffer.allocate((this.numFields - 1) * 4).order(ByteOrder.LITTLE_ENDIAN);
            this.scratch = new float[this.numFields - 1];
            this.writeVector(fields, out);
        }

        private String[] readOneLine(BufferedReader in) throws IOException {
            String line = in.readLine();
            if (line == null) {
                return null;
            }
            return SPACE_RE.split(line, 0);
        }

        private boolean addOneLine(BufferedReader in, IndexOutput out) throws IOException {
            String[] fields = this.readOneLine(in);
            if (fields == null) {
                return false;
            }
            if (fields.length != this.numFields) {
                throw new IllegalStateException("different field count at line " + this.ordinal + " got " + fields.length + " when expecting " + this.numFields);
            }
            this.fstCompiler.add(Util.toIntsRef((BytesRef)new BytesRef((CharSequence)fields[0]), (IntsRefBuilder)this.intsRefBuilder), (Object)this.ordinal++);
            this.writeVector(fields, out);
            return true;
        }

        private void writeVector(String[] fields, IndexOutput out) throws IOException {
            this.byteBuffer.position(0);
            FloatBuffer floatBuffer = this.byteBuffer.asFloatBuffer();
            for (int i = 1; i < fields.length; ++i) {
                this.scratch[i - 1] = Float.parseFloat(fields[i]);
            }
            VectorUtil.l2normalize((float[])this.scratch);
            floatBuffer.put(this.scratch);
            byte[] bytes = this.byteBuffer.array();
            out.writeBytes(bytes, bytes.length);
        }
    }
}

