/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.ReportingSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.WritableSchema;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class ProvenanceReportingSchema
extends BaseSchema
implements WritableSchema {
    public static final String DEFAULT_PROV_REPORTING_TASK_CLASS = "org.apache.nifi.reporting.SiteToSiteProvenanceReportingTask";
    public static final String DESTINATION_URL_KEY = "destination url";
    public static final String PORT_NAME_KEY = "port name";
    public static final String ORIGINATING_URL_KEY = "originating url";
    public static final String BATCH_SIZE_KEY = "batch size";
    public static final String DEFAULT_ORGINATING_URL = "http://${hostname(true)}:8080/nifi";
    public static final String DEFAULT_TIMEOUT = "30 secs";
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final boolean DEFAULT_USE_COMPRESSION = true;
    private String schedulingStrategy;
    private String schedulingPeriod;
    private String destinationUrl;
    private String portName;
    private String comment;
    private String originatingUrl = "http://${hostname(true)}:8080/nifi";
    private Boolean useCompression = true;
    private String timeout = "30 secs";
    private Number batchSize = 1000;
    private String SSL;

    public ProvenanceReportingSchema(Map map) {
        this.schedulingStrategy = this.getRequiredKeyAsType(map, "scheduling strategy", String.class, "Provenance Reporting");
        if (this.schedulingStrategy != null) {
            try {
                SchedulingStrategy.valueOf((String)this.schedulingStrategy);
            }
            catch (IllegalArgumentException e) {
                this.addValidationIssue("scheduling strategy", "Provenance Reporting", "it is not a valid scheduling strategy");
            }
        }
        this.schedulingPeriod = this.getRequiredKeyAsType(map, "scheduling period", String.class, "Provenance Reporting");
        this.comment = this.getOptionalKeyAsType(map, "comment", String.class, "Provenance Reporting", "");
        this.originatingUrl = this.getOptionalKeyAsType(map, ORIGINATING_URL_KEY, String.class, "Provenance Reporting", DEFAULT_ORGINATING_URL);
        this.destinationUrl = this.getRequiredKeyAsType(map, DESTINATION_URL_KEY, String.class, "Provenance Reporting");
        this.portName = this.getRequiredKeyAsType(map, PORT_NAME_KEY, String.class, "Provenance Reporting");
        this.useCompression = this.getOptionalKeyAsType(map, "use compression", Boolean.class, "Provenance Reporting", true);
        this.timeout = this.getOptionalKeyAsType(map, "timeout", String.class, "Provenance Reporting", DEFAULT_TIMEOUT);
        this.batchSize = this.getOptionalKeyAsType(map, BATCH_SIZE_KEY, Number.class, "Provenance Reporting", 1000);
    }

    public ReportingSchema convert() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Destination URL", this.destinationUrl);
        properties.put("Input Port Name", this.portName);
        properties.put("Instance URL", this.originatingUrl);
        properties.put("Compress Events", this.useCompression);
        properties.put("Batch Size", this.batchSize);
        properties.put("Communications Timeout", this.timeout);
        properties.put("SSL Context Service", this.SSL);
        Map<String, Object> target = this.mapSupplier.get();
        target.put("class", DEFAULT_PROV_REPORTING_TASK_CLASS);
        target.put("comment", this.comment);
        target.put("scheduling strategy", this.schedulingStrategy);
        target.put("scheduling period", this.schedulingPeriod);
        target.put("Properties", properties);
        ReportingSchema provenance = new ReportingSchema(target);
        return provenance;
    }

    @Override
    public Map<String, Object> toMap() {
        Map result = (Map)this.mapSupplier.get();
        result.put("comment", this.comment);
        result.put("scheduling strategy", this.schedulingStrategy);
        result.put("scheduling period", this.schedulingPeriod);
        result.put(DESTINATION_URL_KEY, this.destinationUrl);
        result.put(PORT_NAME_KEY, this.portName);
        result.put(ORIGINATING_URL_KEY, this.originatingUrl);
        result.put("use compression", this.useCompression);
        result.put("timeout", this.timeout);
        result.put(BATCH_SIZE_KEY, this.batchSize);
        return result;
    }

    public void setSSL(boolean useSSL) {
        this.SSL = useSSL ? "SSL-Context-Service" : "";
    }

    public String getComment() {
        return this.comment;
    }

    public String getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public boolean getUseCompression() {
        return this.useCompression;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public Number getBatchSize() {
        return this.batchSize;
    }
}

