/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.nifi.minifi.bootstrap;

import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;

import java.io.IOException;

public class WindowsService {

    private static RunMiNiFi bootstrap;

    public static void start(String[] args) throws IOException {
        bootstrap = new RunMiNiFi(BootstrapFileProvider.getBootstrapConfFile());
        bootstrap.run(BootstrapCommand.START);
    }

    public static void stop(String[] args) {
        bootstrap.setAutoRestartNiFi(false);
        bootstrap.run(BootstrapCommand.STOP);
    }

}
