/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.SampleDescription;
import com.drew.metadata.mov.atoms.SampleDescriptionAtom;
import com.drew.metadata.mov.media.QuickTimeTimecodeDirectory;
import java.io.IOException;

public class TimecodeSampleDescriptionAtom
extends SampleDescriptionAtom<TimecodeSampleDescription> {
    public TimecodeSampleDescriptionAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
    }

    @Override
    @NotNull
    TimecodeSampleDescription getSampleDescription(SequentialReader reader) throws IOException {
        return new TimecodeSampleDescription(reader);
    }

    public void addMetadata(QuickTimeTimecodeDirectory directory) {
        if (this.sampleDescriptions.size() > 0) {
            TimecodeSampleDescription description = (TimecodeSampleDescription)this.sampleDescriptions.get(0);
            directory.setBoolean(1, (description.flags & 1) == 1);
            directory.setBoolean(2, (description.flags & 2) == 2);
            directory.setBoolean(3, (description.flags & 4) == 4);
            directory.setBoolean(4, (description.flags & 8) == 8);
        }
    }

    static class TimecodeSampleDescription
    extends SampleDescription {
        int flags;
        int timeScale;
        int frameDuration;
        int numberOfFrames;

        public TimecodeSampleDescription(SequentialReader reader) throws IOException {
            super(reader);
            reader.skip(4L);
            this.flags = reader.getInt32();
            this.timeScale = reader.getInt32();
            this.frameDuration = reader.getInt32();
            this.numberOfFrames = reader.getInt8();
            reader.skip(1L);
        }
    }
}

