/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.rest.action.RestBuilderListener;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetFieldMappingAction.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(logger.getName());
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in get field mapping requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/_mapping/{type}/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mapping/field/{fields}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/{type}/field/{fields}")));
    }

    @Override
    public String getName() {
        return "get_field_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        final String[] fields = Strings.splitStringByCommaToArray(request.param("fields"));
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (!includeTypeName && types.length > 0) {
            throw new IllegalArgumentException("Types cannot be specified unless include_type_name is set to true.");
        }
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecate("get_field_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(indices).types(types).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        if (request.hasParam("local")) {
            deprecationLogger.deprecate("get_field_mapping_local", "Use [local] in get field mapping requests is deprecated. The parameter will be removed in the next major version", new Object[0]);
        }
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getFieldMappings(getMappingsRequest, (ActionListener<GetFieldMappingsResponse>)new RestBuilderListener<GetFieldMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetFieldMappingsResponse response, XContentBuilder builder) throws Exception {
                boolean isPossibleSingleFieldRequest;
                Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>> mappingsByIndex = response.mappings();
                boolean bl = isPossibleSingleFieldRequest = indices.length == 1 && types.length == 1 && fields.length == 1;
                if (isPossibleSingleFieldRequest && RestGetFieldMappingAction.this.isFieldMappingMissingField(mappingsByIndex)) {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
                }
                RestStatus status = RestStatus.OK;
                if (mappingsByIndex.isEmpty() && fields.length > 0) {
                    status = RestStatus.NOT_FOUND;
                }
                response.toXContent(builder, request);
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private boolean isFieldMappingMissingField(Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>>> mappingsByIndex) {
        if (mappingsByIndex.size() != 1) {
            return false;
        }
        for (Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetadata>> value : mappingsByIndex.values()) {
            for (Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldValue : value.values()) {
                for (Map.Entry<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappingMetadataEntry : fieldValue.entrySet()) {
                    if (!fieldMappingMetadataEntry.getValue().isNull()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

