/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.metrics.AbstractInternalTDigestPercentiles;
import org.opensearch.search.aggregations.metrics.Percentile;
import org.opensearch.search.aggregations.metrics.Percentiles;
import org.opensearch.search.aggregations.metrics.TDigestState;

public class InternalTDigestPercentiles
extends AbstractInternalTDigestPercentiles
implements Percentiles {
    public static final String NAME = "tdigest_percentiles";

    public InternalTDigestPercentiles(String name, double[] percents, TDigestState state, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) {
        super(name, percents, state, keyed, formatter, metadata);
    }

    public InternalTDigestPercentiles(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percentile(double percent) {
        return this.state.quantile(percent / 100.0);
    }

    @Override
    public String percentileAsString(double percent) {
        return this.valueAsString(String.valueOf(percent));
    }

    @Override
    public double value(double key) {
        return this.percentile(key);
    }

    @Override
    protected AbstractInternalTDigestPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed, Map<String, Object> metadata) {
        return new InternalTDigestPercentiles(name, keys, merged, keyed, this.format, metadata);
    }

    public static class Iter
    implements Iterator<Percentile> {
        private final double[] percents;
        private final TDigestState state;
        private int i;

        public Iter(double[] percents, TDigestState state) {
            this.percents = percents;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.percents.length;
        }

        @Override
        public Percentile next() {
            Percentile next = new Percentile(this.percents[this.i], this.state.quantile(this.percents[this.i] / 100.0));
            ++this.i;
            return next;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

