/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongMax
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorLongMax.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected boolean isGroupResultNull;
    protected long max;

    public VectorPTFEvaluatorLongMax(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.max = longColVector.vector[0];
                    this.isGroupResultNull = false;
                } else {
                    long repeatedMax = longColVector.vector[0];
                    if (repeatedMax > this.max) {
                        this.max = repeatedMax;
                    }
                }
            }
        } else if (longColVector.noNulls) {
            long[] vector = longColVector.vector;
            long varMax = vector[0];
            for (int i = 1; i < size; ++i) {
                long l = vector[i];
                if (l <= varMax) continue;
                varMax = l;
            }
            if (this.isGroupResultNull) {
                this.max = varMax;
                this.isGroupResultNull = false;
            } else if (varMax > this.max) {
                this.max = varMax;
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            long[] vector = longColVector.vector;
            long varMax = vector[i++];
            while (i < size) {
                long l;
                if (!batchIsNull[i] && (l = vector[i]) > varMax) {
                    varMax = l;
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.max = varMax;
                this.isGroupResultNull = false;
            } else if (varMax > this.max) {
                this.max = varMax;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public long getLongGroupResult() {
        return this.max;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.max = Long.MIN_VALUE;
    }
}

