/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;

public class WindowingComponentizer {
    WindowingSpec originalSpec;
    LinkedHashMap<PTFInvocationSpec.PartitioningSpec, WindowingSpec> groups;

    public WindowingComponentizer(WindowingSpec originalSpec) throws SemanticException {
        this.originalSpec = originalSpec;
        this.groups = new LinkedHashMap();
        this.groupFunctions();
    }

    private void groupFunctions() throws SemanticException {
        for (WindowingSpec.WindowExpressionSpec expr : this.originalSpec.getWindowExpressions()) {
            WindowingSpec.WindowFunctionSpec wFn = (WindowingSpec.WindowFunctionSpec)expr;
            PTFInvocationSpec.PartitioningSpec wFnGrp = wFn.getWindowSpec().getPartitioning();
            WindowingSpec wSpec = this.groups.get(wFnGrp);
            if (wSpec == null) {
                wSpec = new WindowingSpec();
                this.groups.put(wFnGrp, wSpec);
            }
            wSpec.addWindowFunction(wFn);
        }
    }

    public boolean hasNext() {
        return !this.groups.isEmpty();
    }

    public WindowingSpec next(HiveConf hCfg, SemanticAnalyzer semAly, UnparseTranslator unparseT, RowResolver inputRR) throws SemanticException {
        Throwable originalException = null;
        for (Map.Entry<PTFInvocationSpec.PartitioningSpec, WindowingSpec> entry : this.groups.entrySet()) {
            WindowingSpec wSpec = entry.getValue();
            try {
                PTFTranslator t = new PTFTranslator();
                t.translate(wSpec, semAly, hCfg, inputRR, unparseT);
                this.groups.remove(entry.getKey());
                return wSpec;
            }
            catch (SemanticException se) {
                originalException = se;
            }
        }
        throw new SemanticException("Failed to breakup Windowing invocations into Groups. At least 1 group must only depend on input columns. Also check for circular dependencies.\nUnderlying error: " + originalException.getMessage());
    }
}

