/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPosition;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class GeoPolygon
extends GeoObject {
    private final List<GeoLinearRing> rings;

    public GeoPolygon(GeoLinearRing ring) {
        this(ring, null, null);
    }

    public GeoPolygon(GeoLinearRing ring, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        this(Collections.singletonList(Objects.requireNonNull(ring, "'ring' cannot be null.")), boundingBox, customProperties);
    }

    public GeoPolygon(List<GeoLinearRing> rings) {
        this(rings, null, null);
    }

    public GeoPolygon(List<GeoLinearRing> rings, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        Objects.requireNonNull(rings, "'rings' cannot be null.");
        this.rings = Collections.unmodifiableList(new ArrayList<GeoLinearRing>(rings));
    }

    public List<GeoLinearRing> getRings() {
        return this.rings;
    }

    public GeoLinearRing getOuterRing() {
        return this.rings.get(0);
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.rings, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPolygon)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPolygon other = (GeoPolygon)obj;
        return super.equals(obj) && Objects.equals(this.rings, other.rings);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.POLYGON.toString()).writeArrayField("coordinates", this.getRings(), JsonWriter::writeJson).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoPolygon fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            List<GeoLinearRing> rings = null;
            GeoBoundingBox boundingBox = null;
            LinkedHashMap<String, Object> customProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    String type = reader.getString();
                    if (GeoObjectType.POLYGON.toString().equals(type)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'Polygon'. The found 'type' was '" + type + "'.");
                }
                if ("coordinates".equals(fieldName)) {
                    rings = reader.readArray(GeoLinearRing::fromJson);
                    continue;
                }
                if ("bbox".equals(fieldName)) {
                    boundingBox = GeoBoundingBox.fromJson(reader);
                    continue;
                }
                if (customProperties == null) {
                    customProperties = new LinkedHashMap<String, Object>();
                }
                customProperties.put(fieldName, reader.readUntyped());
            }
            return new GeoPolygon(rings, boundingBox, customProperties);
        });
    }
}

