/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.BlobHierarchyListSegment;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.PageRange;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class PageListSegment
implements XmlSerializable<BlobHierarchyListSegment> {
    private List<PageRange> pageRanges = new ArrayList<PageRange>();
    private List<ClearRange> clearRanges = new ArrayList<ClearRange>();
    private String nextMarker;

    public List<PageRange> getPageRanges() {
        return this.pageRanges;
    }

    public PageListSegment setPageRanges(List<PageRange> pageRanges) {
        this.pageRanges = pageRanges;
        return this;
    }

    public List<ClearRange> getClearRanges() {
        return this.clearRanges;
    }

    public PageListSegment setClearRanges(List<ClearRange> clearRanges) {
        this.clearRanges = clearRanges;
        return this;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public PageListSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageListSegment" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.pageRanges != null) {
            for (PageRange pageRange : this.pageRanges) {
                xmlWriter.writeXml(pageRange, "PageRange");
            }
        }
        if (this.clearRanges != null) {
            for (ClearRange clearRange : this.clearRanges) {
                xmlWriter.writeXml(clearRange, "ClearRange");
            }
        }
        xmlWriter.writeStringElement(this.nextMarker, "NextMarker");
        return xmlWriter.writeEndElement();
    }

    public static PageListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return PageListSegment.fromXml(xmlReader, null);
    }

    public static PageListSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageListSegment" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageListSegment deserializedPageListSegment = new PageListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("PageRange".equals(elementName.getLocalPart())) {
                    if (deserializedPageListSegment.pageRanges == null) {
                        deserializedPageListSegment.pageRanges = new ArrayList<PageRange>();
                    }
                    deserializedPageListSegment.pageRanges.add(PageRange.fromXml(reader, "PageRange"));
                    continue;
                }
                if ("ClearRange".equals(elementName.getLocalPart())) {
                    if (deserializedPageListSegment.clearRanges == null) {
                        deserializedPageListSegment.clearRanges = new ArrayList<ClearRange>();
                    }
                    deserializedPageListSegment.clearRanges.add(ClearRange.fromXml(reader, "ClearRange"));
                    continue;
                }
                if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedPageListSegment.nextMarker = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedPageListSegment;
        });
    }
}

