/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.minion.tasks.mergerollup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.I0Itec.zkclient.exception.ZkException;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.lineage.SegmentLineage;
import org.apache.pinot.common.lineage.SegmentLineageUtils;
import org.apache.pinot.common.metadata.segment.SegmentPartitionMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.minion.BaseTaskMetadata;
import org.apache.pinot.common.minion.MergeRollupTaskMetadata;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoAccessor;
import org.apache.pinot.controller.helix.core.minion.generator.BaseTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.apache.pinot.core.minion.PinotTaskConfig;
import org.apache.pinot.plugin.minion.tasks.MergeTaskUtils;
import org.apache.pinot.plugin.minion.tasks.MinionTaskUtils;
import org.apache.pinot.plugin.minion.tasks.mergerollup.MergeRollupTaskUtils;
import org.apache.pinot.plugin.minion.tasks.mergerollup.segmentgroupmananger.MergeRollupTaskSegmentGroupManagerProvider;
import org.apache.pinot.spi.annotations.minion.TaskGenerator;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TaskGenerator
public class MergeRollupTaskGenerator
extends BaseTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeRollupTaskGenerator.class);
    private static final int DEFAULT_MAX_NUM_RECORDS_PER_TASK = 50000000;
    private static final int DEFAULT_NUM_PARALLEL_BUCKETS = 1;
    private static final String REFRESH = "REFRESH";
    private static final String DELIMITER_IN_SEGMENT_NAME = "_";
    private static final String MERGE_ROLLUP_TASK_DELAY_IN_NUM_BUCKETS = "mergeRollupTaskDelayInNumBuckets";
    private static final String MERGE_ROLLUP_TASK_NUM_BUCKETS_TO_PROCESS = "mergeRollupTaskNumBucketsToProcess";
    private final Map<String, Map<String, Long>> _mergeRollupWatermarks = new HashMap<String, Map<String, Long>>();
    private final Map<String, Long> _tableLowestLevelMaxValidBucketEndTimeMs = new HashMap<String, Long>();
    private final Map<String, Map<String, Long>> _tableNumberBucketsToProcess = new HashMap<String, Map<String, Long>>();

    public String getTaskType() {
        return "MergeRollupTask";
    }

    public List<PinotTaskConfig> generateTasks(List<TableConfig> tableConfigs) {
        String taskType = "MergeRollupTask";
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            if (!MergeRollupTaskGenerator.validate(tableConfig, taskType)) continue;
            String tableNameWithType = tableConfig.getTableName();
            LOGGER.info("Start generating task configs for table: {} for task: {}", (Object)tableNameWithType, (Object)taskType);
            List<SegmentZKMetadata> allSegments = tableConfig.getTableType() == TableType.OFFLINE ? this.getSegmentsZKMetadataForTable(tableNameWithType) : MergeRollupTaskGenerator.filterSegmentsforRealtimeTable(this.getNonConsumingSegmentsZKMetadataForRealtimeTable(tableNameWithType));
            SegmentLineage segmentLineage = this._clusterInfoAccessor.getSegmentLineage(tableNameWithType);
            HashSet<String> preSelectedSegmentsBasedOnLineage = new HashSet<String>();
            for (SegmentZKMetadata segmentZKMetadata : allSegments) {
                preSelectedSegmentsBasedOnLineage.add(segmentZKMetadata.getSegmentName());
            }
            SegmentLineageUtils.filterSegmentsBasedOnLineageInPlace(preSelectedSegmentsBasedOnLineage, (SegmentLineage)segmentLineage);
            ArrayList<SegmentZKMetadata> preSelectedSegments = new ArrayList<SegmentZKMetadata>();
            for (SegmentZKMetadata segment3 : allSegments) {
                if (!preSelectedSegmentsBasedOnLineage.contains(segment3.getSegmentName()) || segment3.getTotalDocs() <= 0L || !MergeTaskUtils.allowMerge(segment3)) continue;
                preSelectedSegments.add(segment3);
            }
            if (preSelectedSegments.isEmpty()) {
                this.resetDelayMetrics(tableNameWithType);
                LOGGER.info("Skip generating task: {} for table: {}, no segment is found.", (Object)taskType, (Object)tableNameWithType);
                continue;
            }
            preSelectedSegments.sort((a, b) -> {
                long bEndTime;
                long bStartTime;
                long aStartTime = a.getStartTimeMs();
                if (aStartTime != (bStartTime = b.getStartTimeMs())) {
                    return Long.compare(aStartTime, bStartTime);
                }
                long aEndTime = a.getEndTimeMs();
                return aEndTime != (bEndTime = b.getEndTimeMs()) ? Long.compare(aEndTime, bEndTime) : a.getSegmentName().compareTo(b.getSegmentName());
            });
            Map map = tableConfig.getTaskConfig().getConfigsForTaskType(taskType);
            Map<String, Map<String, String>> mergeLevelToConfigs = MergeRollupTaskUtils.getLevelToConfigMap(map);
            ArrayList<Map.Entry<String, Map<String, String>>> sortedMergeLevelConfigs = new ArrayList<Map.Entry<String, Map<String, String>>>(mergeLevelToConfigs.entrySet());
            sortedMergeLevelConfigs.sort(Comparator.comparingLong(e -> TimeUtils.convertPeriodToMillis((String)((String)((Map)e.getValue()).get("bucketTimePeriod")))));
            HashSet<String> inCompleteMergeLevels = new HashSet<String>();
            for (Map.Entry entry : TaskGeneratorUtils.getIncompleteTasks((String)taskType, (String)tableNameWithType, (ClusterInfoAccessor)this._clusterInfoAccessor).entrySet()) {
                for (PinotTaskConfig taskConfig : this._clusterInfoAccessor.getTaskConfigs((String)entry.getKey())) {
                    inCompleteMergeLevels.add((String)taskConfig.getConfigs().get("mergeLevel"));
                }
            }
            boolean processAll = "processAll".equalsIgnoreCase((String)map.get("mode"));
            ZNRecord mergeRollupTaskZNRecord = this._clusterInfoAccessor.getMinionTaskMetadataZNRecord("MergeRollupTask", tableNameWithType);
            int expectedVersion = mergeRollupTaskZNRecord != null ? mergeRollupTaskZNRecord.getVersion() : -1;
            MergeRollupTaskMetadata mergeRollupTaskMetadata = mergeRollupTaskZNRecord != null ? MergeRollupTaskMetadata.fromZNRecord((ZNRecord)mergeRollupTaskZNRecord) : new MergeRollupTaskMetadata(tableNameWithType, new TreeMap());
            ArrayList<PinotTaskConfig> pinotTaskConfigsForTable = new ArrayList<PinotTaskConfig>();
            String mergeLevel = null;
            for (Map.Entry entry : sortedMergeLevelConfigs) {
                int maxNumParallelBuckets;
                String lowerMergeLevel = mergeLevel;
                mergeLevel = (String)entry.getKey();
                Map mergeConfigs = (Map)entry.getValue();
                if (inCompleteMergeLevels.contains(mergeLevel)) {
                    LOGGER.info("Found incomplete task of merge level: {} for the same table: {}, Skipping task generation: {}", new Object[]{mergeLevel, tableNameWithType, taskType});
                    continue;
                }
                String bucketPeriod = (String)mergeConfigs.get("bucketTimePeriod");
                long bucketMs = TimeUtils.convertPeriodToMillis((String)bucketPeriod);
                if (bucketMs <= 0L) {
                    LOGGER.error("Bucket time period: {} (table : {}, mergeLevel : {}) must be larger than 0", new Object[]{bucketPeriod, tableNameWithType, mergeLevel});
                    continue;
                }
                String bufferPeriod = (String)mergeConfigs.get("bufferTimePeriod");
                long bufferMs = TimeUtils.convertPeriodToMillis((String)bufferPeriod);
                if (bufferMs < 0L) {
                    LOGGER.error("Buffer time period: {} (table : {}, mergeLevel : {}) must be larger or equal to 0", new Object[]{bufferPeriod, tableNameWithType, mergeLevel});
                    continue;
                }
                String maxNumParallelBucketsStr = (String)mergeConfigs.get("maxNumParallelBuckets");
                int n = maxNumParallelBuckets = maxNumParallelBucketsStr != null ? Integer.parseInt(maxNumParallelBucketsStr) : 1;
                if (maxNumParallelBuckets <= 0) {
                    LOGGER.error("Maximum number of parallel buckets: {} (table : {}, mergeLevel : {}) must be larger than 0", new Object[]{maxNumParallelBuckets, tableNameWithType, mergeLevel});
                    continue;
                }
                long preSelectedSegStartTimeMs = ((SegmentZKMetadata)preSelectedSegments.get(0)).getStartTimeMs();
                long bucketStartMs = preSelectedSegStartTimeMs / bucketMs * bucketMs;
                long watermarkMs = 0L;
                if (!processAll) {
                    bucketStartMs = watermarkMs = this.getWatermarkMs(preSelectedSegStartTimeMs, bucketMs, mergeLevel, mergeRollupTaskMetadata);
                }
                long bucketEndMs = bucketStartMs + bucketMs;
                if (lowerMergeLevel == null) {
                    long lowestLevelMaxValidBucketEndTimeMs = Long.MIN_VALUE;
                    for (SegmentZKMetadata preSelectedSegment : preSelectedSegments) {
                        long currentValidBucketEndTimeMs = this.getValidBucketEndTimeMsForSegment(preSelectedSegment, bucketMs, bufferMs);
                        lowestLevelMaxValidBucketEndTimeMs = Math.max(lowestLevelMaxValidBucketEndTimeMs, currentValidBucketEndTimeMs);
                    }
                    this._tableLowestLevelMaxValidBucketEndTimeMs.put(tableNameWithType, lowestLevelMaxValidBucketEndTimeMs);
                }
                List<String> sortedMergeLevels = sortedMergeLevelConfigs.stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
                if (processAll) {
                    this.createOrUpdateNumBucketsToProcessMetrics(tableNameWithType, mergeLevel, lowerMergeLevel, bufferMs, bucketMs, preSelectedSegments, sortedMergeLevels);
                } else {
                    this.createOrUpdateDelayMetrics(tableNameWithType, mergeLevel, null, watermarkMs, bufferMs, bucketMs);
                }
                if (!this.isValidBucketEndTime(bucketEndMs, bufferMs, lowerMergeLevel, mergeRollupTaskMetadata, processAll)) {
                    LOGGER.info("Bucket with start: {} and end: {} (table : {}, mergeLevel : {}, mode : {}) cannot be merged yet", new Object[]{bucketStartMs, bucketEndMs, tableNameWithType, mergeLevel, processAll ? "processAll" : "processFromWatermark"});
                    continue;
                }
                ArrayList selectedSegmentsForAllBuckets = new ArrayList(maxNumParallelBuckets);
                ArrayList<SegmentZKMetadata> selectedSegmentsForBucket = new ArrayList<SegmentZKMetadata>();
                boolean hasUnmergedSegments = false;
                boolean hasSpilledOverData = false;
                boolean areAllSegmentsReadyToMerge = true;
                for (SegmentZKMetadata preSelectedSegment : preSelectedSegments) {
                    long startTimeMs = preSelectedSegment.getStartTimeMs();
                    if (startTimeMs < bucketEndMs) {
                        long endTimeMs = preSelectedSegment.getEndTimeMs();
                        if (endTimeMs < bucketStartMs) continue;
                        if (!this.isMergedSegment(preSelectedSegment, mergeLevel, sortedMergeLevels)) {
                            hasUnmergedSegments = true;
                        }
                        if (!this.isMergedSegment(preSelectedSegment, lowerMergeLevel, sortedMergeLevels)) {
                            areAllSegmentsReadyToMerge = false;
                        }
                        if (this.hasSpilledOverData(preSelectedSegment, bucketMs)) {
                            hasSpilledOverData = true;
                        }
                        selectedSegmentsForBucket.add(preSelectedSegment);
                        continue;
                    }
                    if (hasUnmergedSegments && areAllSegmentsReadyToMerge) {
                        selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
                    }
                    if (selectedSegmentsForAllBuckets.size() == maxNumParallelBuckets || hasSpilledOverData) break;
                    selectedSegmentsForBucket = new ArrayList();
                    hasUnmergedSegments = false;
                    areAllSegmentsReadyToMerge = true;
                    bucketStartMs = startTimeMs / bucketMs * bucketMs;
                    bucketEndMs = bucketStartMs + bucketMs;
                    if (!this.isValidBucketEndTime(bucketEndMs, bufferMs, lowerMergeLevel, mergeRollupTaskMetadata, processAll)) break;
                    if (!this.isMergedSegment(preSelectedSegment, mergeLevel, sortedMergeLevels)) {
                        hasUnmergedSegments = true;
                    }
                    if (!this.isMergedSegment(preSelectedSegment, lowerMergeLevel, sortedMergeLevels)) {
                        areAllSegmentsReadyToMerge = false;
                    }
                    if (this.hasSpilledOverData(preSelectedSegment, bucketMs)) {
                        hasSpilledOverData = true;
                    }
                    selectedSegmentsForBucket.add(preSelectedSegment);
                }
                if (hasUnmergedSegments && areAllSegmentsReadyToMerge && (selectedSegmentsForAllBuckets.isEmpty() || selectedSegmentsForAllBuckets.get(selectedSegmentsForAllBuckets.size() - 1) != selectedSegmentsForBucket)) {
                    selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
                }
                if (selectedSegmentsForAllBuckets.isEmpty()) {
                    LOGGER.info("No unmerged segment found for table: {}, mergeLevel: {}", (Object)tableNameWithType, (Object)mergeLevel);
                    continue;
                }
                long newWatermarkMs = ((SegmentZKMetadata)((List)selectedSegmentsForAllBuckets.get(0)).get(0)).getStartTimeMs() / bucketMs * bucketMs;
                mergeRollupTaskMetadata.getWatermarkMap().put(mergeLevel, newWatermarkMs);
                LOGGER.info("Update watermark for table: {}, mergeLevel: {} from: {} to: {}", new Object[]{tableNameWithType, mergeLevel, watermarkMs, newWatermarkMs});
                if (!processAll) {
                    this.createOrUpdateDelayMetrics(tableNameWithType, mergeLevel, lowerMergeLevel, newWatermarkMs, bufferMs, bucketMs);
                }
                int maxNumRecordsPerTask = mergeConfigs.get("maxNumRecordsPerTask") != null ? Integer.parseInt((String)mergeConfigs.get("maxNumRecordsPerTask")) : 50000000;
                SegmentPartitionConfig segmentPartitionConfig = tableConfig.getIndexingConfig().getSegmentPartitionConfig();
                if (segmentPartitionConfig == null) {
                    for (List list : selectedSegmentsForAllBuckets) {
                        pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(list, tableConfig, maxNumRecordsPerTask, mergeLevel, null, mergeConfigs, map));
                    }
                    continue;
                }
                Map columnPartitionMap = segmentPartitionConfig.getColumnPartitionMap();
                ArrayList arrayList = new ArrayList(columnPartitionMap.keySet());
                for (List list : selectedSegmentsForAllBuckets) {
                    HashMap<List, List> partitionToSegments = new HashMap<List, List>();
                    ArrayList<SegmentZKMetadata> outlierSegments = new ArrayList<SegmentZKMetadata>();
                    for (SegmentZKMetadata segmentZKMetadata : list) {
                        SegmentPartitionMetadata segmentPartitionMetadata = segmentZKMetadata.getPartitionMetadata();
                        ArrayList<Integer> partitions = new ArrayList<Integer>();
                        if (segmentPartitionMetadata != null && columnPartitionMap.keySet().equals(segmentPartitionMetadata.getColumnPartitionMap().keySet())) {
                            for (String partitionColumn : arrayList) {
                                if (segmentPartitionMetadata.getPartitions(partitionColumn).size() == 1) {
                                    partitions.add((Integer)segmentPartitionMetadata.getPartitions(partitionColumn).iterator().next());
                                    continue;
                                }
                                partitions.clear();
                                break;
                            }
                        }
                        if (partitions.isEmpty()) {
                            outlierSegments.add(segmentZKMetadata);
                            continue;
                        }
                        partitionToSegments.computeIfAbsent(partitions, k -> new ArrayList()).add(segmentZKMetadata);
                    }
                    for (Map.Entry entry2 : partitionToSegments.entrySet()) {
                        List partition = (List)entry2.getKey();
                        List partitionedSegments = (List)entry2.getValue();
                        pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(partitionedSegments, tableConfig, maxNumRecordsPerTask, mergeLevel, partition, mergeConfigs, map));
                    }
                    if (outlierSegments.isEmpty()) continue;
                    pinotTaskConfigsForTable.addAll(this.createPinotTaskConfigs(outlierSegments, tableConfig, maxNumRecordsPerTask, mergeLevel, null, mergeConfigs, map));
                }
            }
            if (!processAll) {
                try {
                    this._clusterInfoAccessor.setMinionTaskMetadata((BaseTaskMetadata)mergeRollupTaskMetadata, "MergeRollupTask", expectedVersion);
                }
                catch (ZkException e2) {
                    LOGGER.error("Version changed while updating merge/rollup task metadata for table: {}, skip scheduling. There are multiple task schedulers for the same table, need to investigate!", (Object)tableNameWithType);
                    continue;
                }
            }
            pinotTaskConfigs.addAll(pinotTaskConfigsForTable);
            LOGGER.info("Finished generating task configs for table: {} for task: {}, numTasks: {}", new Object[]{tableNameWithType, taskType, pinotTaskConfigsForTable.size()});
        }
        this.cleanUpDelayMetrics(tableConfigs);
        return pinotTaskConfigs;
    }

    public void validateTaskConfigs(TableConfig tableConfig, Schema schema, Map<String, String> taskConfigs) {
        NavigableSet columnNames = schema.getColumnNames();
        Set<String> dimensionsToErase = MergeRollupTaskUtils.getDimensionsToErase(taskConfigs);
        for (String dimension : dimensionsToErase) {
            Preconditions.checkState((boolean)columnNames.contains(dimension), (Object)("Column dimension to erase \"" + dimension + "\" not found in schema!"));
        }
        ImmutableSet allowedFunctionParameterNames = ImmutableSet.of((Object)"lgK".toLowerCase(), (Object)"samplingProbability".toLowerCase(), (Object)"nominalEntries".toLowerCase());
        Map<String, Map<String, String>> aggregationFunctionParameters = MergeRollupTaskUtils.getAggregationFunctionParameters(taskConfigs);
        for (String fieldName : aggregationFunctionParameters.keySet()) {
            Preconditions.checkState((boolean)columnNames.contains(fieldName), (Object)("Metric column \"" + fieldName + "\" for aggregation function parameter not found in schema!"));
            Map<String, String> functionParameters = aggregationFunctionParameters.get(fieldName);
            for (String functionParameterName : functionParameters.keySet()) {
                String err;
                String value;
                Preconditions.checkState((boolean)allowedFunctionParameterNames.contains(functionParameterName.toLowerCase()), (Object)"Aggregation function parameter name must be one of [lgK, samplingProbability, nominalEntries]!");
                if (functionParameterName.equalsIgnoreCase("lgK") || functionParameterName.equalsIgnoreCase("nominalEntries")) {
                    value = functionParameters.get(functionParameterName);
                    err = "Aggregation function parameter \"" + functionParameterName + "\" on column \"" + fieldName + "\" has invalid value: " + value;
                    try {
                        Preconditions.checkState((Integer.parseInt(value) > 0 ? 1 : 0) != 0, (Object)err);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException(err);
                    }
                }
                if (!functionParameterName.equalsIgnoreCase("samplingProbability")) continue;
                value = functionParameters.get(functionParameterName);
                err = "Aggregation function parameter \"" + functionParameterName + "\" on column \"" + fieldName + "\" has invalid value: " + value;
                try {
                    float p = Float.parseFloat(value);
                    Preconditions.checkState((p >= 0.0f && p <= 1.0f ? 1 : 0) != 0, (Object)err);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException(err);
                }
            }
        }
    }

    @VisibleForTesting
    static List<SegmentZKMetadata> filterSegmentsforRealtimeTable(List<SegmentZKMetadata> allSegments) {
        HashMap<Integer, LLCSegmentName> partitionIdToLatestCompletedSegment = new HashMap<Integer, LLCSegmentName>();
        for (SegmentZKMetadata segmentZKMetadata : allSegments) {
            String segmentName = segmentZKMetadata.getSegmentName();
            if (!LLCSegmentName.isLLCSegment((String)segmentName)) continue;
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            partitionIdToLatestCompletedSegment.compute(llcSegmentName.getPartitionGroupId(), (partId, latestSegment) -> {
                if (latestSegment == null) {
                    return llcSegmentName;
                }
                return latestSegment.getSequenceNumber() > llcSegmentName.getSequenceNumber() ? latestSegment : llcSegmentName;
            });
        }
        HashSet<String> filteredSegmentNames = new HashSet<String>();
        for (LLCSegmentName llcSegmentName : partitionIdToLatestCompletedSegment.values()) {
            filteredSegmentNames.add(llcSegmentName.getSegmentName());
        }
        return allSegments.stream().filter(a -> !filteredSegmentNames.contains(a.getSegmentName())).collect(Collectors.toList());
    }

    @VisibleForTesting
    static boolean validate(TableConfig tableConfig, String taskType) {
        String tableNameWithType = tableConfig.getTableName();
        if (REFRESH.equalsIgnoreCase(IngestionConfigUtils.getBatchSegmentIngestionType((TableConfig)tableConfig))) {
            LOGGER.warn("Skip generating task: {} for non-APPEND table: {}, REFRESH table is not supported", (Object)taskType, (Object)tableNameWithType);
            return false;
        }
        if (tableConfig.getTableType() == TableType.REALTIME) {
            if (tableConfig.isUpsertEnabled()) {
                LOGGER.warn("Skip generating task: {} for table: {}, table with upsert enabled is not supported", (Object)taskType, (Object)tableNameWithType);
                return false;
            }
            if (tableConfig.isDedupEnabled()) {
                LOGGER.warn("Skip generating task: {} for table: {}, table with dedup enabled is not supported", (Object)taskType, (Object)tableNameWithType);
                return false;
            }
        }
        return true;
    }

    private long getValidBucketEndTimeMsForSegment(SegmentZKMetadata segmentZKMetadata, long bucketMs, long bufferMs) {
        long currentTimeMs = System.currentTimeMillis();
        long firstBucketEndTimeMs = segmentZKMetadata.getStartTimeMs() / bucketMs * bucketMs + bucketMs;
        if (firstBucketEndTimeMs > currentTimeMs - bufferMs) {
            return Long.MIN_VALUE;
        }
        long validBucketEndTimeMs = (segmentZKMetadata.getEndTimeMs() / bucketMs + 1L) * bucketMs;
        validBucketEndTimeMs = Math.min(validBucketEndTimeMs, (currentTimeMs - bufferMs) / bucketMs * bucketMs);
        return validBucketEndTimeMs;
    }

    private boolean hasSpilledOverData(SegmentZKMetadata segmentZKMetadata, long bucketMs) {
        return segmentZKMetadata.getStartTimeMs() / bucketMs < segmentZKMetadata.getEndTimeMs() / bucketMs;
    }

    private boolean isMergedSegment(SegmentZKMetadata segmentZKMetadata, String baseMergeLevel, List<String> sortedMergeLevels) {
        Map customMap = segmentZKMetadata.getCustomMap();
        if (baseMergeLevel == null) {
            return true;
        }
        if (customMap == null || customMap.get("MergeRollupTask.mergeLevel") == null) {
            return false;
        }
        String mergeLevel = (String)customMap.get("MergeRollupTask.mergeLevel");
        boolean isCurLevelLowerThanBase = true;
        for (String currentMergeLevel : sortedMergeLevels) {
            if (currentMergeLevel.equalsIgnoreCase(baseMergeLevel)) {
                isCurLevelLowerThanBase = false;
            }
            if (isCurLevelLowerThanBase || !currentMergeLevel.equalsIgnoreCase(mergeLevel)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidBucketEndTime(long bucketEndMs, long bufferMs, @Nullable String lowerMergeLevel, MergeRollupTaskMetadata mergeRollupTaskMetadata, boolean processAll) {
        if (bucketEndMs > System.currentTimeMillis() - bufferMs) {
            return false;
        }
        if (lowerMergeLevel != null && !processAll) {
            Long lowerMergeLevelWatermarkMs = (Long)mergeRollupTaskMetadata.getWatermarkMap().get(lowerMergeLevel);
            return lowerMergeLevelWatermarkMs != null && bucketEndMs <= lowerMergeLevelWatermarkMs;
        }
        return true;
    }

    private long getWatermarkMs(long minStartTimeMs, long bucketMs, String mergeLevel, MergeRollupTaskMetadata mergeRollupTaskMetadata) {
        long watermarkMs = mergeRollupTaskMetadata.getWatermarkMap().get(mergeLevel) == null ? minStartTimeMs / bucketMs * bucketMs : (Long)mergeRollupTaskMetadata.getWatermarkMap().get(mergeLevel);
        return watermarkMs;
    }

    private List<PinotTaskConfig> createPinotTaskConfigs(List<SegmentZKMetadata> selectedSegments, TableConfig tableConfig, int maxNumRecordsPerTask, String mergeLevel, List<Integer> partition, Map<String, String> mergeConfigs, Map<String, String> taskConfigs) {
        String tableNameWithType = tableConfig.getTableName();
        List<List<SegmentZKMetadata>> segmentGroups = MergeRollupTaskSegmentGroupManagerProvider.create(taskConfigs).getSegmentGroups(tableConfig, this._clusterInfoAccessor, selectedSegments);
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        for (List<SegmentZKMetadata> segments : segmentGroups) {
            Object targetSegment;
            int numRecordsPerTask = 0;
            ArrayList segmentNamesList = new ArrayList();
            ArrayList downloadURLsList = new ArrayList();
            ArrayList<String> segmentNames = new ArrayList<String>();
            ArrayList<String> downloadURLs = new ArrayList<String>();
            for (int i = 0; i < segments.size(); ++i) {
                targetSegment = segments.get(i);
                segmentNames.add(targetSegment.getSegmentName());
                downloadURLs.add(targetSegment.getDownloadUrl());
                numRecordsPerTask = (int)((long)numRecordsPerTask + targetSegment.getTotalDocs());
                if (numRecordsPerTask < maxNumRecordsPerTask && i != segments.size() - 1) continue;
                segmentNamesList.add(segmentNames);
                downloadURLsList.add(downloadURLs);
                numRecordsPerTask = 0;
                segmentNames = new ArrayList();
                downloadURLs = new ArrayList();
            }
            StringBuilder partitionSuffixBuilder = new StringBuilder();
            if (partition != null && !partition.isEmpty()) {
                targetSegment = partition.iterator();
                while (targetSegment.hasNext()) {
                    int columnPartition = (Integer)targetSegment.next();
                    partitionSuffixBuilder.append(DELIMITER_IN_SEGMENT_NAME).append(columnPartition);
                }
            }
            String partitionSuffix = partitionSuffixBuilder.toString();
            for (int i = 0; i < segmentNamesList.size(); ++i) {
                String downloadURL = StringUtils.join((Iterable)((Iterable)downloadURLsList.get(i)), (String)",");
                Map<String, String> configs = MinionTaskUtils.getPushTaskConfig(tableNameWithType, taskConfigs, this._clusterInfoAccessor);
                configs.putAll(this.getBaseTaskConfigs(tableConfig, (List)segmentNamesList.get(i)));
                configs.put("downloadURL", downloadURL);
                configs.put("uploadURL", this._clusterInfoAccessor.getVipUrl() + "/segments");
                configs.put("enableReplaceSegments", "true");
                for (Map.Entry<String, String> taskConfig : taskConfigs.entrySet()) {
                    if (!taskConfig.getKey().endsWith(".aggregationType")) continue;
                    configs.put(taskConfig.getKey(), taskConfig.getValue());
                }
                configs.put("overwriteOutput", taskConfigs.getOrDefault("overwriteOutput", "false"));
                configs.put("mergeType", mergeConfigs.get("mergeType"));
                configs.put("mergeLevel", mergeLevel);
                configs.put("partitionBucketTimePeriod", mergeConfigs.get("bucketTimePeriod"));
                configs.put("roundBucketTimePeriod", mergeConfigs.get("roundBucketTimePeriod"));
                configs.put("maxNumRecordsPerSegment", mergeConfigs.get("maxNumRecordsPerSegment"));
                configs.put("segmentNamePrefix", "merged_" + mergeLevel + DELIMITER_IN_SEGMENT_NAME + System.currentTimeMillis() + partitionSuffix + DELIMITER_IN_SEGMENT_NAME + i + DELIMITER_IN_SEGMENT_NAME + TableNameBuilder.extractRawTableName((String)tableNameWithType));
                pinotTaskConfigs.add(new PinotTaskConfig("MergeRollupTask", configs));
            }
        }
        return pinotTaskConfigs;
    }

    private long getMergeRollupTaskDelayInNumTimeBuckets(long watermarkMs, long maxEndTimeMsOfCurrentLevel, long bufferTimeMs, long bucketTimeMs) {
        if (watermarkMs == -1L || maxEndTimeMsOfCurrentLevel == Long.MIN_VALUE) {
            return 0L;
        }
        return (Math.min(System.currentTimeMillis() - bufferTimeMs, maxEndTimeMsOfCurrentLevel) - watermarkMs) / bucketTimeMs;
    }

    private void createOrUpdateDelayMetrics(String tableNameWithType, String mergeLevel, String lowerMergeLevel, long watermarkMs, long bufferTimeMs, long bucketTimeMs) {
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map watermarkForTable = this._mergeRollupWatermarks.computeIfAbsent(tableNameWithType, k -> new ConcurrentHashMap());
        watermarkForTable.compute(mergeLevel, (k, v) -> {
            if (v == null) {
                LOGGER.info("Creating the gauge metric for tracking the merge/roll-up task delay for table: {} and mergeLevel: {}.(watermarkMs={}, bufferTimeMs={}, bucketTimeMs={}, taskDelayInNumTimeBuckets={})", new Object[]{tableNameWithType, mergeLevel, watermarkMs, bufferTimeMs, bucketTimeMs, this.getMergeRollupTaskDelayInNumTimeBuckets(watermarkMs, lowerMergeLevel == null ? this._tableLowestLevelMaxValidBucketEndTimeMs.get(tableNameWithType) : (Long)watermarkForTable.get(lowerMergeLevel), bufferTimeMs, bucketTimeMs)});
                controllerMetrics.addCallbackGaugeIfNeeded(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel), () -> this.getMergeRollupTaskDelayInNumTimeBuckets(watermarkForTable.getOrDefault(k, -1L), lowerMergeLevel == null ? this._tableLowestLevelMaxValidBucketEndTimeMs.get(tableNameWithType) : (Long)watermarkForTable.get(lowerMergeLevel), bufferTimeMs, bucketTimeMs));
            }
            return watermarkMs;
        });
    }

    private void createOrUpdateNumBucketsToProcessMetrics(String tableNameWithType, String mergeLevel, String lowerMergeLevel, long bufferTimeMs, long bucketTimeMs, List<SegmentZKMetadata> sortedSegments, List<String> sortedMergeLevels) {
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        ArrayList selectedSegmentsForAllBuckets = new ArrayList();
        ArrayList<SegmentZKMetadata> selectedSegmentsForBucket = new ArrayList<SegmentZKMetadata>();
        long bucketStartMs = sortedSegments.get(0).getStartTimeMs() / bucketTimeMs * bucketTimeMs;
        long bucketEndMs = bucketStartMs + bucketTimeMs;
        boolean hasUnmergedSegments = false;
        boolean isAllSegmentsReadyToMerge = true;
        for (SegmentZKMetadata segment : sortedSegments) {
            long startTimeMs = segment.getStartTimeMs();
            if (startTimeMs < bucketEndMs) {
                long endTimeMs = segment.getEndTimeMs();
                if (endTimeMs < bucketStartMs) continue;
                if (!this.isMergedSegment(segment, mergeLevel, sortedMergeLevels)) {
                    hasUnmergedSegments = true;
                }
                if (!this.isMergedSegment(segment, lowerMergeLevel, sortedMergeLevels)) {
                    isAllSegmentsReadyToMerge = false;
                }
                selectedSegmentsForBucket.add(segment);
                continue;
            }
            if (hasUnmergedSegments && isAllSegmentsReadyToMerge) {
                selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
            }
            selectedSegmentsForBucket = new ArrayList();
            hasUnmergedSegments = false;
            isAllSegmentsReadyToMerge = true;
            bucketStartMs = startTimeMs / bucketTimeMs * bucketTimeMs;
            bucketEndMs = bucketStartMs + bucketTimeMs;
            if (bucketEndMs > System.currentTimeMillis() - bufferTimeMs) break;
            if (!this.isMergedSegment(segment, mergeLevel, sortedMergeLevels)) {
                hasUnmergedSegments = true;
            }
            if (!this.isMergedSegment(segment, lowerMergeLevel, sortedMergeLevels)) {
                isAllSegmentsReadyToMerge = false;
            }
            selectedSegmentsForBucket.add(segment);
        }
        if (hasUnmergedSegments && isAllSegmentsReadyToMerge && (selectedSegmentsForAllBuckets.isEmpty() || selectedSegmentsForAllBuckets.get(selectedSegmentsForAllBuckets.size() - 1) != selectedSegmentsForBucket)) {
            selectedSegmentsForAllBuckets.add(selectedSegmentsForBucket);
        }
        Map numBucketsToProcessForTable = this._tableNumberBucketsToProcess.computeIfAbsent(tableNameWithType, k -> new ConcurrentHashMap());
        long finalCount = selectedSegmentsForAllBuckets.size();
        numBucketsToProcessForTable.compute(mergeLevel, (k, v) -> {
            if (v == null) {
                LOGGER.info("Creating the gauge metric for tracking the merge/roll-up number buckets to process for table: {} and mergeLevel: {}.(bufferTimeMs={}, bucketTimeMs={}, numTimeBucketsToProcess={})", new Object[]{tableNameWithType, mergeLevel, bufferTimeMs, bucketTimeMs, finalCount});
                controllerMetrics.setOrUpdateGauge(this.getMetricNameForNumBucketsToProcess(tableNameWithType, mergeLevel), () -> this._tableNumberBucketsToProcess.get(tableNameWithType).getOrDefault(mergeLevel, finalCount));
            }
            return finalCount;
        });
    }

    private void resetDelayMetrics(String tableNameWithType) {
        Map<String, Long> numBucketsToProcessForTable;
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map<String, Long> watermarksForTable = this._mergeRollupWatermarks.remove(tableNameWithType);
        if (watermarksForTable != null) {
            for (String mergeLevel : watermarksForTable.keySet()) {
                controllerMetrics.removeGauge(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel));
            }
        }
        if ((numBucketsToProcessForTable = this._tableNumberBucketsToProcess.remove(tableNameWithType)) != null) {
            for (String mergeLevel : numBucketsToProcessForTable.keySet()) {
                controllerMetrics.removeGauge(this.getMetricNameForNumBucketsToProcess(tableNameWithType, mergeLevel));
            }
        }
    }

    private void resetDelayMetrics(String tableNameWithType, String mergeLevel) {
        Map<String, Long> numBucketsToProcessForTable;
        ControllerMetrics controllerMetrics = this._clusterInfoAccessor.getControllerMetrics();
        if (controllerMetrics == null) {
            return;
        }
        Map<String, Long> watermarksForTable = this._mergeRollupWatermarks.get(tableNameWithType);
        if (watermarksForTable != null && watermarksForTable.remove(mergeLevel) != null) {
            controllerMetrics.removeGauge(this.getMetricNameForTaskDelay(tableNameWithType, mergeLevel));
        }
        if ((numBucketsToProcessForTable = this._tableNumberBucketsToProcess.remove(tableNameWithType)) != null && numBucketsToProcessForTable.remove(mergeLevel) != null) {
            controllerMetrics.removeGauge(this.getMetricNameForNumBucketsToProcess(tableNameWithType, mergeLevel));
        }
    }

    private void cleanUpDelayMetrics(List<TableConfig> tableConfigs) {
        HashMap<String, TableConfig> tableConfigMap = new HashMap<String, TableConfig>();
        for (TableConfig tableConfig : tableConfigs) {
            tableConfigMap.put(tableConfig.getTableName(), tableConfig);
        }
        HashSet<String> tables = new HashSet<String>(this._mergeRollupWatermarks.keySet());
        tables.addAll(this._tableNumberBucketsToProcess.keySet());
        for (String tableNameWithType : tables) {
            Map<String, Long> tableToNumBucketsToProcess;
            TableConfig currentTableConfig = (TableConfig)tableConfigMap.get(tableNameWithType);
            if (currentTableConfig == null) {
                this.resetDelayMetrics(tableNameWithType);
                continue;
            }
            if (!this._clusterInfoAccessor.getLeaderControllerManager().isLeaderForTable(tableNameWithType)) {
                this.resetDelayMetrics(tableNameWithType);
                continue;
            }
            Map taskConfigs = currentTableConfig.getTaskConfig().getConfigsForTaskType(this.getTaskType());
            Map<String, Map<String, String>> mergeLevelToConfigs = MergeRollupTaskUtils.getLevelToConfigMap(taskConfigs);
            Map<String, Long> tableToWatermark = this._mergeRollupWatermarks.get(tableNameWithType);
            if (tableToWatermark != null) {
                for (String mergeLevel : tableToWatermark.keySet()) {
                    if (mergeLevelToConfigs.containsKey(mergeLevel)) continue;
                    this.resetDelayMetrics(tableNameWithType, mergeLevel);
                }
            }
            if ((tableToNumBucketsToProcess = this._tableNumberBucketsToProcess.get(tableNameWithType)) == null) continue;
            for (String mergeLevel : tableToNumBucketsToProcess.keySet()) {
                if (mergeLevelToConfigs.containsKey(mergeLevel)) continue;
                this.resetDelayMetrics(tableNameWithType, mergeLevel);
            }
        }
    }

    private String getMetricNameForTaskDelay(String tableNameWithType, String mergeLevel) {
        return "mergeRollupTaskDelayInNumBuckets." + tableNameWithType + "." + mergeLevel;
    }

    private String getMetricNameForNumBucketsToProcess(String tableNameWithType, String mergeLevel) {
        return "mergeRollupTaskNumBucketsToProcess." + tableNameWithType + "." + mergeLevel;
    }
}

