/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import com.yscope.clp.compressorfrontend.EmptyArrayUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class FlattenedByteArray
implements Iterable<byte[]> {
    private final byte[] flattenedElems;
    private final int[] elemEndOffsets;

    public FlattenedByteArray(byte[] flattenedElems, int[] elemEndOffsets) {
        this.flattenedElems = null == flattenedElems ? EmptyArrayUtils.EMPTY_BYTE_ARRAY : flattenedElems;
        this.elemEndOffsets = null == elemEndOffsets ? EmptyArrayUtils.EMPTY_INT_ARRAY : elemEndOffsets;
    }

    public byte @NotNull [] getFlattenedElems() {
        return this.flattenedElems;
    }

    public int @NotNull [] getElemEndOffsets() {
        return this.elemEndOffsets;
    }

    public int size() {
        return this.elemEndOffsets.length;
    }

    @Override
    @NotNull
    public Iterator<byte[]> iterator() {
        return new ByteArrayIterator();
    }

    private class ByteArrayIterator
    implements Iterator<byte[]> {
        private int currentElemIdx = 0;

        private ByteArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentElemIdx < FlattenedByteArray.this.elemEndOffsets.length;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in the byte array.");
            }
            int beginOffset = 0 == this.currentElemIdx ? 0 : FlattenedByteArray.this.elemEndOffsets[this.currentElemIdx - 1];
            int endOffset = FlattenedByteArray.this.elemEndOffsets[this.currentElemIdx];
            ++this.currentElemIdx;
            return Arrays.copyOfRange(FlattenedByteArray.this.flattenedElems, beginOffset, endOffset);
        }
    }
}

