/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.formatter;

import io.confluent.kafka.formatter.SchemaMessageDeserializer;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;

public abstract class SchemaMessageFormatter<T>
implements MessageFormatter {
    private static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    private boolean printTimestamp = false;
    private boolean printKey = false;
    private boolean printPartition = false;
    private boolean printOffset = false;
    private boolean printHeaders = false;
    private boolean printIds = false;
    private boolean printKeyId = false;
    private boolean printValueId = false;
    private byte[] keySeparator = "\t".getBytes(StandardCharsets.UTF_8);
    private byte[] lineSeparator = "\n".getBytes(StandardCharsets.UTF_8);
    private byte[] headersSeparator = ",".getBytes(StandardCharsets.UTF_8);
    private byte[] idSeparator = "\t".getBytes(StandardCharsets.UTF_8);
    private byte[] nullLiteral = NULL_BYTES;
    private Deserializer<?> headersDeserializer;
    protected SchemaMessageDeserializer<T> deserializer;
    private static final int MAGIC_BYTE = 0;

    public SchemaMessageFormatter() {
    }

    public SchemaMessageFormatter(String url, Deserializer keyDeserializer) {
        this.deserializer = this.createDeserializer(keyDeserializer);
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("schema.registry.url", url);
        this.deserializer.configure(configs, false);
    }

    protected abstract SchemaMessageDeserializer<T> createDeserializer(Deserializer var1);

    @Override
    public void configure(Map<String, ?> configs) {
        Properties properties = new Properties();
        properties.putAll(configs);
        this.init(properties);
    }

    @Override
    public void init(Properties props) {
        if (props == null) {
            throw new ConfigException("Missing schema registry url!");
        }
        if (props.containsKey("print.timestamp")) {
            this.printTimestamp = props.getProperty("print.timestamp").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("print.key")) {
            this.printKey = props.getProperty("print.key").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("print.partition")) {
            this.printPartition = props.getProperty("print.partition").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("print.offset")) {
            this.printOffset = props.getProperty("print.offset").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("print.headers")) {
            this.printHeaders = props.getProperty("print.headers").trim().toLowerCase().equals("true");
        }
        if (props.containsKey("key.separator")) {
            this.keySeparator = props.getProperty("key.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("line.separator")) {
            this.lineSeparator = props.getProperty("line.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("headers.separator")) {
            this.headersSeparator = props.getProperty("headers.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (props.containsKey("null.literal")) {
            this.nullLiteral = props.getProperty("null.literal").getBytes(StandardCharsets.UTF_8);
        }
        Deserializer<?> keyDeserializer = null;
        if (props.containsKey("key.deserializer")) {
            keyDeserializer = this.getDeserializerProperty(true, props, "key.deserializer");
        }
        if (props.containsKey("headers.deserializer")) {
            this.headersDeserializer = this.getDeserializerProperty(false, props, "headers.deserializer");
        }
        if (props.containsKey("print.schema.ids")) {
            this.printIds = props.getProperty("print.schema.ids").trim().toLowerCase().equals("true");
            if (this.printIds) {
                this.printValueId = true;
                if (keyDeserializer == null || keyDeserializer instanceof AbstractKafkaSchemaSerDe) {
                    this.printKeyId = true;
                }
            }
        }
        if (props.containsKey("schema.id.separator")) {
            this.idSeparator = props.getProperty("schema.id.separator").getBytes(StandardCharsets.UTF_8);
        }
        if (this.deserializer == null) {
            Map<String, Object> originals = this.getPropertiesMap(props);
            this.deserializer = this.createDeserializer(keyDeserializer);
            this.deserializer.configure(originals, false);
        }
    }

    private Deserializer<?> getDeserializerProperty(boolean isKey, Properties props, String propertyName) {
        try {
            String serializerName = (String)props.get(propertyName);
            Deserializer deserializer = (Deserializer)Class.forName(serializerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, ?> deserializerConfig = this.propertiesWithKeyPrefixStripped(propertyName + ".", props);
            deserializer.configure(deserializerConfig, isKey);
            return deserializer;
        }
        catch (Exception e) {
            throw new ConfigException("Error initializing " + propertyName + ": " + e.getMessage());
        }
    }

    private Map<String, ?> propertiesWithKeyPrefixStripped(String prefix, Properties props) {
        return props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue));
    }

    private Map<String, Object> getPropertiesMap(Properties props) {
        HashMap<String, Object> originals = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            originals.put(name, props.getProperty(name));
        }
        return originals;
    }

    @Override
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTimestamp) {
            try {
                TimestampType timestampType = consumerRecord.timestampType();
                if (timestampType != TimestampType.NO_TIMESTAMP_TYPE) {
                    output.write(String.format("%s:%d", new Object[]{timestampType, consumerRecord.timestamp()}).getBytes(StandardCharsets.UTF_8));
                } else {
                    output.write("NO_TIMESTAMP".getBytes(StandardCharsets.UTF_8));
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the timestamp", ioe);
            }
        }
        if (this.printPartition) {
            try {
                output.write("Partition:".getBytes(StandardCharsets.UTF_8));
                output.write(String.valueOf(consumerRecord.partition()).getBytes(StandardCharsets.UTF_8));
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the partition", ioe);
            }
        }
        if (this.printOffset) {
            try {
                output.write("Offset:".getBytes(StandardCharsets.UTF_8));
                output.write(String.valueOf(consumerRecord.offset()).getBytes(StandardCharsets.UTF_8));
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the offset", ioe);
            }
        }
        if (this.printHeaders) {
            try {
                Iterator headersIt = consumerRecord.headers().iterator();
                if (headersIt.hasNext()) {
                    headersIt.forEachRemaining(header -> {
                        try {
                            output.write((header.key() + ":").getBytes(StandardCharsets.UTF_8));
                            output.write(this.deserialize(this.headersDeserializer, consumerRecord, header.value()));
                            if (headersIt.hasNext()) {
                                output.write(this.headersSeparator);
                            }
                        }
                        catch (IOException ioe) {
                            throw new SerializationException("Error while formatting the headers", ioe);
                        }
                    });
                } else {
                    output.write("NO_HEADERS".getBytes(StandardCharsets.UTF_8));
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the headers", ioe);
            }
        }
        if (this.printKey) {
            try {
                if (this.deserializer.getKeyDeserializer() != null) {
                    Object deserializedKey = consumerRecord.key() == null ? null : this.deserializer.deserializeKey(consumerRecord.topic(), consumerRecord.headers(), consumerRecord.key());
                    output.write(deserializedKey != null ? deserializedKey.toString().getBytes(StandardCharsets.UTF_8) : this.nullLiteral);
                } else if (consumerRecord.key() != null) {
                    this.writeTo(consumerRecord.topic(), true, consumerRecord.headers(), consumerRecord.key(), output);
                } else {
                    output.write(this.nullLiteral);
                }
                if (this.printKeyId) {
                    output.write(this.idSeparator);
                    if (consumerRecord.key() != null) {
                        int schemaId = this.schemaIdFor(consumerRecord.key());
                        output.print(schemaId);
                    } else {
                        output.write(this.nullLiteral);
                    }
                }
                output.write(this.keySeparator);
            }
            catch (IOException ioe) {
                throw new SerializationException("Error while formatting the key", ioe);
            }
        }
        try {
            if (consumerRecord.value() != null) {
                this.writeTo(consumerRecord.topic(), false, consumerRecord.headers(), consumerRecord.value(), output);
            } else {
                output.write(this.nullLiteral);
            }
            if (this.printValueId) {
                output.write(this.idSeparator);
                if (consumerRecord.value() != null) {
                    int schemaId = this.schemaIdFor(consumerRecord.value());
                    output.print(schemaId);
                } else {
                    output.write(NULL_BYTES);
                }
            }
            output.write(this.lineSeparator);
        }
        catch (IOException ioe) {
            throw new SerializationException("Error while formatting the value", ioe);
        }
    }

    protected abstract void writeTo(String var1, Boolean var2, Headers var3, byte[] var4, PrintStream var5) throws IOException;

    @Override
    public void close() {
        if (this.deserializer != null) {
            try {
                this.deserializer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Exception while closing deserializer", e);
            }
        }
    }

    private byte[] deserialize(Deserializer<?> deserializer, ConsumerRecord<byte[], byte[]> consumerRecord, byte[] sourceBytes) {
        if (deserializer == null || sourceBytes == null) {
            return this.nullLiteral;
        }
        Object deserializedHeader = deserializer.deserialize(consumerRecord.topic(), consumerRecord.headers(), sourceBytes);
        return deserializedHeader != null ? deserializedHeader.toString().getBytes(StandardCharsets.UTF_8) : this.nullLiteral;
    }

    private int schemaIdFor(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer.getInt();
    }

    protected abstract SchemaProvider getProvider();
}

