/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json;

import io.confluent.kafka.schemaregistry.AbstractSchemaProvider;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaProvider.class);

    @Override
    public String schemaType() {
        return "JSON";
    }

    @Override
    public ParsedSchema parseSchemaOrElseThrow(Schema schema2, boolean isNew, boolean normalize) {
        try {
            return new JsonSchema(schema2.getSchema(), schema2.getReferences(), this.resolveReferences(schema2), schema2.getMetadata(), schema2.getRuleSet(), null);
        }
        catch (Exception e) {
            log.error("Could not parse JSON schema", e);
            throw e;
        }
    }
}

