/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.json.diff;

import io.confluent.kafka.schemaregistry.json.diff.Difference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.everit.json.schema.Schema;

public class Context {
    private final Set<Difference.Type> compatibleChanges;
    private final Set<Schema> schemas;
    private final Deque<String> jsonPath;
    private final List<Difference> diffs;

    public Context(Set<Difference.Type> compatibleChanges) {
        this.compatibleChanges = compatibleChanges;
        this.schemas = Collections.newSetFromMap(new IdentityHashMap());
        this.jsonPath = new ArrayDeque<String>();
        this.diffs = new ArrayList<Difference>();
    }

    public Context getSubcontext() {
        Context ctx2 = new Context(this.compatibleChanges);
        ctx2.schemas.addAll(this.schemas);
        ctx2.jsonPath.addAll(this.jsonPath);
        return ctx2;
    }

    public SchemaScope enterSchema(Schema schema2) {
        return !this.schemas.contains(schema2) ? new SchemaScope(schema2) : null;
    }

    public PathScope enterPath(String path) {
        return new PathScope(path);
    }

    public boolean isCompatible() {
        boolean notCompatible = this.getDifferences().stream().map(Difference::getType).anyMatch(t2 -> !this.compatibleChanges.contains(t2));
        return !notCompatible;
    }

    public List<Difference> getDifferences() {
        return this.diffs;
    }

    public void addDifference(Difference.Type type) {
        this.diffs.add(new Difference(type, Context.jsonPathString(this.jsonPath)));
    }

    public void addDifference(String attribute, Difference.Type type) {
        this.jsonPath.addLast(attribute);
        this.addDifference(type);
        this.jsonPath.removeLast();
    }

    public void addDifferences(List<Difference> differences) {
        this.diffs.addAll(differences);
    }

    private static String jsonPathString(Deque<String> jsonPath) {
        return "#/" + String.join((CharSequence)"/", jsonPath);
    }

    public class PathScope
    implements AutoCloseable {
        public PathScope(String path) {
            Context.this.jsonPath.addLast(path);
        }

        @Override
        public void close() {
            Context.this.jsonPath.removeLast();
        }
    }

    public class SchemaScope
    implements AutoCloseable {
        private final Schema schema;

        public SchemaScope(Schema schema2) {
            this.schema = schema2;
            Context.this.schemas.add(schema2);
        }

        @Override
        public void close() {
            Context.this.schemas.remove(this.schema);
        }
    }
}

