/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.LongNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.ShortNode;
import org.apache.pinot.shaded.com.fasterxml.jackson.databind.node.TextNode;

public class RegisterBrokerRecordJsonConverter {
    public static RegisterBrokerRecord read(JsonNode _node, short _version) {
        RegisterBrokerRecord.BrokerFeatureCollection _collection;
        RegisterBrokerRecord.BrokerEndpointCollection _collection2;
        RegisterBrokerRecord _object = new RegisterBrokerRecord();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "RegisterBrokerRecord");
        JsonNode _incarnationIdNode = _node.get("incarnationId");
        if (_incarnationIdNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'incarnationId', which is mandatory in version " + _version);
        }
        if (!_incarnationIdNode.isTextual()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON string type, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.incarnationId = Uuid.fromString(_incarnationIdNode.asText());
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong(_brokerEpochNode, "RegisterBrokerRecord");
        JsonNode _endPointsNode = _node.get("endPoints");
        if (_endPointsNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'endPoints', which is mandatory in version " + _version);
        }
        if (!_endPointsNode.isArray()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.endPoints = _collection2 = new RegisterBrokerRecord.BrokerEndpointCollection(_endPointsNode.size());
        for (JsonNode _element : _endPointsNode) {
            _collection2.add(BrokerEndpointJsonConverter.read(_element, _version));
        }
        JsonNode _featuresNode = _node.get("features");
        if (_featuresNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'features', which is mandatory in version " + _version);
        }
        if (!_featuresNode.isArray()) {
            throw new RuntimeException("RegisterBrokerRecord expected a JSON array, but got " + (Object)((Object)_node.getNodeType()));
        }
        _object.features = _collection = new RegisterBrokerRecord.BrokerFeatureCollection(_featuresNode.size());
        for (JsonNode _element : _featuresNode) {
            _collection.add(BrokerFeatureJsonConverter.read(_element, _version));
        }
        JsonNode _rackNode = _node.get("rack");
        if (_rackNode == null) {
            throw new RuntimeException("RegisterBrokerRecord: unable to locate field 'rack', which is mandatory in version " + _version);
        }
        if (_rackNode.isNull()) {
            _object.rack = null;
        } else {
            if (!_rackNode.isTextual()) {
                throw new RuntimeException("RegisterBrokerRecord expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.rack = _rackNode.asText();
        }
        return _object;
    }

    public static JsonNode write(RegisterBrokerRecord _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", new IntNode(_object.brokerId));
        _node.set("incarnationId", new TextNode(_object.incarnationId.toString()));
        _node.set("brokerEpoch", new LongNode(_object.brokerEpoch));
        ArrayNode _endPointsArray = new ArrayNode(JsonNodeFactory.instance);
        for (RegisterBrokerRecord.BrokerEndpoint _element : _object.endPoints) {
            _endPointsArray.add(BrokerEndpointJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("endPoints", _endPointsArray);
        ArrayNode _featuresArray = new ArrayNode(JsonNodeFactory.instance);
        for (RegisterBrokerRecord.BrokerFeature _element : _object.features) {
            _featuresArray.add(BrokerFeatureJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("features", _featuresArray);
        if (_object.rack == null) {
            _node.set("rack", NullNode.instance);
        } else {
            _node.set("rack", new TextNode(_object.rack));
        }
        return _node;
    }

    public static JsonNode write(RegisterBrokerRecord _object, short _version) {
        return RegisterBrokerRecordJsonConverter.write(_object, _version, true);
    }

    public static class BrokerFeatureJsonConverter {
        public static RegisterBrokerRecord.BrokerFeature read(JsonNode _node, short _version) {
            RegisterBrokerRecord.BrokerFeature _object = new RegisterBrokerRecord.BrokerFeature();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("BrokerFeature expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _minSupportedVersionNode = _node.get("minSupportedVersion");
            if (_minSupportedVersionNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'minSupportedVersion', which is mandatory in version " + _version);
            }
            _object.minSupportedVersion = MessageUtil.jsonNodeToShort(_minSupportedVersionNode, "BrokerFeature");
            JsonNode _maxSupportedVersionNode = _node.get("maxSupportedVersion");
            if (_maxSupportedVersionNode == null) {
                throw new RuntimeException("BrokerFeature: unable to locate field 'maxSupportedVersion', which is mandatory in version " + _version);
            }
            _object.maxSupportedVersion = MessageUtil.jsonNodeToShort(_maxSupportedVersionNode, "BrokerFeature");
            return _object;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerFeature _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(_object.name));
            _node.set("minSupportedVersion", new ShortNode(_object.minSupportedVersion));
            _node.set("maxSupportedVersion", new ShortNode(_object.maxSupportedVersion));
            return _node;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerFeature _object, short _version) {
            return BrokerFeatureJsonConverter.write(_object, _version, true);
        }
    }

    public static class BrokerEndpointJsonConverter {
        public static RegisterBrokerRecord.BrokerEndpoint read(JsonNode _node, short _version) {
            RegisterBrokerRecord.BrokerEndpoint _object = new RegisterBrokerRecord.BrokerEndpoint();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("BrokerEndpoint expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("BrokerEndpoint expected a string type, but got " + (Object)((Object)_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToUnsignedShort(_portNode, "BrokerEndpoint");
            JsonNode _securityProtocolNode = _node.get("securityProtocol");
            if (_securityProtocolNode == null) {
                throw new RuntimeException("BrokerEndpoint: unable to locate field 'securityProtocol', which is mandatory in version " + _version);
            }
            _object.securityProtocol = MessageUtil.jsonNodeToShort(_securityProtocolNode, "BrokerEndpoint");
            return _object;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerEndpoint _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(_object.name));
            _node.set("host", new TextNode(_object.host));
            _node.set("port", new IntNode(_object.port));
            _node.set("securityProtocol", new ShortNode(_object.securityProtocol));
            return _node;
        }

        public static JsonNode write(RegisterBrokerRecord.BrokerEndpoint _object, short _version) {
            return BrokerEndpointJsonConverter.write(_object, _version, true);
        }
    }
}

