/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Collections;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BeginQuorumEpochResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.EndQuorumEpochResponseData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.message.VoteResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;

public class RaftUtil {
    public static ApiMessage errorResponse(ApiKeys apiKey, Errors error) {
        switch (apiKey) {
            case VOTE: {
                return new VoteResponseData().setErrorCode(error.code());
            }
            case BEGIN_QUORUM_EPOCH: {
                return new BeginQuorumEpochResponseData().setErrorCode(error.code());
            }
            case END_QUORUM_EPOCH: {
                return new EndQuorumEpochResponseData().setErrorCode(error.code());
            }
            case FETCH: {
                return new FetchResponseData().setErrorCode(error.code());
            }
        }
        throw new IllegalArgumentException("Received response for unexpected request type: " + (Object)((Object)apiKey));
    }

    public static FetchRequestData singletonFetchRequest(TopicPartition topicPartition, Consumer<FetchRequestData.FetchPartition> partitionConsumer) {
        FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setPartition(topicPartition.partition());
        partitionConsumer.accept(fetchPartition);
        FetchRequestData.FetchTopic fetchTopic = new FetchRequestData.FetchTopic().setTopic(topicPartition.topic()).setPartitions(Collections.singletonList(fetchPartition));
        return new FetchRequestData().setTopics(Collections.singletonList(fetchTopic));
    }

    public static FetchResponseData singletonFetchResponse(TopicPartition topicPartition, Errors topLevelError, Consumer<FetchResponseData.FetchablePartitionResponse> partitionConsumer) {
        FetchResponseData.FetchablePartitionResponse fetchablePartition = new FetchResponseData.FetchablePartitionResponse();
        fetchablePartition.setPartition(topicPartition.partition());
        partitionConsumer.accept(fetchablePartition);
        FetchResponseData.FetchableTopicResponse fetchableTopic = new FetchResponseData.FetchableTopicResponse().setTopic(topicPartition.topic()).setPartitionResponses(Collections.singletonList(fetchablePartition));
        return new FetchResponseData().setErrorCode(topLevelError.code()).setResponses(Collections.singletonList(fetchableTopic));
    }

    static boolean hasValidTopicPartition(FetchRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topic().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partition() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(FetchResponseData data, TopicPartition topicPartition) {
        return data.responses().size() == 1 && data.responses().get(0).topic().equals(topicPartition.topic()) && data.responses().get(0).partitionResponses().size() == 1 && data.responses().get(0).partitionResponses().get(0).partition() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(VoteResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(VoteRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(BeginQuorumEpochRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(BeginQuorumEpochResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(EndQuorumEpochRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(EndQuorumEpochResponseData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }

    static boolean hasValidTopicPartition(DescribeQuorumRequestData data, TopicPartition topicPartition) {
        return data.topics().size() == 1 && data.topics().get(0).topicName().equals(topicPartition.topic()) && data.topics().get(0).partitions().size() == 1 && data.topics().get(0).partitions().get(0).partitionIndex() == topicPartition.partition();
    }
}

