/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CustomTypes is the corresponding interface of CustomTypes
type CustomTypes interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetCustomString returns CustomString (property field)
	GetCustomString() string
	// IsCustomTypes is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCustomTypes()
	// CreateBuilder creates a CustomTypesBuilder
	CreateCustomTypesBuilder() CustomTypesBuilder
}

// _CustomTypes is the data-structure of this message
type _CustomTypes struct {
	CustomString string

	// Arguments.
	NumBytes uint8
}

var _ CustomTypes = (*_CustomTypes)(nil)

// NewCustomTypes factory function for _CustomTypes
func NewCustomTypes(customString string, numBytes uint8) *_CustomTypes {
	return &_CustomTypes{CustomString: customString, NumBytes: numBytes}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CustomTypesBuilder is a builder for CustomTypes
type CustomTypesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(customString string) CustomTypesBuilder
	// WithCustomString adds CustomString (property field)
	WithCustomString(string) CustomTypesBuilder
	// WithArgNumBytes sets a parser argument
	WithArgNumBytes(uint8) CustomTypesBuilder
	// Build builds the CustomTypes or returns an error if something is wrong
	Build() (CustomTypes, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CustomTypes
}

// NewCustomTypesBuilder() creates a CustomTypesBuilder
func NewCustomTypesBuilder() CustomTypesBuilder {
	return &_CustomTypesBuilder{_CustomTypes: new(_CustomTypes)}
}

type _CustomTypesBuilder struct {
	*_CustomTypes

	collectedErr []error
}

var _ (CustomTypesBuilder) = (*_CustomTypesBuilder)(nil)

func (b *_CustomTypesBuilder) WithMandatoryFields(customString string) CustomTypesBuilder {
	return b.WithCustomString(customString)
}

func (b *_CustomTypesBuilder) WithCustomString(customString string) CustomTypesBuilder {
	b.CustomString = customString
	return b
}

func (b *_CustomTypesBuilder) WithArgNumBytes(numBytes uint8) CustomTypesBuilder {
	b.NumBytes = numBytes
	return b
}

func (b *_CustomTypesBuilder) Build() (CustomTypes, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._CustomTypes.deepCopy(), nil
}

func (b *_CustomTypesBuilder) MustBuild() CustomTypes {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CustomTypesBuilder) DeepCopy() any {
	_copy := b.CreateCustomTypesBuilder().(*_CustomTypesBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateCustomTypesBuilder creates a CustomTypesBuilder
func (b *_CustomTypes) CreateCustomTypesBuilder() CustomTypesBuilder {
	if b == nil {
		return NewCustomTypesBuilder()
	}
	return &_CustomTypesBuilder{_CustomTypes: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CustomTypes) GetCustomString() string {
	return m.CustomString
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCustomTypes(structType any) CustomTypes {
	if casted, ok := structType.(CustomTypes); ok {
		return casted
	}
	if casted, ok := structType.(*CustomTypes); ok {
		return *casted
	}
	return nil
}

func (m *_CustomTypes) GetTypeName() string {
	return "CustomTypes"
}

func (m *_CustomTypes) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (customString)
	lengthInBits += uint16(int32(int32(8)) * int32(m.GetNumBytes()))

	return lengthInBits
}

func (m *_CustomTypes) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CustomTypesParse(ctx context.Context, theBytes []byte, numBytes uint8) (CustomTypes, error) {
	return CustomTypesParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), numBytes)
}

func CustomTypesParseWithBufferProducer(numBytes uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (CustomTypes, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (CustomTypes, error) {
		return CustomTypesParseWithBuffer(ctx, readBuffer, numBytes)
	}
}

func CustomTypesParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, numBytes uint8) (CustomTypes, error) {
	v, err := (&_CustomTypes{NumBytes: numBytes}).parse(ctx, readBuffer, numBytes)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_CustomTypes) parse(ctx context.Context, readBuffer utils.ReadBuffer, numBytes uint8) (__customTypes CustomTypes, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CustomTypes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CustomTypes")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	customString, err := ReadSimpleField(ctx, "customString", ReadString(readBuffer, uint32(int32(int32(8))*int32(numBytes))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'customString' field"))
	}
	m.CustomString = customString

	if closeErr := readBuffer.CloseContext("CustomTypes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CustomTypes")
	}

	return m, nil
}

func (m *_CustomTypes) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CustomTypes) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("CustomTypes"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CustomTypes")
	}

	if err := WriteSimpleField[string](ctx, "customString", m.GetCustomString(), WriteString(writeBuffer, int32(int32(int32(8))*int32(m.GetNumBytes())))); err != nil {
		return errors.Wrap(err, "Error serializing 'customString' field")
	}

	if popErr := writeBuffer.PopContext("CustomTypes"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CustomTypes")
	}
	return nil
}

////
// Arguments Getter

func (m *_CustomTypes) GetNumBytes() uint8 {
	return m.NumBytes
}

//
////

func (m *_CustomTypes) IsCustomTypes() {}

func (m *_CustomTypes) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CustomTypes) deepCopy() *_CustomTypes {
	if m == nil {
		return nil
	}
	_CustomTypesCopy := &_CustomTypes{
		m.CustomString,
		m.NumBytes,
	}
	return _CustomTypesCopy
}

func (m *_CustomTypes) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
