/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KnxGroupAddress is the corresponding interface of KnxGroupAddress
type KnxGroupAddress interface {
	KnxGroupAddressContract
	KnxGroupAddressRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsKnxGroupAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKnxGroupAddress()
	// CreateBuilder creates a KnxGroupAddressBuilder
	CreateKnxGroupAddressBuilder() KnxGroupAddressBuilder
}

// KnxGroupAddressContract provides a set of functions which can be overwritten by a sub struct
type KnxGroupAddressContract interface {
	// IsKnxGroupAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKnxGroupAddress()
	// CreateBuilder creates a KnxGroupAddressBuilder
	CreateKnxGroupAddressBuilder() KnxGroupAddressBuilder
}

// KnxGroupAddressRequirements provides a set of functions which need to be implemented by a sub struct
type KnxGroupAddressRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetNumLevels returns NumLevels (discriminator field)
	GetNumLevels() uint8
}

// _KnxGroupAddress is the data-structure of this message
type _KnxGroupAddress struct {
	_SubType interface {
		KnxGroupAddressContract
		KnxGroupAddressRequirements
	}
}

var _ KnxGroupAddressContract = (*_KnxGroupAddress)(nil)

// NewKnxGroupAddress factory function for _KnxGroupAddress
func NewKnxGroupAddress() *_KnxGroupAddress {
	return &_KnxGroupAddress{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// KnxGroupAddressBuilder is a builder for KnxGroupAddress
type KnxGroupAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() KnxGroupAddressBuilder
	// AsKnxGroupAddressFreeLevel converts this build to a subType of KnxGroupAddress. It is always possible to return to current builder using Done()
	AsKnxGroupAddressFreeLevel() KnxGroupAddressFreeLevelBuilder
	// AsKnxGroupAddress2Level converts this build to a subType of KnxGroupAddress. It is always possible to return to current builder using Done()
	AsKnxGroupAddress2Level() KnxGroupAddress2LevelBuilder
	// AsKnxGroupAddress3Level converts this build to a subType of KnxGroupAddress. It is always possible to return to current builder using Done()
	AsKnxGroupAddress3Level() KnxGroupAddress3LevelBuilder
	// Build builds the KnxGroupAddress or returns an error if something is wrong
	PartialBuild() (KnxGroupAddressContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() KnxGroupAddressContract
	// Build builds the KnxGroupAddress or returns an error if something is wrong
	Build() (KnxGroupAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() KnxGroupAddress
}

// NewKnxGroupAddressBuilder() creates a KnxGroupAddressBuilder
func NewKnxGroupAddressBuilder() KnxGroupAddressBuilder {
	return &_KnxGroupAddressBuilder{_KnxGroupAddress: new(_KnxGroupAddress)}
}

type _KnxGroupAddressChildBuilder interface {
	utils.Copyable
	setParent(KnxGroupAddressContract)
	buildForKnxGroupAddress() (KnxGroupAddress, error)
}

type _KnxGroupAddressBuilder struct {
	*_KnxGroupAddress

	childBuilder _KnxGroupAddressChildBuilder

	collectedErr []error
}

var _ (KnxGroupAddressBuilder) = (*_KnxGroupAddressBuilder)(nil)

func (b *_KnxGroupAddressBuilder) WithMandatoryFields() KnxGroupAddressBuilder {
	return b
}

func (b *_KnxGroupAddressBuilder) PartialBuild() (KnxGroupAddressContract, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._KnxGroupAddress.deepCopy(), nil
}

func (b *_KnxGroupAddressBuilder) PartialMustBuild() KnxGroupAddressContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KnxGroupAddressBuilder) AsKnxGroupAddressFreeLevel() KnxGroupAddressFreeLevelBuilder {
	if cb, ok := b.childBuilder.(KnxGroupAddressFreeLevelBuilder); ok {
		return cb
	}
	cb := NewKnxGroupAddressFreeLevelBuilder().(*_KnxGroupAddressFreeLevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_KnxGroupAddressBuilder) AsKnxGroupAddress2Level() KnxGroupAddress2LevelBuilder {
	if cb, ok := b.childBuilder.(KnxGroupAddress2LevelBuilder); ok {
		return cb
	}
	cb := NewKnxGroupAddress2LevelBuilder().(*_KnxGroupAddress2LevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_KnxGroupAddressBuilder) AsKnxGroupAddress3Level() KnxGroupAddress3LevelBuilder {
	if cb, ok := b.childBuilder.(KnxGroupAddress3LevelBuilder); ok {
		return cb
	}
	cb := NewKnxGroupAddress3LevelBuilder().(*_KnxGroupAddress3LevelBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_KnxGroupAddressBuilder) Build() (KnxGroupAddress, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForKnxGroupAddress()
}

func (b *_KnxGroupAddressBuilder) MustBuild() KnxGroupAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KnxGroupAddressBuilder) DeepCopy() any {
	_copy := b.CreateKnxGroupAddressBuilder().(*_KnxGroupAddressBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_KnxGroupAddressChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateKnxGroupAddressBuilder creates a KnxGroupAddressBuilder
func (b *_KnxGroupAddress) CreateKnxGroupAddressBuilder() KnxGroupAddressBuilder {
	if b == nil {
		return NewKnxGroupAddressBuilder()
	}
	return &_KnxGroupAddressBuilder{_KnxGroupAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastKnxGroupAddress(structType any) KnxGroupAddress {
	if casted, ok := structType.(KnxGroupAddress); ok {
		return casted
	}
	if casted, ok := structType.(*KnxGroupAddress); ok {
		return *casted
	}
	return nil
}

func (m *_KnxGroupAddress) GetTypeName() string {
	return "KnxGroupAddress"
}

func (m *_KnxGroupAddress) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_KnxGroupAddress) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_KnxGroupAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func KnxGroupAddressParse[T KnxGroupAddress](ctx context.Context, theBytes []byte, numLevels uint8) (T, error) {
	return KnxGroupAddressParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), numLevels)
}

func KnxGroupAddressParseWithBufferProducer[T KnxGroupAddress](numLevels uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := KnxGroupAddressParseWithBuffer[T](ctx, readBuffer, numLevels)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func KnxGroupAddressParseWithBuffer[T KnxGroupAddress](ctx context.Context, readBuffer utils.ReadBuffer, numLevels uint8) (T, error) {
	v, err := (&_KnxGroupAddress{}).parse(ctx, readBuffer, numLevels)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_KnxGroupAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer, numLevels uint8) (__knxGroupAddress KnxGroupAddress, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("KnxGroupAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KnxGroupAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child KnxGroupAddress
	switch {
	case numLevels == uint8(1): // KnxGroupAddressFreeLevel
		if _child, err = new(_KnxGroupAddressFreeLevel).parse(ctx, readBuffer, m, numLevels); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type KnxGroupAddressFreeLevel for type-switch of KnxGroupAddress")
		}
	case numLevels == uint8(2): // KnxGroupAddress2Level
		if _child, err = new(_KnxGroupAddress2Level).parse(ctx, readBuffer, m, numLevels); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type KnxGroupAddress2Level for type-switch of KnxGroupAddress")
		}
	case numLevels == uint8(3): // KnxGroupAddress3Level
		if _child, err = new(_KnxGroupAddress3Level).parse(ctx, readBuffer, m, numLevels); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type KnxGroupAddress3Level for type-switch of KnxGroupAddress")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [numLevels=%v]", numLevels)
	}

	if closeErr := readBuffer.CloseContext("KnxGroupAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KnxGroupAddress")
	}

	return _child, nil
}

func (pm *_KnxGroupAddress) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child KnxGroupAddress, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("KnxGroupAddress"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for KnxGroupAddress")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("KnxGroupAddress"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for KnxGroupAddress")
	}
	return nil
}

func (m *_KnxGroupAddress) IsKnxGroupAddress() {}

func (m *_KnxGroupAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_KnxGroupAddress) deepCopy() *_KnxGroupAddress {
	if m == nil {
		return nil
	}
	_KnxGroupAddressCopy := &_KnxGroupAddress{
		nil, // will be set by child
	}
	return _KnxGroupAddressCopy
}
