/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

final class DoubleArrays {
    private static final int QUICKSORT_NO_REC = 16;
    private static final int QUICKSORT_MEDIAN_OF_9 = 128;

    private DoubleArrays() {
    }

    public static void quickSortIndirect(int[] perm, double[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 16) {
            DoubleArrays.insertionSortIndirect(perm, x, from, to);
            return;
        }
        int m = from + len / 2;
        int l = from;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = DoubleArrays.med3Indirect(perm, x, l, l + s, l + 2 * s);
            m = DoubleArrays.med3Indirect(perm, x, m - s, m, m + s);
            n = DoubleArrays.med3Indirect(perm, x, n - 2 * s, n - s, n);
        }
        m = DoubleArrays.med3Indirect(perm, x, l, m, n);
        double v = x[perm[m]];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Double.compare(x[perm[b]], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(perm, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Double.compare(x[perm[c]], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(perm, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleArrays.swap(perm, b++, c--);
        }
        int s = Math.min(a - from, b - a);
        DoubleArrays.swap(perm, from, b - s, s);
        s = Math.min(d - c, to - d - 1);
        DoubleArrays.swap(perm, b, to - s, s);
        s = b - a;
        if (s > 1) {
            DoubleArrays.quickSortIndirect(perm, x, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSortIndirect(perm, x, to - s, to);
        }
    }

    private static void insertionSortIndirect(int[] perm, double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (Double.compare(a[t], a[u]) < 0) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    private static int med3Indirect(int[] perm, double[] x, int a, int b, int c) {
        double aa = x[perm[a]];
        double bb = x[perm[b]];
        double cc = x[perm[c]];
        int ab = Double.compare(aa, bb);
        int ac = Double.compare(aa, cc);
        int bc = Double.compare(bb, cc);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void swap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            DoubleArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }
}

