/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import com.google.common.primitives.Ints;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.json.JsonCodec;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class JsonResponseHandler<T>
implements ResponseHandler<T, RuntimeException> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.create((String)"application", (String)"json");
    private final JsonCodec<T> jsonCodec;
    private final Set<Integer> successfulResponseCodes;

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec) {
        return new JsonResponseHandler<T>(jsonCodec);
    }

    public static <T> JsonResponseHandler<T> createJsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        return new JsonResponseHandler<T>(jsonCodec, firstSuccessfulResponseCode, otherSuccessfulResponseCodes);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec) {
        this(jsonCodec, 200, 201, 202, 203, 204, 205, 206);
    }

    private JsonResponseHandler(JsonCodec<T> jsonCodec, int firstSuccessfulResponseCode, int ... otherSuccessfulResponseCodes) {
        this.jsonCodec = jsonCodec;
        this.successfulResponseCodes = ImmutableSet.builder().add((Object)firstSuccessfulResponseCode).addAll((Iterable)Ints.asList((int[])otherSuccessfulResponseCodes)).build();
    }

    @Override
    public T handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate(request, exception);
    }

    @Override
    public T handle(Request request, Response response) {
        if (!this.successfulResponseCodes.contains(response.getStatusCode())) {
            throw new UnexpectedResponseException(String.format("Expected response code to be %s, but was %d", this.successfulResponseCodes, response.getStatusCode()), request, response);
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            throw new UnexpectedResponseException("Content-Type is not set for response", request, response);
        }
        if (!MediaType.parse((String)contentType).is(MEDIA_TYPE_JSON)) {
            throw new UnexpectedResponseException("Expected application/json response from server but got " + contentType, request, response);
        }
        byte[] bytes = ResponseHandlerUtils.readResponseBytes(request, response);
        try {
            return (T)this.jsonCodec.fromJson(bytes);
        }
        catch (IllegalArgumentException e) {
            String json = new String(bytes, StandardCharsets.UTF_8);
            throw new IllegalArgumentException(String.format("Unable to create %s from JSON response:\n[%s]", this.jsonCodec.getType(), json), e);
        }
    }
}

