/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.sql.planner.Symbol;
import java.util.function.BiFunction;

public final class SemiJoinStatsCalculator {
    private static final double MIN_ANTI_JOIN_FILTER_COEFFICIENT = 0.5;

    private SemiJoinStatsCalculator() {
    }

    public static PlanNodeStatsEstimate computeSemiJoin(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol) {
        return SemiJoinStatsCalculator.compute(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol, (sourceJoinSymbolStats, filteringSourceJoinSymbolStats) -> Double.min(filteringSourceJoinSymbolStats.getDistinctValuesCount(), sourceJoinSymbolStats.getDistinctValuesCount()));
    }

    public static PlanNodeStatsEstimate computeAntiJoin(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol) {
        return SemiJoinStatsCalculator.compute(sourceStats, filteringSourceStats, sourceJoinSymbol, filteringSourceJoinSymbol, (sourceJoinSymbolStats, filteringSourceJoinSymbolStats) -> Double.max(sourceJoinSymbolStats.getDistinctValuesCount() * 0.5, sourceJoinSymbolStats.getDistinctValuesCount() - filteringSourceJoinSymbolStats.getDistinctValuesCount()));
    }

    private static PlanNodeStatsEstimate compute(PlanNodeStatsEstimate sourceStats, PlanNodeStatsEstimate filteringSourceStats, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, BiFunction<SymbolStatsEstimate, SymbolStatsEstimate, Double> retainedNdvProvider) {
        SymbolStatsEstimate sourceJoinSymbolStats = sourceStats.getSymbolStatistics(sourceJoinSymbol);
        SymbolStatsEstimate filteringSourceJoinSymbolStats = filteringSourceStats.getSymbolStatistics(filteringSourceJoinSymbol);
        double retainedNdv = retainedNdvProvider.apply(sourceJoinSymbolStats, filteringSourceJoinSymbolStats);
        SymbolStatsEstimate newSourceJoinSymbolStats = SymbolStatsEstimate.buildFrom(sourceJoinSymbolStats).setNullsFraction(0.0).setDistinctValuesCount(retainedNdv).build();
        double sourceDistinctValuesCount = sourceJoinSymbolStats.getDistinctValuesCount();
        if (sourceDistinctValuesCount == 0.0) {
            return PlanNodeStatsEstimate.buildFrom(sourceStats).addSymbolStatistics(sourceJoinSymbol, newSourceJoinSymbolStats).setOutputRowCount(0.0).build();
        }
        double filterFactor = sourceJoinSymbolStats.getValuesFraction() * retainedNdv / sourceDistinctValuesCount;
        double outputRowCount = sourceStats.getOutputRowCount() * filterFactor;
        return PlanNodeStatsEstimate.buildFrom(sourceStats).addSymbolStatistics(sourceJoinSymbol, newSourceJoinSymbolStats).setOutputRowCount(outputRowCount).build();
    }
}

