/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class DropRoleTask
implements DataDefinitionTask<DropRole> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public DropRoleTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "DROP ROLE";
    }

    @Override
    public ListenableFuture<Void> execute(DropRole statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, session, (Node)statement, statement.getCatalog().map(Identifier::getValue));
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        this.accessControl.checkCanDropRole(session.toSecurityContext(), role, catalog);
        MetadataUtil.checkRoleExists(session, (Node)statement, this.metadata, role, catalog);
        this.metadata.dropRole(session, role, catalog);
        return Futures.immediateVoidFuture();
    }
}

