/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.security.Identity;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MaterializedViewDefinition
extends ViewDefinition {
    private final Optional<CatalogSchemaTableName> storageTable;
    private final Map<String, Object> properties;

    public MaterializedViewDefinition(String originalSql, Optional<String> catalog, Optional<String> schema, List<ViewColumn> columns, Optional<String> comment, Identity owner, Optional<CatalogSchemaTableName> storageTable, Map<String, Object> properties) {
        super(originalSql, catalog, schema, columns, comment, Optional.of(owner));
        this.storageTable = Objects.requireNonNull(storageTable, "storageTable is null");
        this.properties = ImmutableMap.copyOf(Objects.requireNonNull(properties, "properties is null"));
    }

    public MaterializedViewDefinition(ConnectorMaterializedViewDefinition view, Identity runAsIdentity) {
        super(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(column -> new ViewColumn(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()), view.getComment(), Optional.of(runAsIdentity));
        this.storageTable = view.getStorageTable();
        this.properties = ImmutableMap.copyOf((Map)view.getProperties());
    }

    public Optional<CatalogSchemaTableName> getStorageTable() {
        return this.storageTable;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ConnectorMaterializedViewDefinition toConnectorMaterializedViewDefinition() {
        return new ConnectorMaterializedViewDefinition(this.getOriginalSql(), this.storageTable, this.getCatalog(), this.getSchema(), (List)this.getColumns().stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()), this.getComment(), this.getRunAsIdentity().map(Identity::getUser), this.properties);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalSql", (Object)this.getOriginalSql()).add("catalog", this.getCatalog().orElse(null)).add("schema", this.getSchema().orElse(null)).add("columns", this.getColumns()).add("comment", this.getComment().orElse(null)).add("runAsIdentity", this.getRunAsIdentity()).add("storageTable", this.storageTable.orElse(null)).add("properties", this.properties).toString();
    }
}

