/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.execution.Lifespan;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PipelineExecutionStrategy;
import io.trino.operator.SourceOperatorFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class DriverFactory {
    private final int pipelineId;
    private final boolean inputDriver;
    private final boolean outputDriver;
    private final List<OperatorFactory> operatorFactories;
    private final Optional<PlanNodeId> sourceId;
    private final OptionalInt driverInstances;
    private final PipelineExecutionStrategy pipelineExecutionStrategy;
    private boolean closed;
    private final Set<Lifespan> encounteredLifespans = new HashSet<Lifespan>();
    private final Set<Lifespan> closedLifespans = new HashSet<Lifespan>();

    public DriverFactory(int pipelineId, boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances, PipelineExecutionStrategy pipelineExecutionStrategy) {
        this.pipelineId = pipelineId;
        this.inputDriver = inputDriver;
        this.outputDriver = outputDriver;
        this.operatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorFactories, "operatorFactories is null"));
        Preconditions.checkArgument((!operatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        this.driverInstances = Objects.requireNonNull(driverInstances, "driverInstances is null");
        this.pipelineExecutionStrategy = Objects.requireNonNull(pipelineExecutionStrategy, "pipelineExecutionStrategy is null");
        List sourceIds = (List)operatorFactories.stream().filter(SourceOperatorFactory.class::isInstance).map(SourceOperatorFactory.class::cast).map(SourceOperatorFactory::getSourceId).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((sourceIds.size() <= 1 ? 1 : 0) != 0, (String)"Expected at most one source operator in driver factory, but found %s", (Object)sourceIds);
        this.sourceId = sourceIds.isEmpty() ? Optional.empty() : Optional.of((PlanNodeId)sourceIds.get(0));
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputDriver() {
        return this.inputDriver;
    }

    public boolean isOutputDriver() {
        return this.outputDriver;
    }

    public Optional<PlanNodeId> getSourceId() {
        return this.sourceId;
    }

    public OptionalInt getDriverInstances() {
        return this.driverInstances;
    }

    public PipelineExecutionStrategy getPipelineExecutionStrategy() {
        return this.pipelineExecutionStrategy;
    }

    public List<OperatorFactory> getOperatorFactories() {
        return this.operatorFactories;
    }

    public synchronized Driver createDriver(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"DriverFactory is already closed");
        Objects.requireNonNull(driverContext, "driverContext is null");
        Preconditions.checkState((!this.closedLifespans.contains(driverContext.getLifespan()) ? 1 : 0) != 0, (String)"DriverFactory is already closed for driver group %s", (Object)driverContext.getLifespan());
        this.encounteredLifespans.add(driverContext.getLifespan());
        ImmutableList.Builder operators = ImmutableList.builder();
        for (OperatorFactory operatorFactory : this.operatorFactories) {
            Operator operator = operatorFactory.createOperator(driverContext);
            operators.add((Object)operator);
        }
        return Driver.createDriver(driverContext, (List<Operator>)operators.build());
    }

    public synchronized void noMoreDrivers(Lifespan lifespan) {
        if (this.closedLifespans.contains(lifespan)) {
            return;
        }
        this.encounteredLifespans.add(lifespan);
        this.closedLifespans.add(lifespan);
        for (OperatorFactory operatorFactory : this.operatorFactories) {
            operatorFactory.noMoreOperators(lifespan);
        }
    }

    public synchronized void noMoreDrivers() {
        if (this.closed) {
            return;
        }
        if (this.encounteredLifespans.size() != this.closedLifespans.size()) {
            Sets.difference(this.encounteredLifespans, this.closedLifespans).forEach(this::noMoreDrivers);
            Verify.verify((this.encounteredLifespans.size() == this.closedLifespans.size() ? 1 : 0) != 0);
        }
        this.closed = true;
        for (OperatorFactory operatorFactory : this.operatorFactories) {
            operatorFactory.noMoreOperators();
        }
    }
}

