/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.trino.array.LongBigArray;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.GroupedTopNBuilder;
import io.trino.operator.GroupedTopNRankAccumulator;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PageWithPositionEqualsAndHash;
import io.trino.operator.RowIdComparisonHashStrategy;
import io.trino.operator.RowReferencePageManager;
import io.trino.operator.TransformWork;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class GroupedTopNRankBuilder
implements GroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedTopNRankBuilder.class).instanceSize();
    private final List<Type> sourceTypes;
    private final boolean produceRanking;
    private final GroupByHash groupByHash;
    private final RowReferencePageManager pageManager = new RowReferencePageManager();
    private final GroupedTopNRankAccumulator groupedTopNRankAccumulator;

    public GroupedTopNRankBuilder(List<Type> sourceTypes, final PageWithPositionComparator comparator, final PageWithPositionEqualsAndHash equalsAndHash, int topN, boolean produceRanking, GroupByHash groupByHash) {
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null");
        Preconditions.checkArgument((topN > 0 ? 1 : 0) != 0, (Object)"topN must be > 0");
        this.produceRanking = produceRanking;
        this.groupByHash = Objects.requireNonNull(groupByHash, "groupByHash is null");
        Objects.requireNonNull(comparator, "comparator is null");
        Objects.requireNonNull(equalsAndHash, "equalsAndHash is null");
        this.groupedTopNRankAccumulator = new GroupedTopNRankAccumulator(new RowIdComparisonHashStrategy(){

            @Override
            public int compare(long leftRowId, long rightRowId) {
                Page leftPage = GroupedTopNRankBuilder.this.pageManager.getPage(leftRowId);
                int leftPosition = GroupedTopNRankBuilder.this.pageManager.getPosition(leftRowId);
                Page rightPage = GroupedTopNRankBuilder.this.pageManager.getPage(rightRowId);
                int rightPosition = GroupedTopNRankBuilder.this.pageManager.getPosition(rightRowId);
                return comparator.compareTo(leftPage, leftPosition, rightPage, rightPosition);
            }

            @Override
            public boolean equals(long leftRowId, long rightRowId) {
                Page leftPage = GroupedTopNRankBuilder.this.pageManager.getPage(leftRowId);
                int leftPosition = GroupedTopNRankBuilder.this.pageManager.getPosition(leftRowId);
                Page rightPage = GroupedTopNRankBuilder.this.pageManager.getPage(rightRowId);
                int rightPosition = GroupedTopNRankBuilder.this.pageManager.getPosition(rightRowId);
                return equalsAndHash.equals(leftPage, leftPosition, rightPage, rightPosition);
            }

            @Override
            public long hashCode(long rowId) {
                Page page = GroupedTopNRankBuilder.this.pageManager.getPage(rowId);
                int position = GroupedTopNRankBuilder.this.pageManager.getPosition(rowId);
                return equalsAndHash.hashCode(page, position);
            }
        }, topN, this.pageManager::dereference);
    }

    @Override
    public Work<?> processPage(Page page) {
        return new TransformWork<GroupByIdBlock, Object>(this.groupByHash.getGroupIds(page), groupIds -> {
            this.processPage(page, (GroupByIdBlock)groupIds);
            return null;
        });
    }

    @Override
    public Iterator<Page> buildResult() {
        return new ResultIterator();
    }

    @Override
    public long getEstimatedSizeInBytes() {
        return INSTANCE_SIZE + this.groupByHash.getEstimatedSize() + this.pageManager.sizeOf() + this.groupedTopNRankAccumulator.sizeOf();
    }

    private void processPage(Page newPage, GroupByIdBlock groupIds) {
        try (RowReferencePageManager.LoadCursor loadCursor = this.pageManager.add(newPage);){
            for (int position = 0; position < newPage.getPositionCount(); ++position) {
                long groupId = groupIds.getGroupId(position);
                loadCursor.advance();
                this.groupedTopNRankAccumulator.add(groupId, loadCursor);
            }
            Verify.verify((!loadCursor.advance() ? 1 : 0) != 0);
        }
        this.pageManager.compactIfNeeded();
    }

    private class ResultIterator
    extends AbstractIterator<Page> {
        private final PageBuilder pageBuilder;
        private final long groupIdCount;
        private long currentGroupId;
        private final LongBigArray rowIdOutput;
        private final LongBigArray rankingOutput;
        private long currentGroupSize;
        private int currentIndexInGroup;

        ResultIterator() {
            this.groupIdCount = GroupedTopNRankBuilder.this.groupByHash.getGroupCount();
            this.currentGroupId = -1L;
            this.rowIdOutput = new LongBigArray();
            this.rankingOutput = new LongBigArray();
            ImmutableList.Builder sourceTypesBuilders = new ImmutableList.Builder().addAll(GroupedTopNRankBuilder.this.sourceTypes);
            if (GroupedTopNRankBuilder.this.produceRanking) {
                sourceTypesBuilders.add((Object)BigintType.BIGINT);
            }
            this.pageBuilder = new PageBuilder((List)sourceTypesBuilders.build());
        }

        protected Page computeNext() {
            this.pageBuilder.reset();
            while (!this.pageBuilder.isFull()) {
                while ((long)this.currentIndexInGroup >= this.currentGroupSize) {
                    if (this.currentGroupId + 1L >= this.groupIdCount) {
                        if (this.pageBuilder.isEmpty()) {
                            return (Page)this.endOfData();
                        }
                        return this.pageBuilder.build();
                    }
                    ++this.currentGroupId;
                    this.currentGroupSize = GroupedTopNRankBuilder.this.produceRanking ? GroupedTopNRankBuilder.this.groupedTopNRankAccumulator.drainTo(this.currentGroupId, this.rowIdOutput, this.rankingOutput) : GroupedTopNRankBuilder.this.groupedTopNRankAccumulator.drainTo(this.currentGroupId, this.rowIdOutput);
                    this.currentIndexInGroup = 0;
                }
                long rowId = this.rowIdOutput.get((long)this.currentIndexInGroup);
                Page page = GroupedTopNRankBuilder.this.pageManager.getPage(rowId);
                int position = GroupedTopNRankBuilder.this.pageManager.getPosition(rowId);
                for (int i = 0; i < GroupedTopNRankBuilder.this.sourceTypes.size(); ++i) {
                    GroupedTopNRankBuilder.this.sourceTypes.get(i).appendTo(page.getBlock(i), position, this.pageBuilder.getBlockBuilder(i));
                }
                if (GroupedTopNRankBuilder.this.produceRanking) {
                    BigintType.BIGINT.writeLong(this.pageBuilder.getBlockBuilder(GroupedTopNRankBuilder.this.sourceTypes.size()), this.rankingOutput.get((long)this.currentIndexInGroup));
                }
                this.pageBuilder.declarePosition();
                ++this.currentIndexInGroup;
                GroupedTopNRankBuilder.this.pageManager.dereference(rowId);
            }
            if (this.pageBuilder.isEmpty()) {
                return (Page)this.endOfData();
            }
            return this.pageBuilder.build();
        }
    }
}

