/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AggregationMetadata {
    private final MethodHandle inputFunction;
    private final Optional<MethodHandle> removeInputFunction;
    private final Optional<MethodHandle> combineFunction;
    private final MethodHandle outputFunction;
    private final List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors;
    private final List<Class<?>> lambdaInterfaces;

    public AggregationMetadata(MethodHandle inputFunction, Optional<MethodHandle> removeInputFunction, Optional<MethodHandle> combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors) {
        this(inputFunction, removeInputFunction, combineFunction, outputFunction, accumulatorStateDescriptors, (List<Class<?>>)ImmutableList.of());
    }

    public AggregationMetadata(MethodHandle inputFunction, Optional<MethodHandle> removeInputFunction, Optional<MethodHandle> combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors, List<Class<?>> lambdaInterfaces) {
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
        this.removeInputFunction = Objects.requireNonNull(removeInputFunction, "removeInputFunction is null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction is null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
        this.accumulatorStateDescriptors = Objects.requireNonNull(accumulatorStateDescriptors, "accumulatorStateDescriptors is null");
        this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public Optional<MethodHandle> getRemoveInputFunction() {
        return this.removeInputFunction;
    }

    public Optional<MethodHandle> getCombineFunction() {
        return this.combineFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public List<AccumulatorStateDescriptor<?>> getAccumulatorStateDescriptors() {
        return this.accumulatorStateDescriptors;
    }

    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public static class AccumulatorStateDescriptor<T extends AccumulatorState> {
        private final Class<T> stateInterface;
        private final AccumulatorStateSerializer<T> serializer;
        private final AccumulatorStateFactory<T> factory;

        public AccumulatorStateDescriptor(Class<T> stateInterface, AccumulatorStateSerializer<T> serializer, AccumulatorStateFactory<T> factory) {
            this.stateInterface = Objects.requireNonNull(stateInterface, "stateInterface is null");
            this.serializer = Objects.requireNonNull(serializer, "serializer is null");
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public Class<T> getStateInterface() {
            return this.stateInterface;
        }

        public AccumulatorStateSerializer<T> getSerializer() {
            return this.serializer;
        }

        public AccumulatorStateFactory<T> getFactory() {
            return this.factory;
        }
    }
}

