/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.annotations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.operator.annotations.CastImplementationDependency;
import io.trino.operator.annotations.FunctionImplementationDependency;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.annotations.LiteralImplementationDependency;
import io.trino.operator.annotations.OperatorImplementationDependency;
import io.trino.operator.annotations.TypeImplementationDependency;
import io.trino.spi.function.CastDependency;
import io.trino.spi.function.Convention;
import io.trino.spi.function.FunctionDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.QualifiedName;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ImplementationDependency {
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder var1);

    public Object resolve(FunctionBinding var1, FunctionDependencies var2);

    public static boolean isImplementationDependencyAnnotation(Annotation annotation) {
        return annotation instanceof TypeParameter || annotation instanceof LiteralParameter || annotation instanceof FunctionDependency || annotation instanceof OperatorDependency || annotation instanceof CastDependency;
    }

    public static Optional<Annotation> getImplementationDependencyAnnotation(AnnotatedElement element) {
        if (!FunctionsParserHelper.containsImplementationDependencyAnnotation(element.getAnnotations())) {
            return Optional.empty();
        }
        Annotation[] annotations = element.getAnnotations();
        Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", (Object)element);
        return Optional.of(annotations[0]);
    }

    public static void validateImplementationDependencyAnnotation(AnnotatedElement element, Annotation annotation, Set<String> typeParametersNames, Collection<String> literalParameters) {
        if (annotation instanceof TypeParameter) {
            ImplementationDependency.checkTypeParameters(TypeSignatureTranslator.parseTypeSignature(((TypeParameter)annotation).value(), (Set<String>)ImmutableSet.of()), typeParametersNames, element);
        }
        if (annotation instanceof LiteralParameter) {
            Preconditions.checkArgument((boolean)literalParameters.contains(((LiteralParameter)annotation).value()), (String)"Parameter injected by @LiteralParameter must be declared with @LiteralParameters on the method [%s]", (Object)element);
        }
    }

    public static void checkTypeParameters(TypeSignature typeSignature, Set<String> typeParameterNames, AnnotatedElement element) {
        if (typeParameterNames.contains(typeSignature.getBase())) {
            Preconditions.checkArgument((boolean)typeSignature.getParameters().isEmpty(), (String)"Expected type parameter not to take parameters, but got '%s' on method [%s]", (Object)typeSignature.getBase(), (Object)element);
            return;
        }
        for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            Optional childTypeSignature = parameter.getTypeSignatureOrNamedTypeSignature();
            if (!childTypeSignature.isPresent()) continue;
            ImplementationDependency.checkTypeParameters((TypeSignature)childTypeSignature.get(), typeParameterNames, element);
        }
    }

    public static final class Factory {
        private Factory() {
        }

        public static ImplementationDependency createDependency(Annotation annotation, Set<String> literalParameters, Class<?> type) {
            if (annotation instanceof TypeParameter) {
                return new TypeImplementationDependency(((TypeParameter)annotation).value());
            }
            if (annotation instanceof LiteralParameter) {
                return new LiteralImplementationDependency(((LiteralParameter)annotation).value());
            }
            if (annotation instanceof FunctionDependency) {
                FunctionDependency functionDependency = (FunctionDependency)annotation;
                return new FunctionImplementationDependency(QualifiedName.of((String)functionDependency.name()), (List)Arrays.stream(functionDependency.argumentTypes()).map(signature -> TypeSignatureTranslator.parseTypeSignature(signature, literalParameters)).collect(ImmutableList.toImmutableList()), Factory.toInvocationConvention(functionDependency.convention()), type);
            }
            if (annotation instanceof OperatorDependency) {
                OperatorDependency operatorDependency = (OperatorDependency)annotation;
                OperatorType operator = operatorDependency.operator();
                Preconditions.checkArgument((operator != OperatorType.CAST && operator != OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0, (String)"%s not supported for OperatorDependency", (Object)operator);
                return new OperatorImplementationDependency(operator, (List)Arrays.stream(operatorDependency.argumentTypes()).map(signature -> TypeSignatureTranslator.parseTypeSignature(signature, literalParameters)).collect(ImmutableList.toImmutableList()), Factory.toInvocationConvention(operatorDependency.convention()), type);
            }
            if (annotation instanceof CastDependency) {
                CastDependency castDependency = (CastDependency)annotation;
                return new CastImplementationDependency(TypeSignatureTranslator.parseTypeSignature(castDependency.fromType(), literalParameters), TypeSignatureTranslator.parseTypeSignature(castDependency.toType(), literalParameters), Factory.toInvocationConvention(castDependency.convention()), type);
            }
            throw new IllegalArgumentException("Unsupported annotation " + annotation);
        }

        private static InvocationConvention toInvocationConvention(Convention convention) {
            ArrayList argumentConventions = new ArrayList();
            Collections.addAll(argumentConventions, convention.arguments());
            return new InvocationConvention(argumentConventions, convention.result(), convention.session(), false);
        }
    }
}

