/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import io.trino.operator.aggregation.ApproximateSetAggregation;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;

public final class HyperLogLogFunctions {
    private HyperLogLogFunctions() {
    }

    @ScalarFunction
    @Description(value="Compute the cardinality of a HyperLogLog instance")
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="HyperLogLog") Slice serializedHll) {
        return HyperLogLog.newInstance((Slice)serializedHll).cardinality();
    }

    @ScalarFunction
    @Description(value="An empty HyperLogLog instance")
    @SqlType(value="HyperLogLog")
    public static Slice emptyApproxSet() {
        return ApproximateSetAggregation.newHyperLogLog().serialize();
    }
}

